/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableMultimap;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureCheck {
    private static final Logger f_197235_ = LogManager.getLogger();
    private static final int f_197236_ = -1;
    private final ChunkScanAccess f_197237_;
    private final RegistryAccess f_197238_;
    private final Registry<Biome> f_197239_;
    private final StructureManager f_197240_;
    private final ResourceKey<Level> f_197241_;
    private final ChunkGenerator f_197242_;
    private final LevelHeightAccessor f_197243_;
    private final BiomeSource f_197244_;
    private final long f_197245_;
    private final DataFixer f_197246_;
    private final Long2ObjectMap<Object2IntMap<StructureFeature<?>>> f_197247_ = new Long2ObjectOpenHashMap();
    private final Map<StructureFeature<?>, Long2BooleanMap> f_197248_ = new HashMap();

    public StructureCheck(ChunkScanAccess p_197251_, RegistryAccess p_197252_, StructureManager p_197253_, ResourceKey<Level> p_197254_, ChunkGenerator p_197255_, LevelHeightAccessor p_197256_, BiomeSource p_197257_, long p_197258_, DataFixer p_197259_) {
        this.f_197237_ = p_197251_;
        this.f_197238_ = p_197252_;
        this.f_197240_ = p_197253_;
        this.f_197241_ = p_197254_;
        this.f_197242_ = p_197255_;
        this.f_197243_ = p_197256_;
        this.f_197244_ = p_197257_;
        this.f_197245_ = p_197258_;
        this.f_197246_ = p_197259_;
        this.f_197239_ = p_197252_.m_175512_(Registry.f_122885_);
    }

    public <F extends StructureFeature<?>> StructureCheckResult m_197273_(ChunkPos p_197274_, F p_197275_, boolean p_197276_) {
        long $$3 = p_197274_.m_45588_();
        Object2IntMap $$4 = (Object2IntMap)this.f_197247_.get($$3);
        if ($$4 != null) {
            return this.m_197304_($$4, p_197275_, p_197276_);
        }
        StructureCheckResult $$5 = this.m_197277_(p_197274_, p_197275_, p_197276_, $$3);
        if ($$5 != null) {
            return $$5;
        }
        boolean $$6 = this.f_197248_.computeIfAbsent(p_197275_, p_197286_ -> new Long2BooleanOpenHashMap()).computeIfAbsent($$3, p_197290_ -> {
            ImmutableMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> $$3 = this.f_197242_.m_62205_().m_189371_(p_197275_);
            for (Map.Entry $$4 : $$3.asMap().entrySet()) {
                if (!this.m_197266_(p_197274_, (ConfiguredStructureFeature)$$4.getKey(), (Collection)$$4.getValue())) continue;
                return true;
            }
            return false;
        });
        if (!$$6) {
            return StructureCheckResult.START_NOT_PRESENT;
        }
        return StructureCheckResult.CHUNK_LOAD_NEEDED;
    }

    private <FC extends FeatureConfiguration, F extends StructureFeature<FC>> boolean m_197266_(ChunkPos p_197267_, ConfiguredStructureFeature<FC, F> p_197268_, Collection<ResourceKey<Biome>> p_197269_) {
        Predicate<Biome> $$3 = p_197310_ -> this.f_197239_.m_7854_((Biome)p_197310_).filter(p_197269_::contains).isPresent();
        return ((StructureFeature)p_197268_.f_65403_).m_197171_(this.f_197238_, this.f_197242_, this.f_197244_, this.f_197240_, this.f_197245_, p_197267_, p_197268_.f_65404_, this.f_197243_, $$3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private StructureCheckResult m_197277_(ChunkPos p_197278_, StructureFeature<?> p_197279_, boolean p_197280_, long p_197281_) {
        void $$11;
        CollectFields $$4 = new CollectFields(new CollectFields.WantedField(IntTag.f_128670_, "DataVersion"), new CollectFields.WantedField("Level", "Structures", CompoundTag.f_128326_, "Starts"), new CollectFields.WantedField("structures", CompoundTag.f_128326_, "starts"));
        try {
            this.f_197237_.m_196358_(p_197278_, $$4).join();
        }
        catch (Exception $$5) {
            f_197235_.warn("Failed to read chunk {}", (Object)p_197278_, (Object)$$5);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Tag $$6 = $$4.m_197713_();
        if (!($$6 instanceof CompoundTag)) {
            return null;
        }
        CompoundTag $$7 = (CompoundTag)$$6;
        int $$8 = ChunkStorage.m_63505_($$7);
        if ($$8 <= 1493) {
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        ChunkStorage.m_196918_($$7, this.f_197241_, this.f_197242_.m_187743_());
        try {
            CompoundTag $$9 = NbtUtils.m_129213_(this.f_197246_, DataFixTypes.CHUNK, $$7, $$8);
        }
        catch (Exception $$10) {
            f_197235_.warn("Failed to partially datafix chunk {}", (Object)p_197278_, (Object)$$10);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Object2IntMap<StructureFeature<?>> $$12 = this.m_197311_((CompoundTag)$$11);
        if ($$12 == null) {
            return null;
        }
        this.m_197263_(p_197281_, $$12);
        return this.m_197304_($$12, p_197279_, p_197280_);
    }

    @Nullable
    private Object2IntMap<StructureFeature<?>> m_197311_(CompoundTag p_197312_) {
        if (!p_197312_.m_128425_("structures", 10)) {
            return null;
        }
        CompoundTag $$1 = p_197312_.m_128469_("structures");
        if (!$$1.m_128425_("starts", 10)) {
            return null;
        }
        CompoundTag $$2 = $$1.m_128469_("starts");
        if ($$2.m_128456_()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap $$3 = new Object2IntOpenHashMap();
        for (String $$4 : $$2.m_128431_()) {
            String $$8;
            CompoundTag $$7;
            String $$5 = $$4.toLowerCase(Locale.ROOT);
            StructureFeature $$6 = (StructureFeature)StructureFeature.f_67012_.get((Object)$$5);
            if ($$6 == null || ($$7 = $$2.m_128469_($$4)).m_128456_() || "INVALID".equals($$8 = $$7.m_128461_("id"))) continue;
            int $$9 = $$7.m_128451_("references");
            $$3.put((Object)$$6, $$9);
        }
        return $$3;
    }

    private static Object2IntMap<StructureFeature<?>> m_197298_(Object2IntMap<StructureFeature<?>> p_197299_) {
        return p_197299_.isEmpty() ? Object2IntMaps.emptyMap() : p_197299_;
    }

    private StructureCheckResult m_197304_(Object2IntMap<StructureFeature<?>> p_197305_, StructureFeature<?> p_197306_, boolean p_197307_) {
        int $$3 = p_197305_.getOrDefault(p_197306_, -1);
        return $$3 != -1 && (!p_197307_ || $$3 == 0) ? StructureCheckResult.START_PRESENT : StructureCheckResult.START_NOT_PRESENT;
    }

    public void m_197282_(ChunkPos p_197283_, Map<StructureFeature<?>, StructureStart<?>> p_197284_) {
        long $$2 = p_197283_.m_45588_();
        Object2IntOpenHashMap $$3 = new Object2IntOpenHashMap();
        p_197284_.forEach((arg_0, arg_1) -> StructureCheck.m_197300_((Object2IntMap)$$3, arg_0, arg_1));
        this.m_197263_($$2, (Object2IntMap<StructureFeature<?>>)$$3);
    }

    private void m_197263_(long p_197264_, Object2IntMap<StructureFeature<?>> p_197265_) {
        this.f_197247_.put(p_197264_, StructureCheck.m_197298_(p_197265_));
        this.f_197248_.values().forEach(p_197262_ -> p_197262_.remove(p_197264_));
    }

    public void m_197270_(ChunkPos p_197271_, StructureFeature<?> p_197272_) {
        this.f_197247_.compute(p_197271_.m_45588_(), (p_197296_, p_197297_) -> {
            if (p_197297_ == null || p_197297_.isEmpty()) {
                p_197297_ = new Object2IntOpenHashMap();
            }
            p_197297_.computeInt((Object)p_197272_, (p_197292_, p_197293_) -> p_197293_ == null ? 1 : p_197293_ + 1);
            return p_197297_;
        });
    }

    private static /* synthetic */ void m_197300_(Object2IntMap p_197301_, StructureFeature p_197302_, StructureStart p_197303_) {
        if (p_197303_.m_73603_()) {
            p_197301_.put((Object)p_197302_, p_197303_.m_73608_());
        }
    }
}

