/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class NetherBridgePieces {
    private static final int f_162621_ = 30;
    private static final int f_162622_ = 10;
    public static final int f_192079_ = 64;
    static final PieceWeight[] f_71539_ = new PieceWeight[]{new PieceWeight(BridgeStraight.class, 30, 0, true), new PieceWeight(BridgeCrossing.class, 10, 4), new PieceWeight(RoomCrossing.class, 10, 4), new PieceWeight(StairsRoom.class, 10, 3), new PieceWeight(MonsterThrone.class, 5, 2), new PieceWeight(CastleEntrance.class, 5, 1)};
    static final PieceWeight[] f_71540_ = new PieceWeight[]{new PieceWeight(CastleSmallCorridorPiece.class, 25, 0, true), new PieceWeight(CastleSmallCorridorCrossingPiece.class, 15, 5), new PieceWeight(CastleSmallCorridorRightTurnPiece.class, 5, 10), new PieceWeight(CastleSmallCorridorLeftTurnPiece.class, 5, 10), new PieceWeight(CastleCorridorStairsPiece.class, 10, 3, true), new PieceWeight(CastleCorridorTBalconyPiece.class, 7, 2), new PieceWeight(CastleStalkRoom.class, 5, 2)};

    static NetherBridgePiece m_162624_(PieceWeight p_162625_, StructurePieceAccessor p_162626_, Random p_162627_, int p_162628_, int p_162629_, int p_162630_, Direction p_162631_, int p_162632_) {
        Class<? extends NetherBridgePiece> $$8 = p_162625_.f_71950_;
        NetherBridgePiece $$9 = null;
        if ($$8 == BridgeStraight.class) {
            $$9 = BridgeStraight.m_162681_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == BridgeCrossing.class) {
            $$9 = BridgeCrossing.m_162647_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == RoomCrossing.class) {
            $$9 = RoomCrossing.m_162908_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == StairsRoom.class) {
            $$9 = StairsRoom.m_162925_(p_162626_, p_162628_, p_162629_, p_162630_, p_162632_, p_162631_);
        } else if ($$8 == MonsterThrone.class) {
            $$9 = MonsterThrone.m_162843_(p_162626_, p_162628_, p_162629_, p_162630_, p_162632_, p_162631_);
        } else if ($$8 == CastleEntrance.class) {
            $$9 = CastleEntrance.m_162733_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == CastleSmallCorridorPiece.class) {
            $$9 = CastleSmallCorridorPiece.m_162789_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == CastleSmallCorridorRightTurnPiece.class) {
            $$9 = CastleSmallCorridorRightTurnPiece.m_162809_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == CastleSmallCorridorLeftTurnPiece.class) {
            $$9 = CastleSmallCorridorLeftTurnPiece.m_162771_(p_162626_, p_162627_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == CastleCorridorStairsPiece.class) {
            $$9 = CastleCorridorStairsPiece.m_162699_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == CastleCorridorTBalconyPiece.class) {
            $$9 = CastleCorridorTBalconyPiece.m_162716_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == CastleSmallCorridorCrossingPiece.class) {
            $$9 = CastleSmallCorridorCrossingPiece.m_162751_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        } else if ($$8 == CastleStalkRoom.class) {
            $$9 = CastleStalkRoom.m_162827_(p_162626_, p_162628_, p_162629_, p_162630_, p_162631_, p_162632_);
        }
        return $$9;
    }

    static class PieceWeight {
        public final Class<? extends NetherBridgePiece> f_71950_;
        public final int f_71951_;
        public int f_71952_;
        public final int f_71953_;
        public final boolean f_71954_;

        public PieceWeight(Class<? extends NetherBridgePiece> p_71960_, int p_71961_, int p_71962_, boolean p_71963_) {
            this.f_71950_ = p_71960_;
            this.f_71951_ = p_71961_;
            this.f_71953_ = p_71962_;
            this.f_71954_ = p_71963_;
        }

        public PieceWeight(Class<? extends NetherBridgePiece> p_71956_, int p_71957_, int p_71958_) {
            this(p_71956_, p_71957_, p_71958_, false);
        }

        public boolean m_71965_(int p_71966_) {
            return this.f_71953_ == 0 || this.f_71952_ < this.f_71953_;
        }

        public boolean m_71964_() {
            return this.f_71953_ == 0 || this.f_71952_ < this.f_71953_;
        }
    }

    public static class BridgeStraight
    extends NetherBridgePiece {
        private static final int f_162671_ = 5;
        private static final int f_162672_ = 10;
        private static final int f_162673_ = 19;

        public BridgeStraight(int p_71625_, Random p_71626_, BoundingBox p_71627_, Direction p_71628_) {
            super(StructurePieceType.f_67142_, p_71625_, p_71627_);
            this.m_73519_(p_71628_);
        }

        public BridgeStraight(CompoundTag p_192104_) {
            super(StructurePieceType.f_67142_, p_192104_);
        }

        @Override
        public void m_142537_(StructurePiece p_162678_, StructurePieceAccessor p_162679_, Random p_162680_) {
            this.m_162867_((StartPiece)p_162678_, p_162679_, p_162680_, 1, 3, false);
        }

        public static BridgeStraight m_162681_(StructurePieceAccessor p_162682_, Random p_162683_, int p_162684_, int p_162685_, int p_162686_, Direction p_162687_, int p_162688_) {
            BoundingBox $$7 = BoundingBox.m_71031_(p_162684_, p_162685_, p_162686_, -1, -3, 0, 5, 10, 19, p_162687_);
            if (!BridgeStraight.m_71903_($$7) || p_162682_.m_141921_($$7) != null) {
                return null;
            }
            return new BridgeStraight(p_162688_, p_162683_, $$7, p_162687_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192106_, StructureFeatureManager p_192107_, ChunkGenerator p_192108_, Random p_192109_, BoundingBox p_192110_, ChunkPos p_192111_, BlockPos p_192112_) {
            this.m_73441_(p_192106_, p_192110_, 0, 3, 0, 4, 4, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192106_, p_192110_, 1, 5, 0, 3, 7, 18, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192106_, p_192110_, 0, 5, 0, 0, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192106_, p_192110_, 4, 5, 0, 4, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192106_, p_192110_, 0, 2, 0, 4, 2, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192106_, p_192110_, 0, 2, 13, 4, 2, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192106_, p_192110_, 0, 0, 0, 4, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192106_, p_192110_, 0, 0, 15, 4, 1, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$7 = 0; $$7 <= 4; ++$$7) {
                for (int $$8 = 0; $$8 <= 2; ++$$8) {
                    this.m_73528_(p_192106_, Blocks.f_50197_.m_49966_(), $$7, -1, $$8, p_192110_);
                    this.m_73528_(p_192106_, Blocks.f_50197_.m_49966_(), $$7, -1, 18 - $$8, p_192110_);
                }
            }
            BlockState $$9 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            BlockState $$10 = (BlockState)$$9.m_61124_(FenceBlock.f_52310_, true);
            BlockState $$11 = (BlockState)$$9.m_61124_(FenceBlock.f_52312_, true);
            this.m_73441_(p_192106_, p_192110_, 0, 1, 1, 0, 4, 1, $$10, $$10, false);
            this.m_73441_(p_192106_, p_192110_, 0, 3, 4, 0, 4, 4, $$10, $$10, false);
            this.m_73441_(p_192106_, p_192110_, 0, 3, 14, 0, 4, 14, $$10, $$10, false);
            this.m_73441_(p_192106_, p_192110_, 0, 1, 17, 0, 4, 17, $$10, $$10, false);
            this.m_73441_(p_192106_, p_192110_, 4, 1, 1, 4, 4, 1, $$11, $$11, false);
            this.m_73441_(p_192106_, p_192110_, 4, 3, 4, 4, 4, 4, $$11, $$11, false);
            this.m_73441_(p_192106_, p_192110_, 4, 3, 14, 4, 4, 14, $$11, $$11, false);
            this.m_73441_(p_192106_, p_192110_, 4, 1, 17, 4, 4, 17, $$11, $$11, false);
        }
    }

    public static class BridgeCrossing
    extends NetherBridgePiece {
        private static final int f_162633_ = 19;
        private static final int f_162634_ = 10;
        private static final int f_162635_ = 19;

        public BridgeCrossing(int p_71565_, BoundingBox p_71566_, Direction p_71567_) {
            super(StructurePieceType.f_67140_, p_71565_, p_71566_);
            this.m_73519_(p_71567_);
        }

        protected BridgeCrossing(int p_162637_, int p_162638_, Direction p_162639_) {
            super(StructurePieceType.f_67140_, 0, StructurePiece.m_163541_(p_162637_, 64, p_162638_, p_162639_, 19, 10, 19));
            this.m_73519_(p_162639_);
        }

        protected BridgeCrossing(StructurePieceType p_71569_, CompoundTag p_71570_) {
            super(p_71569_, p_71570_);
        }

        public BridgeCrossing(CompoundTag p_192081_) {
            this(StructurePieceType.f_67140_, p_192081_);
        }

        @Override
        public void m_142537_(StructurePiece p_162644_, StructurePieceAccessor p_162645_, Random p_162646_) {
            this.m_162867_((StartPiece)p_162644_, p_162645_, p_162646_, 8, 3, false);
            this.m_162884_((StartPiece)p_162644_, p_162645_, p_162646_, 3, 8, false);
            this.m_162891_((StartPiece)p_162644_, p_162645_, p_162646_, 3, 8, false);
        }

        public static BridgeCrossing m_162647_(StructurePieceAccessor p_162648_, int p_162649_, int p_162650_, int p_162651_, Direction p_162652_, int p_162653_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162649_, p_162650_, p_162651_, -8, -3, 0, 19, 10, 19, p_162652_);
            if (!BridgeCrossing.m_71903_($$6) || p_162648_.m_141921_($$6) != null) {
                return null;
            }
            return new BridgeCrossing(p_162653_, $$6, p_162652_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192083_, StructureFeatureManager p_192084_, ChunkGenerator p_192085_, Random p_192086_, BoundingBox p_192087_, ChunkPos p_192088_, BlockPos p_192089_) {
            this.m_73441_(p_192083_, p_192087_, 7, 3, 0, 11, 4, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 0, 3, 7, 18, 4, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 8, 5, 0, 10, 7, 18, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 0, 5, 8, 18, 7, 10, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 7, 5, 0, 7, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 7, 5, 11, 7, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 11, 5, 0, 11, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 11, 5, 11, 11, 5, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 0, 5, 7, 7, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 11, 5, 7, 18, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 0, 5, 11, 7, 5, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 11, 5, 11, 18, 5, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 7, 2, 0, 11, 2, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 7, 2, 13, 11, 2, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 7, 0, 0, 11, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 7, 0, 15, 11, 1, 18, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$7 = 7; $$7 <= 11; ++$$7) {
                for (int $$8 = 0; $$8 <= 2; ++$$8) {
                    this.m_73528_(p_192083_, Blocks.f_50197_.m_49966_(), $$7, -1, $$8, p_192087_);
                    this.m_73528_(p_192083_, Blocks.f_50197_.m_49966_(), $$7, -1, 18 - $$8, p_192087_);
                }
            }
            this.m_73441_(p_192083_, p_192087_, 0, 2, 7, 5, 2, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 13, 2, 7, 18, 2, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 0, 0, 7, 3, 1, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192083_, p_192087_, 15, 0, 7, 18, 1, 11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$9 = 0; $$9 <= 2; ++$$9) {
                for (int $$10 = 7; $$10 <= 11; ++$$10) {
                    this.m_73528_(p_192083_, Blocks.f_50197_.m_49966_(), $$9, -1, $$10, p_192087_);
                    this.m_73528_(p_192083_, Blocks.f_50197_.m_49966_(), 18 - $$9, -1, $$10, p_192087_);
                }
            }
        }
    }

    public static class RoomCrossing
    extends NetherBridgePiece {
        private static final int f_162898_ = 7;
        private static final int f_162899_ = 9;
        private static final int f_162900_ = 7;

        public RoomCrossing(int p_71968_, BoundingBox p_71969_, Direction p_71970_) {
            super(StructurePieceType.f_67152_, p_71968_, p_71969_);
            this.m_73519_(p_71970_);
        }

        public RoomCrossing(CompoundTag p_192216_) {
            super(StructurePieceType.f_67152_, p_192216_);
        }

        @Override
        public void m_142537_(StructurePiece p_162905_, StructurePieceAccessor p_162906_, Random p_162907_) {
            this.m_162867_((StartPiece)p_162905_, p_162906_, p_162907_, 2, 0, false);
            this.m_162884_((StartPiece)p_162905_, p_162906_, p_162907_, 0, 2, false);
            this.m_162891_((StartPiece)p_162905_, p_162906_, p_162907_, 0, 2, false);
        }

        public static RoomCrossing m_162908_(StructurePieceAccessor p_162909_, int p_162910_, int p_162911_, int p_162912_, Direction p_162913_, int p_162914_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162910_, p_162911_, p_162912_, -2, 0, 0, 7, 9, 7, p_162913_);
            if (!RoomCrossing.m_71903_($$6) || p_162909_.m_141921_($$6) != null) {
                return null;
            }
            return new RoomCrossing(p_162914_, $$6, p_162913_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192218_, StructureFeatureManager p_192219_, ChunkGenerator p_192220_, Random p_192221_, BoundingBox p_192222_, ChunkPos p_192223_, BlockPos p_192224_) {
            this.m_73441_(p_192218_, p_192222_, 0, 0, 0, 6, 1, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 0, 2, 0, 6, 7, 6, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 0, 2, 0, 1, 6, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 0, 2, 6, 1, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 5, 2, 0, 6, 6, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 5, 2, 6, 6, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 0, 2, 0, 0, 6, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 0, 2, 5, 0, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 6, 2, 0, 6, 6, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 6, 2, 5, 6, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_192218_, p_192222_, 2, 6, 0, 4, 6, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 2, 5, 0, 4, 5, 0, $$7, $$7, false);
            this.m_73441_(p_192218_, p_192222_, 2, 6, 6, 4, 6, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 2, 5, 6, 4, 5, 6, $$7, $$7, false);
            this.m_73441_(p_192218_, p_192222_, 0, 6, 2, 0, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 0, 5, 2, 0, 5, 4, $$8, $$8, false);
            this.m_73441_(p_192218_, p_192222_, 6, 6, 2, 6, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192218_, p_192222_, 6, 5, 2, 6, 5, 4, $$8, $$8, false);
            for (int $$9 = 0; $$9 <= 6; ++$$9) {
                for (int $$10 = 0; $$10 <= 6; ++$$10) {
                    this.m_73528_(p_192218_, Blocks.f_50197_.m_49966_(), $$9, -1, $$10, p_192222_);
                }
            }
        }
    }

    public static class StairsRoom
    extends NetherBridgePiece {
        private static final int f_162915_ = 7;
        private static final int f_162916_ = 11;
        private static final int f_162917_ = 7;

        public StairsRoom(int p_71994_, BoundingBox p_71995_, Direction p_71996_) {
            super(StructurePieceType.f_67153_, p_71994_, p_71995_);
            this.m_73519_(p_71996_);
        }

        public StairsRoom(CompoundTag p_192226_) {
            super(StructurePieceType.f_67153_, p_192226_);
        }

        @Override
        public void m_142537_(StructurePiece p_162922_, StructurePieceAccessor p_162923_, Random p_162924_) {
            this.m_162891_((StartPiece)p_162922_, p_162923_, p_162924_, 6, 2, false);
        }

        public static StairsRoom m_162925_(StructurePieceAccessor p_162926_, int p_162927_, int p_162928_, int p_162929_, int p_162930_, Direction p_162931_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162927_, p_162928_, p_162929_, -2, 0, 0, 7, 11, 7, p_162931_);
            if (!StairsRoom.m_71903_($$6) || p_162926_.m_141921_($$6) != null) {
                return null;
            }
            return new StairsRoom(p_162930_, $$6, p_162931_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192228_, StructureFeatureManager p_192229_, ChunkGenerator p_192230_, Random p_192231_, BoundingBox p_192232_, ChunkPos p_192233_, BlockPos p_192234_) {
            this.m_73441_(p_192228_, p_192232_, 0, 0, 0, 6, 1, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 0, 2, 0, 6, 10, 6, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 0, 2, 0, 1, 8, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 5, 2, 0, 6, 8, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 0, 2, 1, 0, 8, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 6, 2, 1, 6, 8, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 1, 2, 6, 5, 8, 6, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_192228_, p_192232_, 0, 3, 2, 0, 5, 4, $$8, $$8, false);
            this.m_73441_(p_192228_, p_192232_, 6, 3, 2, 6, 5, 2, $$8, $$8, false);
            this.m_73441_(p_192228_, p_192232_, 6, 3, 4, 6, 5, 4, $$8, $$8, false);
            this.m_73434_(p_192228_, Blocks.f_50197_.m_49966_(), 5, 2, 5, p_192232_);
            this.m_73441_(p_192228_, p_192232_, 4, 2, 5, 4, 3, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 3, 2, 5, 3, 4, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 2, 2, 5, 2, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 1, 2, 5, 1, 6, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 1, 7, 1, 5, 7, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 6, 8, 2, 6, 8, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 2, 6, 0, 4, 8, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192228_, p_192232_, 2, 5, 0, 4, 5, 0, $$7, $$7, false);
            for (int $$9 = 0; $$9 <= 6; ++$$9) {
                for (int $$10 = 0; $$10 <= 6; ++$$10) {
                    this.m_73528_(p_192228_, Blocks.f_50197_.m_49966_(), $$9, -1, $$10, p_192232_);
                }
            }
        }
    }

    public static class MonsterThrone
    extends NetherBridgePiece {
        private static final int f_162834_ = 7;
        private static final int f_162835_ = 8;
        private static final int f_162836_ = 9;
        private boolean f_71872_;

        public MonsterThrone(int p_71874_, BoundingBox p_71875_, Direction p_71876_) {
            super(StructurePieceType.f_67151_, p_71874_, p_71875_);
            this.m_73519_(p_71876_);
        }

        public MonsterThrone(CompoundTag p_192200_) {
            super(StructurePieceType.f_67151_, p_192200_);
            this.f_71872_ = p_192200_.m_128471_("Mob");
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192210_, CompoundTag p_192211_) {
            super.m_183620_(p_192210_, p_192211_);
            p_192211_.m_128379_("Mob", this.f_71872_);
        }

        public static MonsterThrone m_162843_(StructurePieceAccessor p_162844_, int p_162845_, int p_162846_, int p_162847_, int p_162848_, Direction p_162849_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162845_, p_162846_, p_162847_, -2, 0, 0, 7, 8, 9, p_162849_);
            if (!MonsterThrone.m_71903_($$6) || p_162844_.m_141921_($$6) != null) {
                return null;
            }
            return new MonsterThrone(p_162848_, $$6, p_162849_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192202_, StructureFeatureManager p_192203_, ChunkGenerator p_192204_, Random p_192205_, BoundingBox p_192206_, ChunkPos p_192207_, BlockPos p_192208_) {
            BlockPos.MutableBlockPos $$9;
            this.m_73441_(p_192202_, p_192206_, 0, 2, 0, 6, 7, 7, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 1, 0, 0, 5, 1, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 1, 2, 1, 5, 2, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 1, 3, 2, 5, 3, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 1, 4, 3, 5, 4, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 1, 2, 0, 1, 4, 2, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 5, 2, 0, 5, 4, 2, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 1, 5, 2, 1, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 5, 5, 2, 5, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 0, 5, 3, 0, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 6, 5, 3, 6, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192202_, p_192206_, 1, 5, 8, 5, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73434_(p_192202_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true), 1, 6, 3, p_192206_);
            this.m_73434_(p_192202_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true), 5, 6, 3, p_192206_);
            this.m_73434_(p_192202_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true)).m_61124_(FenceBlock.f_52309_, true), 0, 6, 3, p_192206_);
            this.m_73434_(p_192202_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52309_, true), 6, 6, 3, p_192206_);
            this.m_73441_(p_192202_, p_192206_, 0, 6, 4, 0, 6, 7, $$8, $$8, false);
            this.m_73441_(p_192202_, p_192206_, 6, 6, 4, 6, 6, 7, $$8, $$8, false);
            this.m_73434_(p_192202_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true)).m_61124_(FenceBlock.f_52311_, true), 0, 6, 8, p_192206_);
            this.m_73434_(p_192202_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52311_, true), 6, 6, 8, p_192206_);
            this.m_73441_(p_192202_, p_192206_, 1, 6, 8, 5, 6, 8, $$7, $$7, false);
            this.m_73434_(p_192202_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true), 1, 7, 8, p_192206_);
            this.m_73441_(p_192202_, p_192206_, 2, 7, 8, 4, 7, 8, $$7, $$7, false);
            this.m_73434_(p_192202_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true), 5, 7, 8, p_192206_);
            this.m_73434_(p_192202_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true), 2, 8, 8, p_192206_);
            this.m_73434_(p_192202_, $$7, 3, 8, 8, p_192206_);
            this.m_73434_(p_192202_, (BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true), 4, 8, 8, p_192206_);
            if (!this.f_71872_ && p_192206_.m_71051_($$9 = this.m_163582_(3, 5, 5))) {
                this.f_71872_ = true;
                p_192202_.m_7731_($$9, Blocks.f_50085_.m_49966_(), 2);
                BlockEntity $$10 = p_192202_.m_7702_($$9);
                if ($$10 instanceof SpawnerBlockEntity) {
                    ((SpawnerBlockEntity)$$10).m_59801_().m_45462_(EntityType.f_20551_);
                }
            }
            for (int $$11 = 0; $$11 <= 6; ++$$11) {
                for (int $$12 = 0; $$12 <= 6; ++$$12) {
                    this.m_73528_(p_192202_, Blocks.f_50197_.m_49966_(), $$11, -1, $$12, p_192206_);
                }
            }
        }
    }

    public static class CastleEntrance
    extends NetherBridgePiece {
        private static final int f_162723_ = 13;
        private static final int f_162724_ = 14;
        private static final int f_162725_ = 13;

        public CastleEntrance(int p_71705_, Random p_71706_, BoundingBox p_71707_, Direction p_71708_) {
            super(StructurePieceType.f_67145_, p_71705_, p_71707_);
            this.m_73519_(p_71708_);
        }

        public CastleEntrance(CompoundTag p_192134_) {
            super(StructurePieceType.f_67145_, p_192134_);
        }

        @Override
        public void m_142537_(StructurePiece p_162730_, StructurePieceAccessor p_162731_, Random p_162732_) {
            this.m_162867_((StartPiece)p_162730_, p_162731_, p_162732_, 5, 3, true);
        }

        public static CastleEntrance m_162733_(StructurePieceAccessor p_162734_, Random p_162735_, int p_162736_, int p_162737_, int p_162738_, Direction p_162739_, int p_162740_) {
            BoundingBox $$7 = BoundingBox.m_71031_(p_162736_, p_162737_, p_162738_, -5, -3, 0, 13, 14, 13, p_162739_);
            if (!CastleEntrance.m_71903_($$7) || p_162734_.m_141921_($$7) != null) {
                return null;
            }
            return new CastleEntrance(p_162740_, p_162735_, $$7, p_162739_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192136_, StructureFeatureManager p_192137_, ChunkGenerator p_192138_, Random p_192139_, BoundingBox p_192140_, ChunkPos p_192141_, BlockPos p_192142_) {
            this.m_73441_(p_192136_, p_192140_, 0, 3, 0, 12, 4, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 0, 5, 0, 12, 13, 12, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 0, 5, 0, 1, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 11, 5, 0, 12, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 2, 5, 11, 4, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 8, 5, 11, 10, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 5, 9, 11, 7, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 2, 5, 0, 4, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 8, 5, 0, 10, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 5, 9, 0, 7, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 2, 11, 2, 10, 12, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 5, 8, 0, 7, 8, 0, Blocks.f_50198_.m_49966_(), Blocks.f_50198_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            for (int $$9 = 1; $$9 <= 11; $$9 += 2) {
                this.m_73441_(p_192136_, p_192140_, $$9, 10, 0, $$9, 11, 0, $$7, $$7, false);
                this.m_73441_(p_192136_, p_192140_, $$9, 10, 12, $$9, 11, 12, $$7, $$7, false);
                this.m_73441_(p_192136_, p_192140_, 0, 10, $$9, 0, 11, $$9, $$8, $$8, false);
                this.m_73441_(p_192136_, p_192140_, 12, 10, $$9, 12, 11, $$9, $$8, $$8, false);
                this.m_73434_(p_192136_, Blocks.f_50197_.m_49966_(), $$9, 13, 0, p_192140_);
                this.m_73434_(p_192136_, Blocks.f_50197_.m_49966_(), $$9, 13, 12, p_192140_);
                this.m_73434_(p_192136_, Blocks.f_50197_.m_49966_(), 0, 13, $$9, p_192140_);
                this.m_73434_(p_192136_, Blocks.f_50197_.m_49966_(), 12, 13, $$9, p_192140_);
                if ($$9 == 11) continue;
                this.m_73434_(p_192136_, $$7, $$9 + 1, 13, 0, p_192140_);
                this.m_73434_(p_192136_, $$7, $$9 + 1, 13, 12, p_192140_);
                this.m_73434_(p_192136_, $$8, 0, 13, $$9 + 1, p_192140_);
                this.m_73434_(p_192136_, $$8, 12, 13, $$9 + 1, p_192140_);
            }
            this.m_73434_(p_192136_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 0, p_192140_);
            this.m_73434_(p_192136_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 12, p_192140_);
            this.m_73434_(p_192136_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 12, p_192140_);
            this.m_73434_(p_192136_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 0, p_192140_);
            for (int $$10 = 3; $$10 <= 9; $$10 += 2) {
                this.m_73441_(p_192136_, p_192140_, 1, 7, $$10, 1, 8, $$10, (BlockState)$$8.m_61124_(FenceBlock.f_52312_, true), (BlockState)$$8.m_61124_(FenceBlock.f_52312_, true), false);
                this.m_73441_(p_192136_, p_192140_, 11, 7, $$10, 11, 8, $$10, (BlockState)$$8.m_61124_(FenceBlock.f_52310_, true), (BlockState)$$8.m_61124_(FenceBlock.f_52310_, true), false);
            }
            this.m_73441_(p_192136_, p_192140_, 4, 2, 0, 8, 2, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 0, 2, 4, 12, 2, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 4, 0, 0, 8, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 4, 0, 9, 8, 1, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 0, 0, 4, 3, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 9, 0, 4, 12, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$11 = 4; $$11 <= 8; ++$$11) {
                for (int $$12 = 0; $$12 <= 2; ++$$12) {
                    this.m_73528_(p_192136_, Blocks.f_50197_.m_49966_(), $$11, -1, $$12, p_192140_);
                    this.m_73528_(p_192136_, Blocks.f_50197_.m_49966_(), $$11, -1, 12 - $$12, p_192140_);
                }
            }
            for (int $$13 = 0; $$13 <= 2; ++$$13) {
                for (int $$14 = 4; $$14 <= 8; ++$$14) {
                    this.m_73528_(p_192136_, Blocks.f_50197_.m_49966_(), $$13, -1, $$14, p_192140_);
                    this.m_73528_(p_192136_, Blocks.f_50197_.m_49966_(), 12 - $$13, -1, $$14, p_192140_);
                }
            }
            this.m_73441_(p_192136_, p_192140_, 5, 5, 5, 7, 5, 7, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192136_, p_192140_, 6, 1, 6, 6, 4, 6, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73434_(p_192136_, Blocks.f_50197_.m_49966_(), 6, 0, 6, p_192140_);
            this.m_73434_(p_192136_, Blocks.f_49991_.m_49966_(), 6, 5, 6, p_192140_);
            BlockPos.MutableBlockPos $$15 = this.m_163582_(6, 5, 6);
            if (p_192140_.m_71051_($$15)) {
                p_192136_.m_186469_($$15, Fluids.f_76195_, 0);
            }
        }
    }

    public static class CastleSmallCorridorPiece
    extends NetherBridgePiece {
        private static final int f_162779_ = 5;
        private static final int f_162780_ = 7;
        private static final int f_162781_ = 5;

        public CastleSmallCorridorPiece(int p_71790_, BoundingBox p_71791_, Direction p_71792_) {
            super(StructurePieceType.f_67148_, p_71790_, p_71791_);
            this.m_73519_(p_71792_);
        }

        public CastleSmallCorridorPiece(CompoundTag p_192167_) {
            super(StructurePieceType.f_67148_, p_192167_);
        }

        @Override
        public void m_142537_(StructurePiece p_162786_, StructurePieceAccessor p_162787_, Random p_162788_) {
            this.m_162867_((StartPiece)p_162786_, p_162787_, p_162788_, 1, 0, true);
        }

        public static CastleSmallCorridorPiece m_162789_(StructurePieceAccessor p_162790_, int p_162791_, int p_162792_, int p_162793_, Direction p_162794_, int p_162795_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162791_, p_162792_, p_162793_, -1, 0, 0, 5, 7, 5, p_162794_);
            if (!CastleSmallCorridorPiece.m_71903_($$6) || p_162790_.m_141921_($$6) != null) {
                return null;
            }
            return new CastleSmallCorridorPiece(p_162795_, $$6, p_162794_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192169_, StructureFeatureManager p_192170_, ChunkGenerator p_192171_, Random p_192172_, BoundingBox p_192173_, ChunkPos p_192174_, BlockPos p_192175_) {
            this.m_73441_(p_192169_, p_192173_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192169_, p_192173_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_192169_, p_192173_, 0, 2, 0, 0, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192169_, p_192173_, 4, 2, 0, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192169_, p_192173_, 0, 3, 1, 0, 4, 1, $$7, $$7, false);
            this.m_73441_(p_192169_, p_192173_, 0, 3, 3, 0, 4, 3, $$7, $$7, false);
            this.m_73441_(p_192169_, p_192173_, 4, 3, 1, 4, 4, 1, $$7, $$7, false);
            this.m_73441_(p_192169_, p_192173_, 4, 3, 3, 4, 4, 3, $$7, $$7, false);
            this.m_73441_(p_192169_, p_192173_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$8 = 0; $$8 <= 4; ++$$8) {
                for (int $$9 = 0; $$9 <= 4; ++$$9) {
                    this.m_73528_(p_192169_, Blocks.f_50197_.m_49966_(), $$8, -1, $$9, p_192173_);
                }
            }
        }
    }

    public static class CastleSmallCorridorRightTurnPiece
    extends NetherBridgePiece {
        private static final int f_162796_ = 5;
        private static final int f_162797_ = 7;
        private static final int f_162798_ = 5;
        private boolean f_71815_;

        public CastleSmallCorridorRightTurnPiece(int p_71817_, Random p_71818_, BoundingBox p_71819_, Direction p_71820_) {
            super(StructurePieceType.f_67149_, p_71817_, p_71819_);
            this.m_73519_(p_71820_);
            this.f_71815_ = p_71818_.nextInt(3) == 0;
        }

        public CastleSmallCorridorRightTurnPiece(CompoundTag p_192177_) {
            super(StructurePieceType.f_67149_, p_192177_);
            this.f_71815_ = p_192177_.m_128471_("Chest");
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192187_, CompoundTag p_192188_) {
            super.m_183620_(p_192187_, p_192188_);
            p_192188_.m_128379_("Chest", this.f_71815_);
        }

        @Override
        public void m_142537_(StructurePiece p_162806_, StructurePieceAccessor p_162807_, Random p_162808_) {
            this.m_162891_((StartPiece)p_162806_, p_162807_, p_162808_, 0, 1, true);
        }

        public static CastleSmallCorridorRightTurnPiece m_162809_(StructurePieceAccessor p_162810_, Random p_162811_, int p_162812_, int p_162813_, int p_162814_, Direction p_162815_, int p_162816_) {
            BoundingBox $$7 = BoundingBox.m_71031_(p_162812_, p_162813_, p_162814_, -1, 0, 0, 5, 7, 5, p_162815_);
            if (!CastleSmallCorridorRightTurnPiece.m_71903_($$7) || p_162810_.m_141921_($$7) != null) {
                return null;
            }
            return new CastleSmallCorridorRightTurnPiece(p_162816_, p_162811_, $$7, p_162815_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192179_, StructureFeatureManager p_192180_, ChunkGenerator p_192181_, Random p_192182_, BoundingBox p_192183_, ChunkPos p_192184_, BlockPos p_192185_) {
            this.m_73441_(p_192179_, p_192183_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192179_, p_192183_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_192179_, p_192183_, 0, 2, 0, 0, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192179_, p_192183_, 0, 3, 1, 0, 4, 1, $$8, $$8, false);
            this.m_73441_(p_192179_, p_192183_, 0, 3, 3, 0, 4, 3, $$8, $$8, false);
            this.m_73441_(p_192179_, p_192183_, 4, 2, 0, 4, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192179_, p_192183_, 1, 2, 4, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192179_, p_192183_, 1, 3, 4, 1, 4, 4, $$7, $$7, false);
            this.m_73441_(p_192179_, p_192183_, 3, 3, 4, 3, 4, 4, $$7, $$7, false);
            if (this.f_71815_ && p_192183_.m_71051_(this.m_163582_(1, 2, 3))) {
                this.f_71815_ = false;
                this.m_5606_(p_192179_, p_192183_, p_192182_, 1, 2, 3, BuiltInLootTables.f_78760_);
            }
            this.m_73441_(p_192179_, p_192183_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$9 = 0; $$9 <= 4; ++$$9) {
                for (int $$10 = 0; $$10 <= 4; ++$$10) {
                    this.m_73528_(p_192179_, Blocks.f_50197_.m_49966_(), $$9, -1, $$10, p_192183_);
                }
            }
        }
    }

    public static class CastleSmallCorridorLeftTurnPiece
    extends NetherBridgePiece {
        private static final int f_162758_ = 5;
        private static final int f_162759_ = 7;
        private static final int f_162760_ = 5;
        private boolean f_71758_;

        public CastleSmallCorridorLeftTurnPiece(int p_71760_, Random p_71761_, BoundingBox p_71762_, Direction p_71763_) {
            super(StructurePieceType.f_67147_, p_71760_, p_71762_);
            this.m_73519_(p_71763_);
            this.f_71758_ = p_71761_.nextInt(3) == 0;
        }

        public CastleSmallCorridorLeftTurnPiece(CompoundTag p_192154_) {
            super(StructurePieceType.f_67147_, p_192154_);
            this.f_71758_ = p_192154_.m_128471_("Chest");
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192164_, CompoundTag p_192165_) {
            super.m_183620_(p_192164_, p_192165_);
            p_192165_.m_128379_("Chest", this.f_71758_);
        }

        @Override
        public void m_142537_(StructurePiece p_162768_, StructurePieceAccessor p_162769_, Random p_162770_) {
            this.m_162884_((StartPiece)p_162768_, p_162769_, p_162770_, 0, 1, true);
        }

        public static CastleSmallCorridorLeftTurnPiece m_162771_(StructurePieceAccessor p_162772_, Random p_162773_, int p_162774_, int p_162775_, int p_162776_, Direction p_162777_, int p_162778_) {
            BoundingBox $$7 = BoundingBox.m_71031_(p_162774_, p_162775_, p_162776_, -1, 0, 0, 5, 7, 5, p_162777_);
            if (!CastleSmallCorridorLeftTurnPiece.m_71903_($$7) || p_162772_.m_141921_($$7) != null) {
                return null;
            }
            return new CastleSmallCorridorLeftTurnPiece(p_162778_, p_162773_, $$7, p_162777_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192156_, StructureFeatureManager p_192157_, ChunkGenerator p_192158_, Random p_192159_, BoundingBox p_192160_, ChunkPos p_192161_, BlockPos p_192162_) {
            this.m_73441_(p_192156_, p_192160_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192156_, p_192160_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            this.m_73441_(p_192156_, p_192160_, 4, 2, 0, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192156_, p_192160_, 4, 3, 1, 4, 4, 1, $$8, $$8, false);
            this.m_73441_(p_192156_, p_192160_, 4, 3, 3, 4, 4, 3, $$8, $$8, false);
            this.m_73441_(p_192156_, p_192160_, 0, 2, 0, 0, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192156_, p_192160_, 0, 2, 4, 3, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192156_, p_192160_, 1, 3, 4, 1, 4, 4, $$7, $$7, false);
            this.m_73441_(p_192156_, p_192160_, 3, 3, 4, 3, 4, 4, $$7, $$7, false);
            if (this.f_71758_ && p_192160_.m_71051_(this.m_163582_(3, 2, 3))) {
                this.f_71758_ = false;
                this.m_5606_(p_192156_, p_192160_, p_192159_, 3, 2, 3, BuiltInLootTables.f_78760_);
            }
            this.m_73441_(p_192156_, p_192160_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$9 = 0; $$9 <= 4; ++$$9) {
                for (int $$10 = 0; $$10 <= 4; ++$$10) {
                    this.m_73528_(p_192156_, Blocks.f_50197_.m_49966_(), $$9, -1, $$10, p_192160_);
                }
            }
        }
    }

    public static class CastleCorridorStairsPiece
    extends NetherBridgePiece {
        private static final int f_162689_ = 5;
        private static final int f_162690_ = 14;
        private static final int f_162691_ = 10;

        public CastleCorridorStairsPiece(int p_71653_, BoundingBox p_71654_, Direction p_71655_) {
            super(StructurePieceType.f_67143_, p_71653_, p_71654_);
            this.m_73519_(p_71655_);
        }

        public CastleCorridorStairsPiece(CompoundTag p_192114_) {
            super(StructurePieceType.f_67143_, p_192114_);
        }

        @Override
        public void m_142537_(StructurePiece p_162696_, StructurePieceAccessor p_162697_, Random p_162698_) {
            this.m_162867_((StartPiece)p_162696_, p_162697_, p_162698_, 1, 0, true);
        }

        public static CastleCorridorStairsPiece m_162699_(StructurePieceAccessor p_162700_, int p_162701_, int p_162702_, int p_162703_, Direction p_162704_, int p_162705_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162701_, p_162702_, p_162703_, -1, -7, 0, 5, 14, 10, p_162704_);
            if (!CastleCorridorStairsPiece.m_71903_($$6) || p_162700_.m_141921_($$6) != null) {
                return null;
            }
            return new CastleCorridorStairsPiece(p_162705_, $$6, p_162704_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192116_, StructureFeatureManager p_192117_, ChunkGenerator p_192118_, Random p_192119_, BoundingBox p_192120_, ChunkPos p_192121_, BlockPos p_192122_) {
            BlockState $$7 = (BlockState)Blocks.f_50199_.m_49966_().m_61124_(StairBlock.f_56841_, Direction.SOUTH);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            for (int $$9 = 0; $$9 <= 9; ++$$9) {
                int $$10 = Math.max(1, 7 - $$9);
                int $$11 = Math.min(Math.max($$10 + 5, 14 - $$9), 13);
                int $$12 = $$9;
                this.m_73441_(p_192116_, p_192120_, 0, 0, $$12, 4, $$10, $$12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                this.m_73441_(p_192116_, p_192120_, 1, $$10 + 1, $$12, 3, $$11 - 1, $$12, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
                if ($$9 <= 6) {
                    this.m_73434_(p_192116_, $$7, 1, $$10 + 1, $$12, p_192120_);
                    this.m_73434_(p_192116_, $$7, 2, $$10 + 1, $$12, p_192120_);
                    this.m_73434_(p_192116_, $$7, 3, $$10 + 1, $$12, p_192120_);
                }
                this.m_73441_(p_192116_, p_192120_, 0, $$11, $$12, 4, $$11, $$12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                this.m_73441_(p_192116_, p_192120_, 0, $$10 + 1, $$12, 0, $$11 - 1, $$12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                this.m_73441_(p_192116_, p_192120_, 4, $$10 + 1, $$12, 4, $$11 - 1, $$12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                if (($$9 & 1) == 0) {
                    this.m_73441_(p_192116_, p_192120_, 0, $$10 + 2, $$12, 0, $$10 + 3, $$12, $$8, $$8, false);
                    this.m_73441_(p_192116_, p_192120_, 4, $$10 + 2, $$12, 4, $$10 + 3, $$12, $$8, $$8, false);
                }
                for (int $$13 = 0; $$13 <= 4; ++$$13) {
                    this.m_73528_(p_192116_, Blocks.f_50197_.m_49966_(), $$13, -1, $$12, p_192120_);
                }
            }
        }
    }

    public static class CastleCorridorTBalconyPiece
    extends NetherBridgePiece {
        private static final int f_162706_ = 9;
        private static final int f_162707_ = 7;
        private static final int f_162708_ = 9;

        public CastleCorridorTBalconyPiece(int p_71679_, BoundingBox p_71680_, Direction p_71681_) {
            super(StructurePieceType.f_67144_, p_71679_, p_71680_);
            this.m_73519_(p_71681_);
        }

        public CastleCorridorTBalconyPiece(CompoundTag p_192124_) {
            super(StructurePieceType.f_67144_, p_192124_);
        }

        @Override
        public void m_142537_(StructurePiece p_162713_, StructurePieceAccessor p_162714_, Random p_162715_) {
            int $$3 = 1;
            Direction $$4 = this.m_73549_();
            if ($$4 == Direction.WEST || $$4 == Direction.NORTH) {
                $$3 = 5;
            }
            this.m_162884_((StartPiece)p_162713_, p_162714_, p_162715_, 0, $$3, p_162715_.nextInt(8) > 0);
            this.m_162891_((StartPiece)p_162713_, p_162714_, p_162715_, 0, $$3, p_162715_.nextInt(8) > 0);
        }

        public static CastleCorridorTBalconyPiece m_162716_(StructurePieceAccessor p_162717_, int p_162718_, int p_162719_, int p_162720_, Direction p_162721_, int p_162722_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162718_, p_162719_, p_162720_, -3, 0, 0, 9, 7, 9, p_162721_);
            if (!CastleCorridorTBalconyPiece.m_71903_($$6) || p_162717_.m_141921_($$6) != null) {
                return null;
            }
            return new CastleCorridorTBalconyPiece(p_162722_, $$6, p_162721_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192126_, StructureFeatureManager p_192127_, ChunkGenerator p_192128_, Random p_192129_, BoundingBox p_192130_, ChunkPos p_192131_, BlockPos p_192132_) {
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            this.m_73441_(p_192126_, p_192130_, 0, 0, 0, 8, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 0, 2, 0, 8, 5, 8, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 0, 6, 0, 8, 6, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 0, 2, 0, 2, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 6, 2, 0, 8, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 1, 3, 0, 1, 4, 0, $$8, $$8, false);
            this.m_73441_(p_192126_, p_192130_, 7, 3, 0, 7, 4, 0, $$8, $$8, false);
            this.m_73441_(p_192126_, p_192130_, 0, 2, 4, 8, 2, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 1, 1, 4, 2, 2, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 6, 1, 4, 7, 2, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 1, 3, 8, 7, 3, 8, $$8, $$8, false);
            this.m_73434_(p_192126_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52310_, true)).m_61124_(FenceBlock.f_52311_, true), 0, 3, 8, p_192130_);
            this.m_73434_(p_192126_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52311_, true), 8, 3, 8, p_192130_);
            this.m_73441_(p_192126_, p_192130_, 0, 3, 6, 0, 3, 7, $$7, $$7, false);
            this.m_73441_(p_192126_, p_192130_, 8, 3, 6, 8, 3, 7, $$7, $$7, false);
            this.m_73441_(p_192126_, p_192130_, 0, 3, 4, 0, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 8, 3, 4, 8, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 1, 3, 5, 2, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 6, 3, 5, 7, 5, 5, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192126_, p_192130_, 1, 4, 5, 1, 5, 5, $$8, $$8, false);
            this.m_73441_(p_192126_, p_192130_, 7, 4, 5, 7, 5, 5, $$8, $$8, false);
            for (int $$9 = 0; $$9 <= 5; ++$$9) {
                for (int $$10 = 0; $$10 <= 8; ++$$10) {
                    this.m_73528_(p_192126_, Blocks.f_50197_.m_49966_(), $$10, -1, $$9, p_192130_);
                }
            }
        }
    }

    public static class CastleSmallCorridorCrossingPiece
    extends NetherBridgePiece {
        private static final int f_162741_ = 5;
        private static final int f_162742_ = 7;
        private static final int f_162743_ = 5;

        public CastleSmallCorridorCrossingPiece(int p_71733_, BoundingBox p_71734_, Direction p_71735_) {
            super(StructurePieceType.f_67146_, p_71733_, p_71734_);
            this.m_73519_(p_71735_);
        }

        public CastleSmallCorridorCrossingPiece(CompoundTag p_192144_) {
            super(StructurePieceType.f_67146_, p_192144_);
        }

        @Override
        public void m_142537_(StructurePiece p_162748_, StructurePieceAccessor p_162749_, Random p_162750_) {
            this.m_162867_((StartPiece)p_162748_, p_162749_, p_162750_, 1, 0, true);
            this.m_162884_((StartPiece)p_162748_, p_162749_, p_162750_, 0, 1, true);
            this.m_162891_((StartPiece)p_162748_, p_162749_, p_162750_, 0, 1, true);
        }

        public static CastleSmallCorridorCrossingPiece m_162751_(StructurePieceAccessor p_162752_, int p_162753_, int p_162754_, int p_162755_, Direction p_162756_, int p_162757_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162753_, p_162754_, p_162755_, -1, 0, 0, 5, 7, 5, p_162756_);
            if (!CastleSmallCorridorCrossingPiece.m_71903_($$6) || p_162752_.m_141921_($$6) != null) {
                return null;
            }
            return new CastleSmallCorridorCrossingPiece(p_162757_, $$6, p_162756_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192146_, StructureFeatureManager p_192147_, ChunkGenerator p_192148_, Random p_192149_, BoundingBox p_192150_, ChunkPos p_192151_, BlockPos p_192152_) {
            this.m_73441_(p_192146_, p_192150_, 0, 0, 0, 4, 1, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192146_, p_192150_, 0, 2, 0, 4, 5, 4, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192146_, p_192150_, 0, 2, 0, 0, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192146_, p_192150_, 4, 2, 0, 4, 5, 0, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192146_, p_192150_, 0, 2, 4, 0, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192146_, p_192150_, 4, 2, 4, 4, 5, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192146_, p_192150_, 0, 6, 0, 4, 6, 4, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$7 = 0; $$7 <= 4; ++$$7) {
                for (int $$8 = 0; $$8 <= 4; ++$$8) {
                    this.m_73528_(p_192146_, Blocks.f_50197_.m_49966_(), $$7, -1, $$8, p_192150_);
                }
            }
        }
    }

    public static class CastleStalkRoom
    extends NetherBridgePiece {
        private static final int f_162817_ = 13;
        private static final int f_162818_ = 14;
        private static final int f_162819_ = 13;

        public CastleStalkRoom(int p_71847_, BoundingBox p_71848_, Direction p_71849_) {
            super(StructurePieceType.f_67150_, p_71847_, p_71848_);
            this.m_73519_(p_71849_);
        }

        public CastleStalkRoom(CompoundTag p_192190_) {
            super(StructurePieceType.f_67150_, p_192190_);
        }

        @Override
        public void m_142537_(StructurePiece p_162824_, StructurePieceAccessor p_162825_, Random p_162826_) {
            this.m_162867_((StartPiece)p_162824_, p_162825_, p_162826_, 5, 3, true);
            this.m_162867_((StartPiece)p_162824_, p_162825_, p_162826_, 5, 11, true);
        }

        public static CastleStalkRoom m_162827_(StructurePieceAccessor p_162828_, int p_162829_, int p_162830_, int p_162831_, Direction p_162832_, int p_162833_) {
            BoundingBox $$6 = BoundingBox.m_71031_(p_162829_, p_162830_, p_162831_, -5, -3, 0, 13, 14, 13, p_162832_);
            if (!CastleStalkRoom.m_71903_($$6) || p_162828_.m_141921_($$6) != null) {
                return null;
            }
            return new CastleStalkRoom(p_162833_, $$6, p_162832_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192192_, StructureFeatureManager p_192193_, ChunkGenerator p_192194_, Random p_192195_, BoundingBox p_192196_, ChunkPos p_192197_, BlockPos p_192198_) {
            this.m_73441_(p_192192_, p_192196_, 0, 3, 0, 12, 4, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 0, 5, 0, 12, 13, 12, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 0, 5, 0, 1, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 11, 5, 0, 12, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 2, 5, 11, 4, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 8, 5, 11, 10, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 5, 9, 11, 7, 12, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 2, 5, 0, 4, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 8, 5, 0, 10, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 5, 9, 0, 7, 12, 1, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 2, 11, 2, 10, 12, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52312_, true)).m_61124_(FenceBlock.f_52310_, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52311_, true);
            BlockState $$9 = (BlockState)$$8.m_61124_(FenceBlock.f_52312_, true);
            BlockState $$10 = (BlockState)$$8.m_61124_(FenceBlock.f_52310_, true);
            for (int $$11 = 1; $$11 <= 11; $$11 += 2) {
                this.m_73441_(p_192192_, p_192196_, $$11, 10, 0, $$11, 11, 0, $$7, $$7, false);
                this.m_73441_(p_192192_, p_192196_, $$11, 10, 12, $$11, 11, 12, $$7, $$7, false);
                this.m_73441_(p_192192_, p_192196_, 0, 10, $$11, 0, 11, $$11, $$8, $$8, false);
                this.m_73441_(p_192192_, p_192196_, 12, 10, $$11, 12, 11, $$11, $$8, $$8, false);
                this.m_73434_(p_192192_, Blocks.f_50197_.m_49966_(), $$11, 13, 0, p_192196_);
                this.m_73434_(p_192192_, Blocks.f_50197_.m_49966_(), $$11, 13, 12, p_192196_);
                this.m_73434_(p_192192_, Blocks.f_50197_.m_49966_(), 0, 13, $$11, p_192196_);
                this.m_73434_(p_192192_, Blocks.f_50197_.m_49966_(), 12, 13, $$11, p_192196_);
                if ($$11 == 11) continue;
                this.m_73434_(p_192192_, $$7, $$11 + 1, 13, 0, p_192196_);
                this.m_73434_(p_192192_, $$7, $$11 + 1, 13, 12, p_192196_);
                this.m_73434_(p_192192_, $$8, 0, 13, $$11 + 1, p_192196_);
                this.m_73434_(p_192192_, $$8, 12, 13, $$11 + 1, p_192196_);
            }
            this.m_73434_(p_192192_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 0, p_192196_);
            this.m_73434_(p_192192_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52310_, true), 0, 13, 12, p_192196_);
            this.m_73434_(p_192192_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52311_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 12, p_192196_);
            this.m_73434_(p_192192_, (BlockState)((BlockState)Blocks.f_50198_.m_49966_().m_61124_(FenceBlock.f_52309_, true)).m_61124_(FenceBlock.f_52312_, true), 12, 13, 0, p_192196_);
            for (int $$12 = 3; $$12 <= 9; $$12 += 2) {
                this.m_73441_(p_192192_, p_192196_, 1, 7, $$12, 1, 8, $$12, $$9, $$9, false);
                this.m_73441_(p_192192_, p_192196_, 11, 7, $$12, 11, 8, $$12, $$10, $$10, false);
            }
            BlockState $$13 = (BlockState)Blocks.f_50199_.m_49966_().m_61124_(StairBlock.f_56841_, Direction.NORTH);
            for (int $$14 = 0; $$14 <= 6; ++$$14) {
                int $$15 = $$14 + 4;
                for (int $$16 = 5; $$16 <= 7; ++$$16) {
                    this.m_73434_(p_192192_, $$13, $$16, 5 + $$14, $$15, p_192196_);
                }
                if ($$15 >= 5 && $$15 <= 8) {
                    this.m_73441_(p_192192_, p_192196_, 5, 5, $$15, 7, $$14 + 4, $$15, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                } else if ($$15 >= 9 && $$15 <= 10) {
                    this.m_73441_(p_192192_, p_192196_, 5, 8, $$15, 7, $$14 + 4, $$15, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                }
                if ($$14 < 1) continue;
                this.m_73441_(p_192192_, p_192196_, 5, 6 + $$14, $$15, 7, 9 + $$14, $$15, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            }
            for (int $$17 = 5; $$17 <= 7; ++$$17) {
                this.m_73434_(p_192192_, $$13, $$17, 12, 11, p_192196_);
            }
            this.m_73441_(p_192192_, p_192196_, 5, 6, 7, 5, 7, 7, $$10, $$10, false);
            this.m_73441_(p_192192_, p_192196_, 7, 6, 7, 7, 7, 7, $$9, $$9, false);
            this.m_73441_(p_192192_, p_192196_, 5, 13, 12, 7, 13, 12, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 2, 5, 2, 3, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 2, 5, 9, 3, 5, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 2, 5, 4, 2, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 9, 5, 2, 10, 5, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 9, 5, 9, 10, 5, 10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 10, 5, 4, 10, 5, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            BlockState $$18 = (BlockState)$$13.m_61124_(StairBlock.f_56841_, Direction.EAST);
            BlockState $$19 = (BlockState)$$13.m_61124_(StairBlock.f_56841_, Direction.WEST);
            this.m_73434_(p_192192_, $$19, 4, 5, 2, p_192196_);
            this.m_73434_(p_192192_, $$19, 4, 5, 3, p_192196_);
            this.m_73434_(p_192192_, $$19, 4, 5, 9, p_192196_);
            this.m_73434_(p_192192_, $$19, 4, 5, 10, p_192196_);
            this.m_73434_(p_192192_, $$18, 8, 5, 2, p_192196_);
            this.m_73434_(p_192192_, $$18, 8, 5, 3, p_192196_);
            this.m_73434_(p_192192_, $$18, 8, 5, 9, p_192196_);
            this.m_73434_(p_192192_, $$18, 8, 5, 10, p_192196_);
            this.m_73441_(p_192192_, p_192196_, 3, 4, 4, 4, 4, 8, Blocks.f_50135_.m_49966_(), Blocks.f_50135_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 8, 4, 4, 9, 4, 8, Blocks.f_50135_.m_49966_(), Blocks.f_50135_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 3, 5, 4, 4, 5, 8, Blocks.f_50200_.m_49966_(), Blocks.f_50200_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 8, 5, 4, 9, 5, 8, Blocks.f_50200_.m_49966_(), Blocks.f_50200_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 4, 2, 0, 8, 2, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 0, 2, 4, 12, 2, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 4, 0, 0, 8, 1, 3, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 4, 0, 9, 8, 1, 12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 0, 0, 4, 3, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            this.m_73441_(p_192192_, p_192196_, 9, 0, 4, 12, 1, 8, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$20 = 4; $$20 <= 8; ++$$20) {
                for (int $$21 = 0; $$21 <= 2; ++$$21) {
                    this.m_73528_(p_192192_, Blocks.f_50197_.m_49966_(), $$20, -1, $$21, p_192196_);
                    this.m_73528_(p_192192_, Blocks.f_50197_.m_49966_(), $$20, -1, 12 - $$21, p_192196_);
                }
            }
            for (int $$22 = 0; $$22 <= 2; ++$$22) {
                for (int $$23 = 4; $$23 <= 8; ++$$23) {
                    this.m_73528_(p_192192_, Blocks.f_50197_.m_49966_(), $$22, -1, $$23, p_192196_);
                    this.m_73528_(p_192192_, Blocks.f_50197_.m_49966_(), 12 - $$22, -1, $$23, p_192196_);
                }
            }
        }
    }

    public static class BridgeEndFiller
    extends NetherBridgePiece {
        private static final int f_162654_ = 5;
        private static final int f_162655_ = 10;
        private static final int f_162656_ = 8;
        private final int f_71597_;

        public BridgeEndFiller(int p_71599_, Random p_71600_, BoundingBox p_71601_, Direction p_71602_) {
            super(StructurePieceType.f_67141_, p_71599_, p_71601_);
            this.m_73519_(p_71602_);
            this.f_71597_ = p_71600_.nextInt();
        }

        public BridgeEndFiller(CompoundTag p_192091_) {
            super(StructurePieceType.f_67141_, p_192091_);
            this.f_71597_ = p_192091_.m_128451_("Seed");
        }

        public static BridgeEndFiller m_162663_(StructurePieceAccessor p_162664_, Random p_162665_, int p_162666_, int p_162667_, int p_162668_, Direction p_162669_, int p_162670_) {
            BoundingBox $$7 = BoundingBox.m_71031_(p_162666_, p_162667_, p_162668_, -1, -3, 0, 5, 10, 8, p_162669_);
            if (!BridgeEndFiller.m_71903_($$7) || p_162664_.m_141921_($$7) != null) {
                return null;
            }
            return new BridgeEndFiller(p_162670_, p_162665_, $$7, p_162669_);
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192101_, CompoundTag p_192102_) {
            super.m_183620_(p_192101_, p_192102_);
            p_192102_.m_128405_("Seed", this.f_71597_);
        }

        @Override
        public void m_183269_(WorldGenLevel p_192093_, StructureFeatureManager p_192094_, ChunkGenerator p_192095_, Random p_192096_, BoundingBox p_192097_, ChunkPos p_192098_, BlockPos p_192099_) {
            Random $$7 = new Random(this.f_71597_);
            for (int $$8 = 0; $$8 <= 4; ++$$8) {
                for (int $$9 = 3; $$9 <= 4; ++$$9) {
                    int $$10 = $$7.nextInt(8);
                    this.m_73441_(p_192093_, p_192097_, $$8, $$9, 0, $$8, $$9, $$10, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                }
            }
            int $$11 = $$7.nextInt(8);
            this.m_73441_(p_192093_, p_192097_, 0, 5, 0, 0, 5, $$11, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            int $$12 = $$7.nextInt(8);
            this.m_73441_(p_192093_, p_192097_, 4, 5, 0, 4, 5, $$12, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            for (int $$13 = 0; $$13 <= 4; ++$$13) {
                int $$14 = $$7.nextInt(5);
                this.m_73441_(p_192093_, p_192097_, $$13, 2, 0, $$13, 2, $$14, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
            }
            for (int $$15 = 0; $$15 <= 4; ++$$15) {
                for (int $$16 = 0; $$16 <= 1; ++$$16) {
                    int $$17 = $$7.nextInt(3);
                    this.m_73441_(p_192093_, p_192097_, $$15, $$16, 0, $$15, $$16, $$17, Blocks.f_50197_.m_49966_(), Blocks.f_50197_.m_49966_(), false);
                }
            }
        }
    }

    public static class StartPiece
    extends BridgeCrossing {
        public PieceWeight f_72019_;
        public List<PieceWeight> f_72020_;
        public List<PieceWeight> f_72021_;
        public final List<StructurePiece> f_72022_ = Lists.newArrayList();

        public StartPiece(Random p_72027_, int p_72028_, int p_72029_) {
            super(p_72028_, p_72029_, StartPiece.m_163580_(p_72027_));
            this.f_72020_ = Lists.newArrayList();
            for (PieceWeight $$3 : f_71539_) {
                $$3.f_71952_ = 0;
                this.f_72020_.add($$3);
            }
            this.f_72021_ = Lists.newArrayList();
            for (PieceWeight $$4 : f_71540_) {
                $$4.f_71952_ = 0;
                this.f_72021_.add($$4);
            }
        }

        public StartPiece(CompoundTag p_192236_) {
            super(StructurePieceType.f_67154_, p_192236_);
        }
    }

    static abstract class NetherBridgePiece
    extends StructurePiece {
        protected NetherBridgePiece(StructurePieceType p_162851_, int p_162852_, BoundingBox p_162853_) {
            super(p_162851_, p_162852_, p_162853_);
        }

        public NetherBridgePiece(StructurePieceType p_71901_, CompoundTag p_71902_) {
            super(p_71901_, p_71902_);
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192213_, CompoundTag p_192214_) {
        }

        private int m_71932_(List<PieceWeight> p_71933_) {
            boolean $$1 = false;
            int $$2 = 0;
            for (PieceWeight $$3 : p_71933_) {
                if ($$3.f_71953_ > 0 && $$3.f_71952_ < $$3.f_71953_) {
                    $$1 = true;
                }
                $$2 += $$3.f_71951_;
            }
            return $$1 ? $$2 : -1;
        }

        private NetherBridgePiece m_162874_(StartPiece p_162875_, List<PieceWeight> p_162876_, StructurePieceAccessor p_162877_, Random p_162878_, int p_162879_, int p_162880_, int p_162881_, Direction p_162882_, int p_162883_) {
            int $$9 = this.m_71932_(p_162876_);
            boolean $$10 = $$9 > 0 && p_162883_ <= 30;
            int $$11 = 0;
            block0: while ($$11 < 5 && $$10) {
                ++$$11;
                int $$12 = p_162878_.nextInt($$9);
                for (PieceWeight $$13 : p_162876_) {
                    if (($$12 -= $$13.f_71951_) >= 0) continue;
                    if (!$$13.m_71965_(p_162883_) || $$13 == p_162875_.f_72019_ && !$$13.f_71954_) continue block0;
                    NetherBridgePiece $$14 = NetherBridgePieces.m_162624_($$13, p_162877_, p_162878_, p_162879_, p_162880_, p_162881_, p_162882_, p_162883_);
                    if ($$14 == null) continue;
                    ++$$13.f_71952_;
                    p_162875_.f_72019_ = $$13;
                    if (!$$13.m_71964_()) {
                        p_162876_.remove($$13);
                    }
                    return $$14;
                }
            }
            return BridgeEndFiller.m_162663_(p_162877_, p_162878_, p_162879_, p_162880_, p_162881_, p_162882_, p_162883_);
        }

        private StructurePiece m_162857_(StartPiece p_162858_, StructurePieceAccessor p_162859_, Random p_162860_, int p_162861_, int p_162862_, int p_162863_, @Nullable Direction p_162864_, int p_162865_, boolean p_162866_) {
            NetherBridgePiece $$10;
            if (Math.abs(p_162861_ - p_162858_.m_73547_().m_162395_()) > 112 || Math.abs(p_162863_ - p_162858_.m_73547_().m_162398_()) > 112) {
                return BridgeEndFiller.m_162663_(p_162859_, p_162860_, p_162861_, p_162862_, p_162863_, p_162864_, p_162865_);
            }
            List<PieceWeight> $$9 = p_162858_.f_72020_;
            if (p_162866_) {
                $$9 = p_162858_.f_72021_;
            }
            if (($$10 = this.m_162874_(p_162858_, $$9, p_162859_, p_162860_, p_162861_, p_162862_, p_162863_, p_162864_, p_162865_ + 1)) != null) {
                p_162859_.m_142679_($$10);
                p_162858_.f_72022_.add($$10);
            }
            return $$10;
        }

        @Nullable
        protected StructurePiece m_162867_(StartPiece p_162868_, StructurePieceAccessor p_162869_, Random p_162870_, int p_162871_, int p_162872_, boolean p_162873_) {
            Direction $$6 = this.m_73549_();
            if ($$6 != null) {
                switch ($$6) {
                    case NORTH: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162395_() + p_162871_, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162398_() - 1, $$6, this.m_73548_(), p_162873_);
                    }
                    case SOUTH: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162395_() + p_162871_, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162401_() + 1, $$6, this.m_73548_(), p_162873_);
                    }
                    case WEST: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162398_() + p_162871_, $$6, this.m_73548_(), p_162873_);
                    }
                    case EAST: {
                        return this.m_162857_(p_162868_, p_162869_, p_162870_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162872_, this.f_73383_.m_162398_() + p_162871_, $$6, this.m_73548_(), p_162873_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece m_162884_(StartPiece p_162885_, StructurePieceAccessor p_162886_, Random p_162887_, int p_162888_, int p_162889_, boolean p_162890_) {
            Direction $$6 = this.m_73549_();
            if ($$6 != null) {
                switch ($$6) {
                    case NORTH: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() + p_162889_, Direction.WEST, this.m_73548_(), p_162890_);
                    }
                    case SOUTH: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() + p_162889_, Direction.WEST, this.m_73548_(), p_162890_);
                    }
                    case WEST: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() + p_162889_, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.m_73548_(), p_162890_);
                    }
                    case EAST: {
                        return this.m_162857_(p_162885_, p_162886_, p_162887_, this.f_73383_.m_162395_() + p_162889_, this.f_73383_.m_162396_() + p_162888_, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.m_73548_(), p_162890_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece m_162891_(StartPiece p_162892_, StructurePieceAccessor p_162893_, Random p_162894_, int p_162895_, int p_162896_, boolean p_162897_) {
            Direction $$6 = this.m_73549_();
            if ($$6 != null) {
                switch ($$6) {
                    case NORTH: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162398_() + p_162896_, Direction.EAST, this.m_73548_(), p_162897_);
                    }
                    case SOUTH: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162398_() + p_162896_, Direction.EAST, this.m_73548_(), p_162897_);
                    }
                    case WEST: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162395_() + p_162896_, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.m_73548_(), p_162897_);
                    }
                    case EAST: {
                        return this.m_162857_(p_162892_, p_162893_, p_162894_, this.f_73383_.m_162395_() + p_162896_, this.f_73383_.m_162396_() + p_162895_, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.m_73548_(), p_162897_);
                    }
                }
            }
            return null;
        }

        protected static boolean m_71903_(BoundingBox p_71904_) {
            return p_71904_ != null && p_71904_.m_162396_() > 10;
        }
    }
}

