/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.MineshaftFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineShaftPieces {
    static final Logger f_162462_ = LogManager.getLogger();
    private static final int f_162463_ = 3;
    private static final int f_162464_ = 3;
    private static final int f_162465_ = 5;
    private static final int f_162466_ = 20;
    private static final int f_162467_ = 50;
    private static final int f_162468_ = 8;
    public static final int f_192026_ = 50;

    private static MineShaftPiece m_162480_(StructurePieceAccessor p_162481_, Random p_162482_, int p_162483_, int p_162484_, int p_162485_, @Nullable Direction p_162486_, int p_162487_, MineshaftFeature.Type p_162488_) {
        int $$8 = p_162482_.nextInt(100);
        if ($$8 >= 80) {
            BoundingBox $$9 = MineShaftCrossing.m_162563_(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if ($$9 != null) {
                return new MineShaftCrossing(p_162487_, $$9, p_162486_, p_162488_);
            }
        } else if ($$8 >= 70) {
            BoundingBox $$10 = MineShaftStairs.m_162614_(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if ($$10 != null) {
                return new MineShaftStairs(p_162487_, $$10, p_162486_, p_162488_);
            }
        } else {
            BoundingBox $$11 = MineShaftCorridor.m_162537_(p_162481_, p_162482_, p_162483_, p_162484_, p_162485_, p_162486_);
            if ($$11 != null) {
                return new MineShaftCorridor(p_162487_, p_162482_, $$11, p_162486_, p_162488_);
            }
        }
        return null;
    }

    static MineShaftPiece m_162471_(StructurePiece p_162472_, StructurePieceAccessor p_162473_, Random p_162474_, int p_162475_, int p_162476_, int p_162477_, Direction p_162478_, int p_162479_) {
        if (p_162479_ > 8) {
            return null;
        }
        if (Math.abs(p_162475_ - p_162472_.m_73547_().m_162395_()) > 80 || Math.abs(p_162477_ - p_162472_.m_73547_().m_162398_()) > 80) {
            return null;
        }
        MineshaftFeature.Type $$8 = ((MineShaftPiece)p_162472_).f_71465_;
        MineShaftPiece $$9 = MineShaftPieces.m_162480_(p_162473_, p_162474_, p_162475_, p_162476_, p_162477_, p_162478_, p_162479_ + 1, $$8);
        if ($$9 != null) {
            p_162473_.m_142679_($$9);
            $$9.m_142537_(p_162472_, p_162473_, p_162474_);
        }
        return $$9;
    }

    public static class MineShaftCrossing
    extends MineShaftPiece {
        private final Direction f_71427_;
        private final boolean f_71428_;

        public MineShaftCrossing(CompoundTag p_192041_) {
            super(StructurePieceType.f_67137_, p_192041_);
            this.f_71428_ = p_192041_.m_128471_("tf");
            this.f_71427_ = Direction.m_122407_(p_192041_.m_128451_("D"));
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192051_, CompoundTag p_192052_) {
            super.m_183620_(p_192051_, p_192052_);
            p_192052_.m_128379_("tf", this.f_71428_);
            p_192052_.m_128405_("D", this.f_71427_.m_122416_());
        }

        public MineShaftCrossing(int p_71430_, BoundingBox p_71431_, @Nullable Direction p_71432_, MineshaftFeature.Type p_71433_) {
            super(StructurePieceType.f_67137_, p_71430_, p_71433_, p_71431_);
            this.f_71427_ = p_71432_;
            this.f_71428_ = p_71431_.m_71057_() > 3;
        }

        @Nullable
        public static BoundingBox m_162563_(StructurePieceAccessor p_162564_, Random p_162565_, int p_162566_, int p_162567_, int p_162568_, Direction p_162569_) {
            BoundingBox $$11;
            int $$7;
            if (p_162565_.nextInt(4) == 0) {
                int $$6 = 6;
            } else {
                $$7 = 2;
            }
            switch (p_162569_) {
                default: {
                    BoundingBox $$8 = new BoundingBox(-1, 0, -4, 3, $$7, 0);
                    break;
                }
                case SOUTH: {
                    BoundingBox $$9 = new BoundingBox(-1, 0, 0, 3, $$7, 4);
                    break;
                }
                case WEST: {
                    BoundingBox $$10 = new BoundingBox(-4, 0, -1, 0, $$7, 3);
                    break;
                }
                case EAST: {
                    $$11 = new BoundingBox(0, 0, -1, 4, $$7, 3);
                }
            }
            $$11.m_162367_(p_162566_, p_162567_, p_162568_);
            if (p_162564_.m_141921_($$11) != null) {
                return null;
            }
            return $$11;
        }

        @Override
        public void m_142537_(StructurePiece p_162560_, StructurePieceAccessor p_162561_, Random p_162562_) {
            int $$3 = this.m_73548_();
            switch (this.f_71427_) {
                default: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, $$3);
                    break;
                }
                case SOUTH: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, $$3);
                    break;
                }
                case WEST: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.WEST, $$3);
                    break;
                }
                case EAST: {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, Direction.EAST, $$3);
                }
            }
            if (this.f_71428_) {
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                }
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() + 1, Direction.WEST, $$3);
                }
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162398_() + 1, Direction.EAST, $$3);
                }
                if (p_162562_.nextBoolean()) {
                    MineShaftPieces.m_162471_(p_162560_, p_162561_, p_162562_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3 + 1, this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                }
            }
        }

        @Override
        public void m_183269_(WorldGenLevel p_192043_, StructureFeatureManager p_192044_, ChunkGenerator p_192045_, Random p_192046_, BoundingBox p_192047_, ChunkPos p_192048_, BlockPos p_192049_) {
            if (this.m_162578_(p_192043_, p_192047_)) {
                return;
            }
            BlockState $$7 = this.f_71465_.m_160062_();
            if (this.f_71428_) {
                this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3 - 1, this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 3 - 1, this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162400_() - 2, this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_(), this.f_73383_.m_162400_() - 2, this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
                this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_() + 3, this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
            } else {
                this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), this.f_73383_.m_162399_() - 1, this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
                this.m_73441_(p_192043_, p_192047_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_() - 1, f_73382_, f_73382_, false);
            }
            this.m_71445_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162400_());
            this.m_71445_(p_192043_, p_192047_, this.f_73383_.m_162395_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - 1, this.f_73383_.m_162400_());
            this.m_71445_(p_192043_, p_192047_, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + 1, this.f_73383_.m_162400_());
            this.m_71445_(p_192043_, p_192047_, this.f_73383_.m_162399_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - 1, this.f_73383_.m_162400_());
            int $$8 = this.f_73383_.m_162396_() - 1;
            for (int $$9 = this.f_73383_.m_162395_(); $$9 <= this.f_73383_.m_162399_(); ++$$9) {
                for (int $$10 = this.f_73383_.m_162398_(); $$10 <= this.f_73383_.m_162401_(); ++$$10) {
                    this.m_162587_(p_192043_, p_192047_, $$7, $$9, $$8, $$10);
                }
            }
        }

        private void m_71445_(WorldGenLevel p_71446_, BoundingBox p_71447_, int p_71448_, int p_71449_, int p_71450_, int p_71451_) {
            if (!this.m_73398_(p_71446_, p_71448_, p_71451_ + 1, p_71450_, p_71447_).m_60795_()) {
                this.m_73441_(p_71446_, p_71447_, p_71448_, p_71449_, p_71450_, p_71448_, p_71451_, p_71450_, this.f_71465_.m_160062_(), f_73382_, false);
            }
        }
    }

    public static class MineShaftStairs
    extends MineShaftPiece {
        public MineShaftStairs(int p_71513_, BoundingBox p_71514_, Direction p_71515_, MineshaftFeature.Type p_71516_) {
            super(StructurePieceType.f_67139_, p_71513_, p_71516_, p_71514_);
            this.m_73519_(p_71515_);
        }

        public MineShaftStairs(CompoundTag p_192070_) {
            super(StructurePieceType.f_67139_, p_192070_);
        }

        @Nullable
        public static BoundingBox m_162614_(StructurePieceAccessor p_162615_, Random p_162616_, int p_162617_, int p_162618_, int p_162619_, Direction p_162620_) {
            BoundingBox $$9;
            switch (p_162620_) {
                default: {
                    BoundingBox $$6 = new BoundingBox(0, -5, -8, 2, 2, 0);
                    break;
                }
                case SOUTH: {
                    BoundingBox $$7 = new BoundingBox(0, -5, 0, 2, 2, 8);
                    break;
                }
                case WEST: {
                    BoundingBox $$8 = new BoundingBox(-8, -5, 0, 0, 2, 2);
                    break;
                }
                case EAST: {
                    $$9 = new BoundingBox(0, -5, 0, 8, 2, 2);
                }
            }
            $$9.m_162367_(p_162617_, p_162618_, p_162619_);
            if (p_162615_.m_141921_($$9) != null) {
                return null;
            }
            return $$9;
        }

        @Override
        public void m_142537_(StructurePiece p_162611_, StructurePieceAccessor p_162612_, Random p_162613_) {
            int $$3 = this.m_73548_();
            Direction $$4 = this.m_73549_();
            if ($$4 != null) {
                switch ($$4) {
                    default: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                        break;
                    }
                    case SOUTH: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                        break;
                    }
                    case WEST: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), Direction.WEST, $$3);
                        break;
                    }
                    case EAST: {
                        MineShaftPieces.m_162471_(p_162611_, p_162612_, p_162613_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), Direction.EAST, $$3);
                    }
                }
            }
        }

        @Override
        public void m_183269_(WorldGenLevel p_192072_, StructureFeatureManager p_192073_, ChunkGenerator p_192074_, Random p_192075_, BoundingBox p_192076_, ChunkPos p_192077_, BlockPos p_192078_) {
            if (this.m_162578_(p_192072_, p_192076_)) {
                return;
            }
            this.m_73441_(p_192072_, p_192076_, 0, 5, 0, 2, 7, 1, f_73382_, f_73382_, false);
            this.m_73441_(p_192072_, p_192076_, 0, 0, 7, 2, 2, 8, f_73382_, f_73382_, false);
            for (int $$7 = 0; $$7 < 5; ++$$7) {
                this.m_73441_(p_192072_, p_192076_, 0, 5 - $$7 - ($$7 < 4 ? 1 : 0), 2 + $$7, 2, 7 - $$7, 2 + $$7, f_73382_, f_73382_, false);
            }
        }
    }

    public static class MineShaftCorridor
    extends MineShaftPiece {
        private final boolean f_71368_;
        private final boolean f_71369_;
        private boolean f_71370_;
        private final int f_71371_;

        public MineShaftCorridor(CompoundTag p_192028_) {
            super(StructurePieceType.f_67132_, p_192028_);
            this.f_71368_ = p_192028_.m_128471_("hr");
            this.f_71369_ = p_192028_.m_128471_("sc");
            this.f_71370_ = p_192028_.m_128471_("hps");
            this.f_71371_ = p_192028_.m_128451_("Num");
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192038_, CompoundTag p_192039_) {
            super.m_183620_(p_192038_, p_192039_);
            p_192039_.m_128379_("hr", this.f_71368_);
            p_192039_.m_128379_("sc", this.f_71369_);
            p_192039_.m_128379_("hps", this.f_71370_);
            p_192039_.m_128405_("Num", this.f_71371_);
        }

        public MineShaftCorridor(int p_71373_, Random p_71374_, BoundingBox p_71375_, Direction p_71376_, MineshaftFeature.Type p_71377_) {
            super(StructurePieceType.f_67132_, p_71373_, p_71377_, p_71375_);
            this.m_73519_(p_71376_);
            this.f_71368_ = p_71374_.nextInt(3) == 0;
            this.f_71369_ = !this.f_71368_ && p_71374_.nextInt(23) == 0;
            this.f_71371_ = this.m_73549_().m_122434_() == Direction.Axis.Z ? p_71375_.m_71058_() / 5 : p_71375_.m_71056_() / 5;
        }

        @Nullable
        public static BoundingBox m_162537_(StructurePieceAccessor p_162538_, Random p_162539_, int p_162540_, int p_162541_, int p_162542_, Direction p_162543_) {
            for (int $$6 = p_162539_.nextInt(3) + 2; $$6 > 0; --$$6) {
                BoundingBox $$11;
                int $$7 = $$6 * 5;
                switch (p_162543_) {
                    default: {
                        BoundingBox $$8 = new BoundingBox(0, 0, -($$7 - 1), 2, 2, 0);
                        break;
                    }
                    case SOUTH: {
                        BoundingBox $$9 = new BoundingBox(0, 0, 0, 2, 2, $$7 - 1);
                        break;
                    }
                    case WEST: {
                        BoundingBox $$10 = new BoundingBox(-($$7 - 1), 0, 0, 0, 2, 2);
                        break;
                    }
                    case EAST: {
                        $$11 = new BoundingBox(0, 0, 0, $$7 - 1, 2, 2);
                    }
                }
                $$11.m_162367_(p_162540_, p_162541_, p_162542_);
                if (p_162538_.m_141921_($$11) != null) {
                    continue;
                }
                return $$11;
            }
            return null;
        }

        @Override
        public void m_142537_(StructurePiece p_162534_, StructurePieceAccessor p_162535_, Random p_162536_) {
            block24: {
                int $$3 = this.m_73548_();
                int $$4 = p_162536_.nextInt(4);
                Direction $$5 = this.m_73549_();
                if ($$5 != null) {
                    switch ($$5) {
                        default: {
                            if ($$4 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, $$5, $$3);
                                break;
                            }
                            if ($$4 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), Direction.WEST, $$3);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), Direction.EAST, $$3);
                            break;
                        }
                        case SOUTH: {
                            if ($$4 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, $$5, $$3);
                                break;
                            }
                            if ($$4 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() - 3, Direction.WEST, $$3);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() - 3, Direction.EAST, $$3);
                            break;
                        }
                        case WEST: {
                            if ($$4 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), $$5, $$3);
                                break;
                            }
                            if ($$4 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                            break;
                        }
                        case EAST: {
                            if ($$4 <= 1) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_(), $$5, $$3);
                                break;
                            }
                            if ($$4 == 2) {
                                MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() - 3, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                                break;
                            }
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() - 3, this.f_73383_.m_162396_() - 1 + p_162536_.nextInt(3), this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                        }
                    }
                }
                if ($$3 >= 8) break block24;
                if ($$5 == Direction.NORTH || $$5 == Direction.SOUTH) {
                    int $$6 = this.f_73383_.m_162398_() + 3;
                    while ($$6 + 3 <= this.f_73383_.m_162401_()) {
                        int $$7 = p_162536_.nextInt(5);
                        if ($$7 == 0) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), $$6, Direction.WEST, $$3 + 1);
                        } else if ($$7 == 1) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), $$6, Direction.EAST, $$3 + 1);
                        }
                        $$6 += 5;
                    }
                } else {
                    int $$8 = this.f_73383_.m_162395_() + 3;
                    while ($$8 + 3 <= this.f_73383_.m_162399_()) {
                        int $$9 = p_162536_.nextInt(5);
                        if ($$9 == 0) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, $$8, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3 + 1);
                        } else if ($$9 == 1) {
                            MineShaftPieces.m_162471_(p_162534_, p_162535_, p_162536_, $$8, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3 + 1);
                        }
                        $$8 += 5;
                    }
                }
            }
        }

        @Override
        protected boolean m_5606_(WorldGenLevel p_71407_, BoundingBox p_71408_, Random p_71409_, int p_71410_, int p_71411_, int p_71412_, ResourceLocation p_71413_) {
            BlockPos.MutableBlockPos $$7 = this.m_163582_(p_71410_, p_71411_, p_71412_);
            if (p_71408_.m_71051_($$7) && p_71407_.m_8055_($$7).m_60795_() && !p_71407_.m_8055_(((BlockPos)$$7).m_7495_()).m_60795_()) {
                BlockState $$8 = (BlockState)Blocks.f_50156_.m_49966_().m_61124_(RailBlock.f_55392_, p_71409_.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST);
                this.m_73434_(p_71407_, $$8, p_71410_, p_71411_, p_71412_, p_71408_);
                MinecartChest $$9 = new MinecartChest(p_71407_.m_6018_(), (double)$$7.m_123341_() + 0.5, (double)$$7.m_123342_() + 0.5, (double)$$7.m_123343_() + 0.5);
                $$9.m_38236_(p_71413_, p_71409_.nextLong());
                p_71407_.m_7967_($$9);
                return true;
            }
            return false;
        }

        @Override
        public void m_183269_(WorldGenLevel p_192030_, StructureFeatureManager p_192031_, ChunkGenerator p_192032_, Random p_192033_, BoundingBox p_192034_, ChunkPos p_192035_, BlockPos p_192036_) {
            if (this.m_162578_(p_192030_, p_192034_)) {
                return;
            }
            boolean $$7 = false;
            int $$8 = 2;
            boolean $$9 = false;
            int $$10 = 2;
            int $$11 = this.f_71371_ * 5 - 1;
            BlockState $$12 = this.f_71465_.m_160062_();
            this.m_73441_(p_192030_, p_192034_, 0, 0, 0, 2, 1, $$11, f_73382_, f_73382_, false);
            this.m_73476_(p_192030_, p_192034_, p_192033_, 0.8f, 0, 2, 0, 2, 2, $$11, f_73382_, f_73382_, false, false);
            if (this.f_71369_) {
                this.m_73476_(p_192030_, p_192034_, p_192033_, 0.6f, 0, 0, 0, 2, 1, $$11, Blocks.f_50033_.m_49966_(), f_73382_, false, true);
            }
            for (int $$13 = 0; $$13 < this.f_71371_; ++$$13) {
                int $$14 = 2 + $$13 * 5;
                this.m_71389_(p_192030_, p_192034_, 0, 0, $$14, 2, 2, p_192033_);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.1f, 0, 2, $$14 - 1);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.1f, 2, 2, $$14 - 1);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.1f, 0, 2, $$14 + 1);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.1f, 2, 2, $$14 + 1);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.05f, 0, 2, $$14 - 2);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.05f, 2, 2, $$14 - 2);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.05f, 0, 2, $$14 + 2);
                this.m_162525_(p_192030_, p_192034_, p_192033_, 0.05f, 2, 2, $$14 + 2);
                if (p_192033_.nextInt(100) == 0) {
                    this.m_5606_(p_192030_, p_192034_, p_192033_, 2, 0, $$14 - 1, BuiltInLootTables.f_78759_);
                }
                if (p_192033_.nextInt(100) == 0) {
                    this.m_5606_(p_192030_, p_192034_, p_192033_, 0, 0, $$14 + 1, BuiltInLootTables.f_78759_);
                }
                if (!this.f_71369_ || this.f_71370_) continue;
                boolean $$15 = true;
                int $$16 = $$14 - 1 + p_192033_.nextInt(3);
                BlockPos.MutableBlockPos $$17 = this.m_163582_(1, 0, $$16);
                if (!p_192034_.m_71051_($$17) || !this.m_73414_(p_192030_, 1, 0, $$16, p_192034_)) continue;
                this.f_71370_ = true;
                p_192030_.m_7731_($$17, Blocks.f_50085_.m_49966_(), 2);
                BlockEntity $$18 = p_192030_.m_7702_($$17);
                if (!($$18 instanceof SpawnerBlockEntity)) continue;
                ((SpawnerBlockEntity)$$18).m_59801_().m_45462_(EntityType.f_20554_);
            }
            for (int $$19 = 0; $$19 <= 2; ++$$19) {
                for (int $$20 = 0; $$20 <= $$11; ++$$20) {
                    this.m_162587_(p_192030_, p_192034_, $$12, $$19, -1, $$20);
                }
            }
            int $$21 = 2;
            this.m_162512_(p_192030_, p_192034_, 0, -1, 2);
            if (this.f_71371_ > 1) {
                int $$22 = $$11 - 2;
                this.m_162512_(p_192030_, p_192034_, 0, -1, $$22);
            }
            if (this.f_71368_) {
                BlockState $$23 = (BlockState)Blocks.f_50156_.m_49966_().m_61124_(RailBlock.f_55392_, RailShape.NORTH_SOUTH);
                for (int $$24 = 0; $$24 <= $$11; ++$$24) {
                    BlockState $$25 = this.m_73398_(p_192030_, 1, -1, $$24, p_192034_);
                    if ($$25.m_60795_() || !$$25.m_60804_(p_192030_, this.m_163582_(1, -1, $$24))) continue;
                    float $$26 = this.m_73414_(p_192030_, 1, 0, $$24, p_192034_) ? 0.7f : 0.9f;
                    this.m_73491_(p_192030_, p_192034_, p_192033_, $$26, 1, 0, $$24, $$23);
                }
            }
        }

        private void m_162512_(WorldGenLevel p_162513_, BoundingBox p_162514_, int p_162515_, int p_162516_, int p_162517_) {
            BlockState $$5 = this.f_71465_.m_160061_();
            BlockState $$6 = this.f_71465_.m_160062_();
            if (this.m_73398_(p_162513_, p_162515_, p_162516_, p_162517_, p_162514_).m_60713_($$6.m_60734_())) {
                this.m_162544_(p_162513_, $$5, p_162515_, p_162516_, p_162517_, p_162514_);
            }
            if (this.m_73398_(p_162513_, p_162515_ + 2, p_162516_, p_162517_, p_162514_).m_60713_($$6.m_60734_())) {
                this.m_162544_(p_162513_, $$5, p_162515_ + 2, p_162516_, p_162517_, p_162514_);
            }
        }

        @Override
        protected void m_73528_(WorldGenLevel p_162500_, BlockState p_162501_, int p_162502_, int p_162503_, int p_162504_, BoundingBox p_162505_) {
            BlockPos.MutableBlockPos $$6 = this.m_163582_(p_162502_, p_162503_, p_162504_);
            if (!p_162505_.m_71051_($$6)) {
                return;
            }
            int $$7 = $$6.m_123342_();
            while (this.m_163572_(p_162500_.m_8055_($$6)) && $$6.m_123342_() > p_162500_.m_141937_() + 1) {
                $$6.m_122173_(Direction.DOWN);
            }
            if (!this.m_162551_(p_162500_.m_8055_($$6))) {
                return;
            }
            while ($$6.m_123342_() < $$7) {
                $$6.m_122173_(Direction.UP);
                p_162500_.m_7731_($$6, p_162501_, 2);
            }
        }

        protected void m_162544_(WorldGenLevel p_162545_, BlockState p_162546_, int p_162547_, int p_162548_, int p_162549_, BoundingBox p_162550_) {
            BlockPos.MutableBlockPos $$6 = this.m_163582_(p_162547_, p_162548_, p_162549_);
            if (!p_162550_.m_71051_($$6)) {
                return;
            }
            int $$7 = $$6.m_123342_();
            int $$8 = 1;
            boolean $$9 = true;
            boolean $$10 = true;
            while ($$9 || $$10) {
                if ($$9) {
                    boolean $$12;
                    $$6.m_142448_($$7 - $$8);
                    BlockState $$11 = p_162545_.m_8055_($$6);
                    boolean bl = $$12 = this.m_163572_($$11) && !$$11.m_60713_(Blocks.f_49991_);
                    if (!$$12 && this.m_162551_($$11)) {
                        MineShaftCorridor.m_162506_(p_162545_, p_162546_, $$6, $$7 - $$8 + 1, $$7);
                        return;
                    }
                    boolean bl2 = $$9 = $$8 <= 20 && $$12 && $$6.m_123342_() > p_162545_.m_141937_() + 1;
                }
                if ($$10) {
                    $$6.m_142448_($$7 + $$8);
                    BlockState $$13 = p_162545_.m_8055_($$6);
                    boolean $$14 = this.m_163572_($$13);
                    if (!$$14 && this.m_162495_(p_162545_, $$6, $$13)) {
                        p_162545_.m_7731_($$6.m_142448_($$7 + 1), this.f_71465_.m_160063_(), 2);
                        MineShaftCorridor.m_162506_(p_162545_, Blocks.f_50184_.m_49966_(), $$6, $$7 + 2, $$7 + $$8);
                        return;
                    }
                    $$10 = $$8 <= 50 && $$14 && $$6.m_123342_() < p_162545_.m_151558_() - 1;
                }
                ++$$8;
            }
        }

        private static void m_162506_(WorldGenLevel p_162507_, BlockState p_162508_, BlockPos.MutableBlockPos p_162509_, int p_162510_, int p_162511_) {
            for (int $$5 = p_162510_; $$5 < p_162511_; ++$$5) {
                p_162507_.m_7731_(p_162509_.m_142448_($$5), p_162508_, 2);
            }
        }

        private boolean m_162551_(BlockState p_162552_) {
            return !p_162552_.m_60713_(Blocks.f_50156_) && !p_162552_.m_60713_(Blocks.f_49991_);
        }

        private boolean m_162495_(LevelReader p_162496_, BlockPos p_162497_, BlockState p_162498_) {
            return Block.m_49863_(p_162496_, p_162497_, Direction.DOWN) && !(p_162498_.m_60734_() instanceof FallingBlock);
        }

        private void m_71389_(WorldGenLevel p_71390_, BoundingBox p_71391_, int p_71392_, int p_71393_, int p_71394_, int p_71395_, int p_71396_, Random p_71397_) {
            if (!this.m_71474_(p_71390_, p_71391_, p_71392_, p_71396_, p_71395_, p_71394_)) {
                return;
            }
            BlockState $$8 = this.f_71465_.m_160062_();
            BlockState $$9 = this.f_71465_.m_160063_();
            this.m_73441_(p_71390_, p_71391_, p_71392_, p_71393_, p_71394_, p_71392_, p_71395_ - 1, p_71394_, (BlockState)$$9.m_61124_(FenceBlock.f_52312_, true), f_73382_, false);
            this.m_73441_(p_71390_, p_71391_, p_71396_, p_71393_, p_71394_, p_71396_, p_71395_ - 1, p_71394_, (BlockState)$$9.m_61124_(FenceBlock.f_52310_, true), f_73382_, false);
            if (p_71397_.nextInt(4) == 0) {
                this.m_73441_(p_71390_, p_71391_, p_71392_, p_71395_, p_71394_, p_71392_, p_71395_, p_71394_, $$8, f_73382_, false);
                this.m_73441_(p_71390_, p_71391_, p_71396_, p_71395_, p_71394_, p_71396_, p_71395_, p_71394_, $$8, f_73382_, false);
            } else {
                this.m_73441_(p_71390_, p_71391_, p_71392_, p_71395_, p_71394_, p_71396_, p_71395_, p_71394_, $$8, f_73382_, false);
                this.m_73491_(p_71390_, p_71391_, p_71397_, 0.05f, p_71392_ + 1, p_71395_, p_71394_ - 1, (BlockState)Blocks.f_50082_.m_49966_().m_61124_(WallTorchBlock.f_58119_, Direction.SOUTH));
                this.m_73491_(p_71390_, p_71391_, p_71397_, 0.05f, p_71392_ + 1, p_71395_, p_71394_ + 1, (BlockState)Blocks.f_50082_.m_49966_().m_61124_(WallTorchBlock.f_58119_, Direction.NORTH));
            }
        }

        private void m_162525_(WorldGenLevel p_162526_, BoundingBox p_162527_, Random p_162528_, float p_162529_, int p_162530_, int p_162531_, int p_162532_) {
            if (this.m_73414_(p_162526_, p_162530_, p_162531_, p_162532_, p_162527_) && p_162528_.nextFloat() < p_162529_ && this.m_162518_(p_162526_, p_162527_, p_162530_, p_162531_, p_162532_, 2)) {
                this.m_73434_(p_162526_, Blocks.f_50033_.m_49966_(), p_162530_, p_162531_, p_162532_, p_162527_);
            }
        }

        private boolean m_162518_(WorldGenLevel p_162519_, BoundingBox p_162520_, int p_162521_, int p_162522_, int p_162523_, int p_162524_) {
            BlockPos.MutableBlockPos $$6 = this.m_163582_(p_162521_, p_162522_, p_162523_);
            int $$7 = 0;
            for (Direction $$8 : Direction.values()) {
                $$6.m_122173_($$8);
                if (p_162520_.m_71051_($$6) && p_162519_.m_8055_($$6).m_60783_(p_162519_, $$6, $$8.m_122424_()) && ++$$7 >= p_162524_) {
                    return true;
                }
                $$6.m_122173_($$8.m_122424_());
            }
            return false;
        }
    }

    static abstract class MineShaftPiece
    extends StructurePiece {
        protected MineshaftFeature.Type f_71465_;

        public MineShaftPiece(StructurePieceType p_162571_, int p_162572_, MineshaftFeature.Type p_162573_, BoundingBox p_162574_) {
            super(p_162571_, p_162572_, p_162574_);
            this.f_71465_ = p_162573_;
        }

        public MineShaftPiece(StructurePieceType p_71471_, CompoundTag p_71472_) {
            super(p_71471_, p_71472_);
            this.f_71465_ = MineshaftFeature.Type.m_66330_(p_71472_.m_128451_("MST"));
        }

        @Override
        protected boolean m_142085_(LevelReader p_162582_, int p_162583_, int p_162584_, int p_162585_, BoundingBox p_162586_) {
            BlockState $$5 = this.m_73398_(p_162582_, p_162583_, p_162584_, p_162585_, p_162586_);
            return !$$5.m_60713_(this.f_71465_.m_160062_().m_60734_()) && !$$5.m_60713_(this.f_71465_.m_160061_().m_60734_()) && !$$5.m_60713_(this.f_71465_.m_160063_().m_60734_()) && !$$5.m_60713_(Blocks.f_50184_);
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192054_, CompoundTag p_192055_) {
            p_192055_.m_128405_("MST", this.f_71465_.ordinal());
        }

        protected boolean m_71474_(BlockGetter p_71475_, BoundingBox p_71476_, int p_71477_, int p_71478_, int p_71479_, int p_71480_) {
            for (int $$6 = p_71477_; $$6 <= p_71478_; ++$$6) {
                if (!this.m_73398_(p_71475_, $$6, p_71479_ + 1, p_71480_, p_71476_).m_60795_()) continue;
                return false;
            }
            return true;
        }

        protected boolean m_162578_(BlockGetter p_162579_, BoundingBox p_162580_) {
            int $$2 = Math.max(this.f_73383_.m_162395_() - 1, p_162580_.m_162395_());
            int $$3 = Math.max(this.f_73383_.m_162396_() - 1, p_162580_.m_162396_());
            int $$4 = Math.max(this.f_73383_.m_162398_() - 1, p_162580_.m_162398_());
            int $$5 = Math.min(this.f_73383_.m_162399_() + 1, p_162580_.m_162399_());
            int $$6 = Math.min(this.f_73383_.m_162400_() + 1, p_162580_.m_162400_());
            int $$7 = Math.min(this.f_73383_.m_162401_() + 1, p_162580_.m_162401_());
            BlockPos.MutableBlockPos $$8 = new BlockPos.MutableBlockPos();
            for (int $$9 = $$2; $$9 <= $$5; ++$$9) {
                for (int $$10 = $$4; $$10 <= $$7; ++$$10) {
                    if (p_162579_.m_8055_($$8.m_122178_($$9, $$3, $$10)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_($$8.m_122178_($$9, $$6, $$10)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            for (int $$11 = $$2; $$11 <= $$5; ++$$11) {
                for (int $$12 = $$3; $$12 <= $$6; ++$$12) {
                    if (p_162579_.m_8055_($$8.m_122178_($$11, $$12, $$4)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_($$8.m_122178_($$11, $$12, $$7)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            for (int $$13 = $$4; $$13 <= $$7; ++$$13) {
                for (int $$14 = $$3; $$14 <= $$6; ++$$14) {
                    if (p_162579_.m_8055_($$8.m_122178_($$2, $$14, $$13)).m_60767_().m_76332_()) {
                        return true;
                    }
                    if (!p_162579_.m_8055_($$8.m_122178_($$5, $$14, $$13)).m_60767_().m_76332_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void m_162587_(WorldGenLevel p_162588_, BoundingBox p_162589_, BlockState p_162590_, int p_162591_, int p_162592_, int p_162593_) {
            if (!this.m_73414_(p_162588_, p_162591_, p_162592_, p_162593_, p_162589_)) {
                return;
            }
            BlockPos.MutableBlockPos $$6 = this.m_163582_(p_162591_, p_162592_, p_162593_);
            BlockState $$7 = p_162588_.m_8055_($$6);
            if ($$7.m_60795_() || $$7.m_60713_(Blocks.f_50184_)) {
                p_162588_.m_7731_($$6, p_162590_, 2);
            }
        }
    }

    public static class MineShaftRoom
    extends MineShaftPiece {
        private final List<BoundingBox> f_71484_ = Lists.newLinkedList();

        public MineShaftRoom(int p_71486_, Random p_71487_, int p_71488_, int p_71489_, MineshaftFeature.Type p_71490_) {
            super(StructurePieceType.f_67138_, p_71486_, p_71490_, new BoundingBox(p_71488_, 50, p_71489_, p_71488_ + 7 + p_71487_.nextInt(6), 54 + p_71487_.nextInt(6), p_71489_ + 7 + p_71487_.nextInt(6)));
            this.f_71465_ = p_71490_;
        }

        public MineShaftRoom(CompoundTag p_192057_) {
            super(StructurePieceType.f_67138_, p_192057_);
            BoundingBox.f_162354_.listOf().parse((DynamicOps)NbtOps.f_128958_, (Object)p_192057_.m_128437_("Entrances", 11)).resultOrPartial(arg_0 -> ((Logger)f_162462_).error(arg_0)).ifPresent(this.f_71484_::addAll);
        }

        @Override
        public void m_142537_(StructurePiece p_162601_, StructurePieceAccessor p_162602_, Random p_162603_) {
            int $$5;
            int $$3 = this.m_73548_();
            int $$4 = this.f_73383_.m_71057_() - 3 - 1;
            if ($$4 <= 0) {
                $$4 = 1;
            }
            for ($$5 = 0; $$5 < this.f_73383_.m_71056_() && ($$5 += p_162603_.nextInt(this.f_73383_.m_71056_())) + 3 <= this.f_73383_.m_71056_(); $$5 += 4) {
                MineShaftPiece $$6 = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() + $$5, this.f_73383_.m_162396_() + p_162603_.nextInt($$4) + 1, this.f_73383_.m_162398_() - 1, Direction.NORTH, $$3);
                if ($$6 == null) continue;
                BoundingBox $$7 = $$6.m_73547_();
                this.f_71484_.add(new BoundingBox($$7.m_162395_(), $$7.m_162396_(), this.f_73383_.m_162398_(), $$7.m_162399_(), $$7.m_162400_(), this.f_73383_.m_162398_() + 1));
            }
            for ($$5 = 0; $$5 < this.f_73383_.m_71056_() && ($$5 += p_162603_.nextInt(this.f_73383_.m_71056_())) + 3 <= this.f_73383_.m_71056_(); $$5 += 4) {
                MineShaftPiece $$8 = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() + $$5, this.f_73383_.m_162396_() + p_162603_.nextInt($$4) + 1, this.f_73383_.m_162401_() + 1, Direction.SOUTH, $$3);
                if ($$8 == null) continue;
                BoundingBox $$9 = $$8.m_73547_();
                this.f_71484_.add(new BoundingBox($$9.m_162395_(), $$9.m_162396_(), this.f_73383_.m_162401_() - 1, $$9.m_162399_(), $$9.m_162400_(), this.f_73383_.m_162401_()));
            }
            for ($$5 = 0; $$5 < this.f_73383_.m_71058_() && ($$5 += p_162603_.nextInt(this.f_73383_.m_71058_())) + 3 <= this.f_73383_.m_71058_(); $$5 += 4) {
                MineShaftPiece $$10 = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + p_162603_.nextInt($$4) + 1, this.f_73383_.m_162398_() + $$5, Direction.WEST, $$3);
                if ($$10 == null) continue;
                BoundingBox $$11 = $$10.m_73547_();
                this.f_71484_.add(new BoundingBox(this.f_73383_.m_162395_(), $$11.m_162396_(), $$11.m_162398_(), this.f_73383_.m_162395_() + 1, $$11.m_162400_(), $$11.m_162401_()));
            }
            for ($$5 = 0; $$5 < this.f_73383_.m_71058_() && ($$5 += p_162603_.nextInt(this.f_73383_.m_71058_())) + 3 <= this.f_73383_.m_71058_(); $$5 += 4) {
                MineShaftPiece $$12 = MineShaftPieces.m_162471_(p_162601_, p_162602_, p_162603_, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + p_162603_.nextInt($$4) + 1, this.f_73383_.m_162398_() + $$5, Direction.EAST, $$3);
                if ($$12 == null) continue;
                BoundingBox $$13 = $$12.m_73547_();
                this.f_71484_.add(new BoundingBox(this.f_73383_.m_162399_() - 1, $$13.m_162396_(), $$13.m_162398_(), this.f_73383_.m_162399_(), $$13.m_162400_(), $$13.m_162401_()));
            }
        }

        @Override
        public void m_183269_(WorldGenLevel p_192059_, StructureFeatureManager p_192060_, ChunkGenerator p_192061_, Random p_192062_, BoundingBox p_192063_, ChunkPos p_192064_, BlockPos p_192065_) {
            if (this.m_162578_(p_192059_, p_192063_)) {
                return;
            }
            this.m_73441_(p_192059_, p_192063_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 1, this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), Math.min(this.f_73383_.m_162396_() + 3, this.f_73383_.m_162400_()), this.f_73383_.m_162401_(), f_73382_, f_73382_, false);
            for (BoundingBox $$7 : this.f_71484_) {
                this.m_73441_(p_192059_, p_192063_, $$7.m_162395_(), $$7.m_162400_() - 2, $$7.m_162398_(), $$7.m_162399_(), $$7.m_162400_(), $$7.m_162401_(), f_73382_, f_73382_, false);
            }
            this.m_73453_(p_192059_, p_192063_, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 4, this.f_73383_.m_162398_(), this.f_73383_.m_162399_(), this.f_73383_.m_162400_(), this.f_73383_.m_162401_(), f_73382_, false);
        }

        @Override
        public void m_6324_(int p_71495_, int p_71496_, int p_71497_) {
            super.m_6324_(p_71495_, p_71496_, p_71497_);
            for (BoundingBox $$3 : this.f_71484_) {
                $$3.m_162367_(p_71495_, p_71496_, p_71497_);
            }
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext p_192067_, CompoundTag p_192068_) {
            super.m_183620_(p_192067_, p_192068_);
            BoundingBox.f_162354_.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.f_71484_).resultOrPartial(arg_0 -> ((Logger)f_162462_).error(arg_0)).ifPresent(p_162606_ -> p_192068_.m_128365_("Entrances", (Tag)p_162606_));
        }
    }
}

