/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.LayerConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatLevelGeneratorSettings {
    private static final Logger f_70348_ = LogManager.getLogger();
    public static final Codec<FlatLevelGeneratorSettings> f_70347_ = RecordCodecBuilder.create(p_70373_ -> p_70373_.group((App)RegistryLookupCodec.m_135622_(Registry.f_122885_).forGetter(p_161916_ -> p_161916_.f_70350_), (App)StructureSettings.f_64579_.fieldOf("structures").forGetter(FlatLevelGeneratorSettings::m_70395_), (App)FlatLayerInfo.f_70329_.listOf().fieldOf("layers").forGetter(FlatLevelGeneratorSettings::m_70401_), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(p_161914_ -> p_161914_.f_70357_), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(p_161912_ -> p_161912_.f_70356_), (App)Biome.f_47431_.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(p_161908_ -> Optional.of(p_161908_.f_70353_))).apply((Applicative)p_70373_, FlatLevelGeneratorSettings::new)).comapFlatMap(FlatLevelGeneratorSettings::m_161905_, Function.identity()).stable();
    private final Registry<Biome> f_70350_;
    private final StructureSettings f_70351_;
    private final List<FlatLayerInfo> f_70352_ = Lists.newArrayList();
    private Supplier<Biome> f_70353_;
    private final List<BlockState> f_70354_;
    private boolean f_70355_;
    private boolean f_70356_;
    private boolean f_70357_;

    private static DataResult<FlatLevelGeneratorSettings> m_161905_(FlatLevelGeneratorSettings p_161906_) {
        int $$1 = p_161906_.f_70352_.stream().mapToInt(FlatLayerInfo::m_70337_).sum();
        if ($$1 > DimensionType.f_156651_) {
            return DataResult.error((String)("Sum of layer heights is > " + DimensionType.f_156651_), (Object)p_161906_);
        }
        return DataResult.success((Object)p_161906_);
    }

    private FlatLevelGeneratorSettings(Registry<Biome> p_70363_, StructureSettings p_70364_, List<FlatLayerInfo> p_70365_, boolean p_70366_, boolean p_70367_, Optional<Supplier<Biome>> p_70368_) {
        this(p_70364_, p_70363_);
        if (p_70366_) {
            this.m_70385_();
        }
        if (p_70367_) {
            this.m_70369_();
        }
        this.f_70352_.addAll(p_70365_);
        this.m_70403_();
        if (!p_70368_.isPresent()) {
            f_70348_.error("Unknown biome, defaulting to plains");
            this.f_70353_ = () -> p_70363_.m_123013_(Biomes.f_48202_);
        } else {
            this.f_70353_ = p_70368_.get();
        }
    }

    public FlatLevelGeneratorSettings(StructureSettings p_70360_, Registry<Biome> p_70361_) {
        this.f_70350_ = p_70361_;
        this.f_70351_ = p_70360_;
        this.f_70353_ = () -> p_70361_.m_123013_(Biomes.f_48202_);
        this.f_70354_ = Lists.newArrayList();
    }

    public FlatLevelGeneratorSettings m_70370_(StructureSettings p_70371_) {
        return this.m_70380_(this.f_70352_, p_70371_);
    }

    public FlatLevelGeneratorSettings m_70380_(List<FlatLayerInfo> p_70381_, StructureSettings p_70382_) {
        FlatLevelGeneratorSettings $$2 = new FlatLevelGeneratorSettings(p_70382_, this.f_70350_);
        for (FlatLayerInfo $$3 : p_70381_) {
            $$2.f_70352_.add(new FlatLayerInfo($$3.m_70337_(), $$3.m_70344_().m_60734_()));
            $$2.m_70403_();
        }
        $$2.m_70383_(this.f_70353_);
        if (this.f_70356_) {
            $$2.m_70369_();
        }
        if (this.f_70357_) {
            $$2.m_70385_();
        }
        return $$2;
    }

    public void m_70369_() {
        this.f_70356_ = true;
    }

    public void m_70385_() {
        this.f_70357_ = true;
    }

    public Biome m_70390_() {
        boolean $$3;
        Biome $$0 = this.m_70400_();
        BiomeGenerationSettings $$1 = $$0.m_47536_();
        BiomeGenerationSettings.Builder $$2 = new BiomeGenerationSettings.Builder();
        if (this.f_70357_) {
            $$2.m_186664_(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.f_195266_);
            $$2.m_186664_(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.f_195267_);
        }
        boolean bl = $$3 = (!this.f_70355_ || this.f_70350_.m_7854_($$0).equals(Optional.of(Biomes.f_48173_))) && this.f_70356_;
        if ($$3) {
            List<List<Supplier<PlacedFeature>>> $$4 = $$1.m_47818_();
            for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
                if ($$5 == GenerationStep.Decoration.UNDERGROUND_STRUCTURES.ordinal() || $$5 == GenerationStep.Decoration.SURFACE_STRUCTURES.ordinal()) continue;
                List<Supplier<PlacedFeature>> $$6 = $$4.get($$5);
                for (Supplier<PlacedFeature> $$7 : $$6) {
                    $$2.m_47834_($$5, $$7);
                }
            }
        }
        List<BlockState> $$8 = this.m_161917_();
        for (int $$9 = 0; $$9 < $$8.size(); ++$$9) {
            BlockState $$10 = $$8.get($$9);
            if (Heightmap.Types.MOTION_BLOCKING.m_64299_().test($$10)) continue;
            $$8.set($$9, null);
            $$2.m_186664_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, Feature.f_65750_.m_65815_(new LayerConfiguration($$9, $$10)).m_190823_(new PlacementModifier[0]));
        }
        return new Biome.BiomeBuilder().m_47597_($$0.m_47530_()).m_47595_($$0.m_47567_()).m_47609_($$0.m_47554_()).m_47611_($$0.m_47548_()).m_47603_($$0.m_47557_()).m_47601_($$2.m_47831_()).m_47605_($$0.m_47518_()).m_47592_();
    }

    public StructureSettings m_70395_() {
        return this.f_70351_;
    }

    public Biome m_70400_() {
        return this.f_70353_.get();
    }

    public void m_70383_(Supplier<Biome> p_70384_) {
        this.f_70353_ = p_70384_;
    }

    public List<FlatLayerInfo> m_70401_() {
        return this.f_70352_;
    }

    public List<BlockState> m_161917_() {
        return this.f_70354_;
    }

    public void m_70403_() {
        this.f_70354_.clear();
        for (FlatLayerInfo $$0 : this.f_70352_) {
            for (int $$1 = 0; $$1 < $$0.m_70337_(); ++$$1) {
                this.f_70354_.add($$0.m_70344_());
            }
        }
        this.f_70355_ = this.f_70354_.stream().allMatch(p_191526_ -> p_191526_.m_60713_(Blocks.f_50016_));
    }

    public static FlatLevelGeneratorSettings m_70376_(Registry<Biome> p_70377_) {
        StructureSettings $$1 = new StructureSettings(Optional.of(StructureSettings.f_64581_), Maps.newHashMap((Map)ImmutableMap.of(StructureFeature.f_67028_, (Object)((StructureFeatureConfiguration)StructureSettings.f_64580_.get(StructureFeature.f_67028_)))));
        FlatLevelGeneratorSettings $$2 = new FlatLevelGeneratorSettings($$1, p_70377_);
        $$2.f_70353_ = () -> p_70377_.m_123013_(Biomes.f_48202_);
        $$2.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50752_));
        $$2.m_70401_().add(new FlatLayerInfo(2, Blocks.f_50493_));
        $$2.m_70401_().add(new FlatLayerInfo(1, Blocks.f_50440_));
        $$2.m_70403_();
        return $$2;
    }
}

