/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.BastionFeature;
import net.minecraft.world.level.levelgen.feature.BuriedTreasureFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.DesertPyramidFeature;
import net.minecraft.world.level.levelgen.feature.EndCityFeature;
import net.minecraft.world.level.levelgen.feature.IglooFeature;
import net.minecraft.world.level.levelgen.feature.JunglePyramidFeature;
import net.minecraft.world.level.levelgen.feature.MineshaftFeature;
import net.minecraft.world.level.levelgen.feature.NetherFortressFeature;
import net.minecraft.world.level.levelgen.feature.OceanMonumentFeature;
import net.minecraft.world.level.levelgen.feature.PillagerOutpostFeature;
import net.minecraft.world.level.levelgen.feature.RuinedPortalFeature;
import net.minecraft.world.level.levelgen.feature.ShipwreckFeature;
import net.minecraft.world.level.levelgen.feature.StrongholdFeature;
import net.minecraft.world.level.levelgen.feature.SwamplandHutFeature;
import net.minecraft.world.level.levelgen.feature.VillageFeature;
import net.minecraft.world.level.levelgen.feature.WoodlandMansionFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MineshaftConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ShipwreckConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.NetherFossilFeature;
import net.minecraft.world.level.levelgen.structure.OceanRuinFeature;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureFeature<C extends FeatureConfiguration> {
    public static final BiMap<String, StructureFeature<?>> f_67012_ = HashBiMap.create();
    private static final Map<StructureFeature<?>, GenerationStep.Decoration> f_67032_ = Maps.newHashMap();
    private static final Logger f_67033_ = LogManager.getLogger();
    public static final StructureFeature<JigsawConfiguration> f_67013_ = StructureFeature.m_67089_("Pillager_Outpost", new PillagerOutpostFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<MineshaftConfiguration> f_67014_ = StructureFeature.m_67089_("Mineshaft", new MineshaftFeature(MineshaftConfiguration.f_67780_), GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67015_ = StructureFeature.m_67089_("Mansion", new WoodlandMansionFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67016_ = StructureFeature.m_67089_("Jungle_Pyramid", new JunglePyramidFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67017_ = StructureFeature.m_67089_("Desert_Pyramid", new DesertPyramidFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67018_ = StructureFeature.m_67089_("Igloo", new IglooFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<RuinedPortalConfiguration> f_67019_ = StructureFeature.m_67089_("Ruined_Portal", new RuinedPortalFeature(RuinedPortalConfiguration.f_68054_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<ShipwreckConfiguration> f_67020_ = StructureFeature.m_67089_("Shipwreck", new ShipwreckFeature(ShipwreckConfiguration.f_68061_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67021_ = StructureFeature.m_67089_("Swamp_Hut", new SwamplandHutFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67022_ = StructureFeature.m_67089_("Stronghold", new StrongholdFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.STRONGHOLDS);
    public static final StructureFeature<NoneFeatureConfiguration> f_67023_ = StructureFeature.m_67089_("Monument", new OceanMonumentFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<OceanRuinConfiguration> f_67024_ = StructureFeature.m_67089_("Ocean_Ruin", new OceanRuinFeature(OceanRuinConfiguration.f_67820_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67025_ = StructureFeature.m_67089_("Fortress", new NetherFortressFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.UNDERGROUND_DECORATION);
    public static final StructureFeature<NoneFeatureConfiguration> f_67026_ = StructureFeature.m_67089_("EndCity", new EndCityFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<ProbabilityFeatureConfiguration> f_67027_ = StructureFeature.m_67089_("Buried_Treasure", new BuriedTreasureFeature(ProbabilityFeatureConfiguration.f_67858_), GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureFeature<JigsawConfiguration> f_67028_ = StructureFeature.m_67089_("Village", new VillageFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<RangeConfiguration> f_67029_ = StructureFeature.m_67089_("Nether_Fossil", new NetherFossilFeature(RangeConfiguration.f_191320_), GenerationStep.Decoration.UNDERGROUND_DECORATION);
    public static final StructureFeature<JigsawConfiguration> f_67030_ = StructureFeature.m_67089_("Bastion_Remnant", new BastionFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final List<StructureFeature<?>> f_67031_ = ImmutableList.of(f_67013_, f_67028_, f_67029_, f_67022_);
    public static final int f_160446_ = 8;
    private final Codec<ConfiguredStructureFeature<C, StructureFeature<C>>> f_67036_;
    private final PieceGeneratorSupplier<C> f_191106_;
    private final PostPlacementProcessor f_191107_;

    private static <F extends StructureFeature<?>> F m_67089_(String p_67090_, F p_67091_, GenerationStep.Decoration p_67092_) {
        f_67012_.put((Object)p_67090_.toLowerCase(Locale.ROOT), p_67091_);
        f_67032_.put(p_67091_, p_67092_);
        return (F)Registry.m_122961_(Registry.f_122841_, p_67090_.toLowerCase(Locale.ROOT), p_67091_);
    }

    public StructureFeature(Codec<C> p_197165_, PieceGeneratorSupplier<C> p_197166_) {
        this(p_197165_, p_197166_, PostPlacementProcessor.f_192427_);
    }

    public StructureFeature(Codec<C> p_197168_, PieceGeneratorSupplier<C> p_197169_, PostPlacementProcessor p_197170_) {
        this.f_67036_ = p_197168_.fieldOf("config").xmap(p_67094_ -> new ConfiguredStructureFeature<FeatureConfiguration, StructureFeature>(this, (FeatureConfiguration)p_67094_), p_67064_ -> p_67064_.f_65404_).codec();
        this.f_191106_ = p_197169_;
        this.f_191107_ = p_197170_;
    }

    public GenerationStep.Decoration m_67095_() {
        return f_67032_.get(this);
    }

    public static void m_67096_() {
    }

    @Nullable
    public static StructureStart<?> m_191128_(StructurePieceSerializationContext p_191129_, CompoundTag p_191130_, long p_191131_) {
        String $$3 = p_191130_.m_128461_("id");
        if ("INVALID".equals($$3)) {
            return StructureStart.f_73561_;
        }
        StructureFeature<?> $$4 = Registry.f_122841_.m_7745_(new ResourceLocation($$3.toLowerCase(Locale.ROOT)));
        if ($$4 == null) {
            f_67033_.error("Unknown feature id: {}", (Object)$$3);
            return null;
        }
        ChunkPos $$5 = new ChunkPos(p_191130_.m_128451_("ChunkX"), p_191130_.m_128451_("ChunkZ"));
        int $$6 = p_191130_.m_128451_("references");
        ListTag $$7 = p_191130_.m_128437_("Children", 10);
        try {
            PiecesContainer $$8 = PiecesContainer.m_192753_($$7, p_191129_);
            if ($$4 == f_67023_) {
                $$8 = OceanMonumentFeature.m_191020_($$5, p_191131_, $$8);
            }
            return new StructureStart($$4, $$5, $$6, $$8);
        }
        catch (Exception $$9) {
            f_67033_.error("Failed Start with id {}", (Object)$$3, (Object)$$9);
            return null;
        }
    }

    public Codec<ConfiguredStructureFeature<C, StructureFeature<C>>> m_67097_() {
        return this.f_67036_;
    }

    public ConfiguredStructureFeature<C, ? extends StructureFeature<C>> m_67065_(C p_67066_) {
        return new ConfiguredStructureFeature<C, StructureFeature>(this, p_67066_);
    }

    public BlockPos m_183220_(ChunkPos p_191115_) {
        return new BlockPos(p_191115_.m_45604_(), 0, p_191115_.m_45605_());
    }

    @Nullable
    public BlockPos m_67046_(LevelReader p_67047_, StructureFeatureManager p_67048_, BlockPos p_67049_, int p_67050_, boolean p_67051_, long p_67052_, StructureFeatureConfiguration p_67053_) {
        int $$7 = p_67053_.m_68171_();
        int $$8 = SectionPos.m_123171_(p_67049_.m_123341_());
        int $$9 = SectionPos.m_123171_(p_67049_.m_123343_());
        block0: for (int $$10 = 0; $$10 <= p_67050_; ++$$10) {
            for (int $$11 = -$$10; $$11 <= $$10; ++$$11) {
                boolean $$12 = $$11 == -$$10 || $$11 == $$10;
                for (int $$13 = -$$10; $$13 <= $$10; ++$$13) {
                    int $$16;
                    int $$15;
                    ChunkPos $$17;
                    StructureCheckResult $$18;
                    boolean $$14;
                    boolean bl = $$14 = $$13 == -$$10 || $$13 == $$10;
                    if (!$$12 && !$$14 || ($$18 = p_67048_.m_196670_($$17 = this.m_191122_(p_67053_, p_67052_, $$15 = $$8 + $$7 * $$11, $$16 = $$9 + $$7 * $$13), this, p_67051_)) == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!p_67051_ && $$18 == StructureCheckResult.START_PRESENT) {
                        return this.m_183220_($$17);
                    }
                    ChunkAccess $$19 = p_67047_.m_46819_($$17.f_45578_, $$17.f_45579_, ChunkStatus.f_62315_);
                    StructureStart<?> $$20 = p_67048_.m_47297_(SectionPos.m_175562_($$19), this, $$19);
                    if ($$20 != null && $$20.m_73603_()) {
                        if (p_67051_ && $$20.m_73606_()) {
                            p_67048_.m_196674_($$20);
                            return this.m_183220_($$20.m_163625_());
                        }
                        if (!p_67051_) {
                            return this.m_183220_($$20.m_163625_());
                        }
                    }
                    if ($$10 == 0) break;
                }
                if ($$10 == 0) continue block0;
            }
        }
        return null;
    }

    protected boolean m_5910_() {
        return true;
    }

    public final ChunkPos m_191122_(StructureFeatureConfiguration p_191123_, long p_191124_, int p_191125_, int p_191126_) {
        int $$12;
        int $$11;
        int $$4 = p_191123_.m_68171_();
        int $$5 = p_191123_.m_68176_();
        int $$6 = Math.floorDiv(p_191125_, $$4);
        int $$7 = Math.floorDiv(p_191126_, $$4);
        WorldgenRandom $$8 = new WorldgenRandom(new LegacyRandomSource(0L));
        $$8.m_190058_(p_191124_, $$6, $$7, p_191123_.m_68179_());
        if (this.m_5910_()) {
            int $$9 = $$8.nextInt($$4 - $$5);
            int $$10 = $$8.nextInt($$4 - $$5);
        } else {
            $$11 = ($$8.nextInt($$4 - $$5) + $$8.nextInt($$4 - $$5)) / 2;
            $$12 = ($$8.nextInt($$4 - $$5) + $$8.nextInt($$4 - $$5)) / 2;
        }
        return new ChunkPos($$6 * $$4 + $$11, $$7 * $$4 + $$12);
    }

    public StructureStart<?> m_191132_(RegistryAccess p_191133_, ChunkGenerator p_191134_, BiomeSource p_191135_, StructureManager p_191136_, long p_191137_, ChunkPos p_191138_, int p_191139_, StructureFeatureConfiguration p_191140_, C p_191141_, LevelHeightAccessor p_191142_, Predicate<Biome> p_191143_) {
        Optional<PieceGenerator<C>> $$12;
        ChunkPos $$11 = this.m_191122_(p_191140_, p_191137_, p_191138_.f_45578_, p_191138_.f_45579_);
        if (p_191138_.f_45578_ == $$11.f_45578_ && p_191138_.f_45579_ == $$11.f_45579_ && ($$12 = this.f_191106_.m_197347_(new PieceGeneratorSupplier.Context<C>(p_191134_, p_191135_, p_191137_, p_191138_, p_191141_, p_191142_, p_191143_, p_191136_, p_191133_))).isPresent()) {
            StructurePiecesBuilder $$13 = new StructurePiecesBuilder();
            WorldgenRandom $$14 = new WorldgenRandom(new LegacyRandomSource(0L));
            $$14.m_190068_(p_191137_, p_191138_.f_45578_, p_191138_.f_45579_);
            $$12.get().m_197325_($$13, new PieceGenerator.Context<C>(p_191141_, p_191134_, p_191136_, p_191138_, p_191142_, $$14, p_191137_));
            StructureStart $$15 = new StructureStart(this, p_191138_, p_191139_, $$13.m_192780_());
            if ($$15.m_73603_()) {
                return $$15;
            }
        }
        return StructureStart.f_73561_;
    }

    public boolean m_197171_(RegistryAccess p_197172_, ChunkGenerator p_197173_, BiomeSource p_197174_, StructureManager p_197175_, long p_197176_, ChunkPos p_197177_, C p_197178_, LevelHeightAccessor p_197179_, Predicate<Biome> p_197180_) {
        return this.f_191106_.m_197347_(new PieceGeneratorSupplier.Context<C>(p_197173_, p_197174_, p_197176_, p_197177_, p_197178_, p_197179_, p_197180_, p_197175_, p_197172_)).isPresent();
    }

    public PostPlacementProcessor m_191144_() {
        return this.f_191107_;
    }

    public String m_67098_() {
        return (String)f_67012_.inverse().get((Object)this);
    }

    public BoundingBox m_183606_(BoundingBox p_191127_) {
        return p_191127_;
    }
}

