/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SurfaceRules {
    public static final ConditionSource f_189375_ = SurfaceRules.m_189385_(0, false, false, CaveSurface.FLOOR);
    public static final ConditionSource f_189376_ = SurfaceRules.m_189385_(0, true, false, CaveSurface.FLOOR);
    public static final ConditionSource f_189377_ = SurfaceRules.m_189385_(0, false, false, CaveSurface.CEILING);
    public static final ConditionSource f_189378_ = SurfaceRules.m_189385_(0, true, false, CaveSurface.CEILING);

    public static ConditionSource m_189385_(int p_189386_, boolean p_189387_, boolean p_189388_, CaveSurface p_189389_) {
        return new StoneDepthCheck(p_189386_, p_189387_, p_189388_, p_189389_);
    }

    public static ConditionSource m_189392_(ConditionSource p_189393_) {
        return new NotConditionSource(p_189393_);
    }

    public static ConditionSource m_189400_(VerticalAnchor p_189401_, int p_189402_) {
        return new YConditionSource(p_189401_, p_189402_, false);
    }

    public static ConditionSource m_189422_(VerticalAnchor p_189423_, int p_189424_) {
        return new YConditionSource(p_189423_, p_189424_, true);
    }

    public static ConditionSource m_189382_(int p_189383_, int p_189384_) {
        return new WaterConditionSource(p_189383_, p_189384_, false);
    }

    public static ConditionSource m_189419_(int p_189420_, int p_189421_) {
        return new WaterConditionSource(p_189420_, p_189421_, true);
    }

    @SafeVarargs
    public static ConditionSource m_189416_(ResourceKey<Biome> ... p_189417_) {
        return SurfaceRules.m_189407_(List.of(p_189417_));
    }

    private static BiomeConditionSource m_189407_(List<ResourceKey<Biome>> p_189408_) {
        return new BiomeConditionSource(p_189408_);
    }

    public static ConditionSource m_189409_(ResourceKey<NormalNoise.NoiseParameters> p_189410_, double p_189411_) {
        return SurfaceRules.m_189412_(p_189410_, p_189411_, Double.MAX_VALUE);
    }

    public static ConditionSource m_189412_(ResourceKey<NormalNoise.NoiseParameters> p_189413_, double p_189414_, double p_189415_) {
        return new NoiseThresholdConditionSource(p_189413_, p_189414_, p_189415_);
    }

    public static ConditionSource m_189403_(String p_189404_, VerticalAnchor p_189405_, VerticalAnchor p_189406_) {
        return new VerticalGradientConditionSource(new ResourceLocation(p_189404_), p_189405_, p_189406_);
    }

    public static ConditionSource m_189381_() {
        return Steep.INSTANCE;
    }

    public static ConditionSource m_189418_() {
        return Hole.INSTANCE;
    }

    public static ConditionSource m_189425_() {
        return AbovePreliminarySurface.INSTANCE;
    }

    public static ConditionSource m_189426_() {
        return Temperature.INSTANCE;
    }

    public static RuleSource m_189394_(ConditionSource p_189395_, RuleSource p_189396_) {
        return new TestRuleSource(p_189395_, p_189396_);
    }

    public static RuleSource m_198272_(RuleSource ... p_198273_) {
        if (p_198273_.length == 0) {
            throw new IllegalArgumentException("Need at least 1 rule for a sequence");
        }
        return new SequenceRuleSource(Arrays.asList(p_198273_));
    }

    public static RuleSource m_189390_(BlockState p_189391_) {
        return new BlockRuleSource(p_189391_);
    }

    public static RuleSource m_189427_() {
        return Bandlands.INSTANCE;
    }

    record StoneDepthCheck(int f_189740_, boolean f_189741_, boolean f_189742_, CaveSurface f_189743_) implements ConditionSource
    {
        static final Codec<StoneDepthCheck> f_189744_ = RecordCodecBuilder.create(p_189753_ -> p_189753_.group((App)Codec.INT.fieldOf("offset").forGetter(StoneDepthCheck::f_189740_), (App)Codec.BOOL.fieldOf("add_surface_depth").forGetter(StoneDepthCheck::f_189741_), (App)Codec.BOOL.fieldOf("add_surface_secondary_depth").forGetter(StoneDepthCheck::f_189742_), (App)CaveSurface.f_162094_.fieldOf("surface_type").forGetter(StoneDepthCheck::f_189743_)).apply((Applicative)p_189753_, StoneDepthCheck::new));

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189744_;
        }

        @Override
        public Condition apply(final Context p_189755_) {
            final boolean $$1 = this.f_189743_ == CaveSurface.CEILING;
            class StoneDepthCondition
            extends LazyYCondition {
                StoneDepthCondition() {
                    super(context);
                }

                @Override
                protected boolean m_183479_() {
                    return ($$1 ? this.f_189616_.f_189559_ : this.f_189616_.f_189560_) <= 1 + StoneDepthCheck.this.f_189740_ + (StoneDepthCheck.this.f_189741_ ? this.f_189616_.f_189548_ : 0) + (StoneDepthCheck.this.f_189742_ ? this.f_189616_.m_189568_() : 0);
                }
            }
            return new StoneDepthCondition();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StoneDepthCheck.class, "offset;addSurfaceDepth;addSurfaceSecondaryDepth;surfaceType", "f_189740_", "f_189741_", "f_189742_", "f_189743_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StoneDepthCheck.class, "offset;addSurfaceDepth;addSurfaceSecondaryDepth;surfaceType", "f_189740_", "f_189741_", "f_189742_", "f_189743_"}, this);
        }

        @Override
        public final boolean equals(Object p_189762_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StoneDepthCheck.class, "offset;addSurfaceDepth;addSurfaceSecondaryDepth;surfaceType", "f_189740_", "f_189741_", "f_189742_", "f_189743_"}, this, p_189762_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record NotConditionSource(ConditionSource f_189667_) implements ConditionSource
    {
        static final Codec<NotConditionSource> f_189668_ = ConditionSource.f_189532_.xmap(NotConditionSource::new, NotConditionSource::f_189667_).fieldOf("invert").codec();

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189668_;
        }

        @Override
        public Condition apply(Context p_189674_) {
            return new NotCondition((Condition)this.f_189667_.apply(p_189674_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NotConditionSource.class, "target", "f_189667_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NotConditionSource.class, "target", "f_189667_"}, this);
        }

        @Override
        public final boolean equals(Object p_189679_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NotConditionSource.class, "target", "f_189667_"}, this, p_189679_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    public static interface ConditionSource
    extends Function<Context, Condition> {
        public static final Codec<ConditionSource> f_189532_ = Registry.f_194573_.m_194605_().dispatch(ConditionSource::m_183284_, Function.identity());

        public static Codec<? extends ConditionSource> m_189534_() {
            Registry.m_122961_(Registry.f_194573_, "biome", BiomeConditionSource.f_189490_);
            Registry.m_122961_(Registry.f_194573_, "noise_threshold", NoiseThresholdConditionSource.f_189630_);
            Registry.m_122961_(Registry.f_194573_, "vertical_gradient", VerticalGradientConditionSource.f_189831_);
            Registry.m_122961_(Registry.f_194573_, "y_above", YConditionSource.f_189447_);
            Registry.m_122961_(Registry.f_194573_, "water", WaterConditionSource.f_189866_);
            Registry.m_122961_(Registry.f_194573_, "temperature", Temperature.f_189778_);
            Registry.m_122961_(Registry.f_194573_, "steep", Steep.f_189725_);
            Registry.m_122961_(Registry.f_194573_, "not", NotConditionSource.f_189668_);
            Registry.m_122961_(Registry.f_194573_, "hole", Hole.f_189600_);
            Registry.m_122961_(Registry.f_194573_, "above_preliminary_surface", AbovePreliminarySurface.f_189429_);
            Registry.m_122961_(Registry.f_194573_, "stone_depth", StoneDepthCheck.f_189744_);
            return (Codec)Registry.f_194573_.iterator().next();
        }

        public Codec<? extends ConditionSource> m_183284_();
    }

    record YConditionSource(VerticalAnchor f_189444_, int f_189445_, boolean f_189446_) implements ConditionSource
    {
        static final Codec<YConditionSource> f_189447_ = RecordCodecBuilder.create(p_189455_ -> p_189455_.group((App)VerticalAnchor.f_158914_.fieldOf("anchor").forGetter(YConditionSource::f_189444_), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(YConditionSource::f_189445_), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(YConditionSource::f_189446_)).apply((Applicative)p_189455_, YConditionSource::new));

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189447_;
        }

        @Override
        public Condition apply(final Context p_189457_) {
            class YCondition
            extends LazyYCondition {
                YCondition() {
                    super(context);
                }

                @Override
                protected boolean m_183479_() {
                    return this.f_189616_.f_189557_ + (YConditionSource.this.f_189446_ ? this.f_189616_.f_189560_ : 0) >= YConditionSource.this.f_189444_.m_142322_(this.f_189616_.f_189544_) + this.f_189616_.f_189548_ * YConditionSource.this.f_189445_;
                }
            }
            return new YCondition();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{YConditionSource.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "f_189444_", "f_189445_", "f_189446_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{YConditionSource.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "f_189444_", "f_189445_", "f_189446_"}, this);
        }

        @Override
        public final boolean equals(Object p_189464_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{YConditionSource.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "f_189444_", "f_189445_", "f_189446_"}, this, p_189464_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record WaterConditionSource(int f_189863_, int f_189864_, boolean f_189865_) implements ConditionSource
    {
        static final Codec<WaterConditionSource> f_189866_ = RecordCodecBuilder.create(p_189874_ -> p_189874_.group((App)Codec.INT.fieldOf("offset").forGetter(WaterConditionSource::f_189863_), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(WaterConditionSource::f_189864_), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(WaterConditionSource::f_189865_)).apply((Applicative)p_189874_, WaterConditionSource::new));

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189866_;
        }

        @Override
        public Condition apply(final Context p_189876_) {
            class WaterCondition
            extends LazyYCondition {
                WaterCondition() {
                    super(context);
                }

                @Override
                protected boolean m_183479_() {
                    return this.f_189616_.f_189558_ == Integer.MIN_VALUE || this.f_189616_.f_189557_ + (WaterConditionSource.this.f_189865_ ? this.f_189616_.f_189560_ : 0) >= this.f_189616_.f_189558_ + WaterConditionSource.this.f_189863_ + this.f_189616_.f_189548_ * WaterConditionSource.this.f_189864_;
                }
            }
            return new WaterCondition();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{WaterConditionSource.class, "offset;surfaceDepthMultiplier;addStoneDepth", "f_189863_", "f_189864_", "f_189865_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WaterConditionSource.class, "offset;surfaceDepthMultiplier;addStoneDepth", "f_189863_", "f_189864_", "f_189865_"}, this);
        }

        @Override
        public final boolean equals(Object p_189883_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WaterConditionSource.class, "offset;surfaceDepthMultiplier;addStoneDepth", "f_189863_", "f_189864_", "f_189865_"}, this, p_189883_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record BiomeConditionSource(List<ResourceKey<Biome>> f_189489_) implements ConditionSource
    {
        static final Codec<BiomeConditionSource> f_189490_ = ResourceKey.m_195966_(Registry.f_122885_).listOf().fieldOf("biome_is").xmap(SurfaceRules::m_189407_, BiomeConditionSource::f_189489_).codec();

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189490_;
        }

        @Override
        public Condition apply(final Context p_189496_) {
            final Set<ResourceKey<Biome>> $$1 = Set.copyOf(this.f_189489_);
            class BiomeCondition
            extends LazyYCondition {
                BiomeCondition() {
                    super(context);
                }

                @Override
                protected boolean m_183479_() {
                    return $$1.contains(this.f_189616_.f_189556_.get());
                }
            }
            return new BiomeCondition();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BiomeConditionSource.class, "biomes", "f_189489_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BiomeConditionSource.class, "biomes", "f_189489_"}, this);
        }

        @Override
        public final boolean equals(Object p_189501_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BiomeConditionSource.class, "biomes", "f_189489_"}, this, p_189501_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record NoiseThresholdConditionSource(ResourceKey<NormalNoise.NoiseParameters> f_189627_, double f_189628_, double f_189629_) implements ConditionSource
    {
        static final Codec<NoiseThresholdConditionSource> f_189630_ = RecordCodecBuilder.create(p_189638_ -> p_189638_.group((App)ResourceKey.m_195966_(Registry.f_194568_).fieldOf("noise").forGetter(NoiseThresholdConditionSource::f_189627_), (App)Codec.DOUBLE.fieldOf("min_threshold").forGetter(NoiseThresholdConditionSource::f_189628_), (App)Codec.DOUBLE.fieldOf("max_threshold").forGetter(NoiseThresholdConditionSource::f_189629_)).apply((Applicative)p_189638_, NoiseThresholdConditionSource::new));

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189630_;
        }

        @Override
        public Condition apply(final Context p_189640_) {
            final NormalNoise $$1 = p_189640_.f_189535_.m_189983_(this.f_189627_);
            class NoiseThresholdCondition
            extends LazyXZCondition {
                NoiseThresholdCondition() {
                    super(context);
                }

                @Override
                protected boolean m_183479_() {
                    double $$0 = $$1.m_75380_(this.f_189616_.f_189546_, 0.0, this.f_189616_.f_189547_);
                    return $$0 >= NoiseThresholdConditionSource.this.f_189628_ && $$0 <= NoiseThresholdConditionSource.this.f_189629_;
                }
            }
            return new NoiseThresholdCondition();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseThresholdConditionSource.class, "noise;minThreshold;maxThreshold", "f_189627_", "f_189628_", "f_189629_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseThresholdConditionSource.class, "noise;minThreshold;maxThreshold", "f_189627_", "f_189628_", "f_189629_"}, this);
        }

        @Override
        public final boolean equals(Object p_189647_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseThresholdConditionSource.class, "noise;minThreshold;maxThreshold", "f_189627_", "f_189628_", "f_189629_"}, this, p_189647_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record VerticalGradientConditionSource(ResourceLocation f_189828_, VerticalAnchor f_189829_, VerticalAnchor f_189830_) implements ConditionSource
    {
        static final Codec<VerticalGradientConditionSource> f_189831_ = RecordCodecBuilder.create(p_189839_ -> p_189839_.group((App)ResourceLocation.f_135803_.fieldOf("random_name").forGetter(VerticalGradientConditionSource::f_189828_), (App)VerticalAnchor.f_158914_.fieldOf("true_at_and_below").forGetter(VerticalGradientConditionSource::f_189829_), (App)VerticalAnchor.f_158914_.fieldOf("false_at_and_above").forGetter(VerticalGradientConditionSource::f_189830_)).apply((Applicative)p_189839_, VerticalGradientConditionSource::new));

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189831_;
        }

        @Override
        public Condition apply(final Context p_189841_) {
            final int $$1 = this.f_189829_().m_142322_(p_189841_.f_189544_);
            final int $$2 = this.f_189830_().m_142322_(p_189841_.f_189544_);
            final PositionalRandomFactory $$3 = p_189841_.f_189535_.m_189988_(this.f_189828_());
            class VerticalGradientCondition
            extends LazyYCondition {
                VerticalGradientCondition() {
                    super(context);
                }

                @Override
                protected boolean m_183479_() {
                    int $$0 = this.f_189616_.f_189557_;
                    if ($$0 <= $$1) {
                        return true;
                    }
                    if ($$0 >= $$2) {
                        return false;
                    }
                    double $$12 = Mth.m_144914_($$0, $$1, $$2, 1.0, 0.0);
                    RandomSource $$22 = $$3.m_183161_(this.f_189616_.f_189546_, $$0, this.f_189616_.f_189547_);
                    return (double)$$22.nextFloat() < $$12;
                }
            }
            return new VerticalGradientCondition();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{VerticalGradientConditionSource.class, "randomName;trueAtAndBelow;falseAtAndAbove", "f_189828_", "f_189829_", "f_189830_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{VerticalGradientConditionSource.class, "randomName;trueAtAndBelow;falseAtAndAbove", "f_189828_", "f_189829_", "f_189830_"}, this);
        }

        @Override
        public final boolean equals(Object p_189848_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{VerticalGradientConditionSource.class, "randomName;trueAtAndBelow;falseAtAndAbove", "f_189828_", "f_189829_", "f_189830_"}, this, p_189848_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    static final class Steep
    extends Enum<Steep>
    implements ConditionSource {
        public static final /* enum */ Steep INSTANCE = new Steep();
        static final Codec<Steep> f_189725_;
        private static final /* synthetic */ Steep[] $VALUES;

        public static Steep[] values() {
            return (Steep[])$VALUES.clone();
        }

        public static Steep valueOf(String p_189738_) {
            return Enum.valueOf(Steep.class, p_189738_);
        }

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189725_;
        }

        @Override
        public Condition apply(Context p_189733_) {
            return p_189733_.f_189537_;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        private static /* synthetic */ Steep[] m_189736_() {
            return new Steep[]{INSTANCE};
        }

        static {
            $VALUES = Steep.m_189736_();
            f_189725_ = Codec.unit((Object)INSTANCE);
        }
    }

    static final class Hole
    extends Enum<Hole>
    implements ConditionSource {
        public static final /* enum */ Hole INSTANCE = new Hole();
        static final Codec<Hole> f_189600_;
        private static final /* synthetic */ Hole[] $VALUES;

        public static Hole[] values() {
            return (Hole[])$VALUES.clone();
        }

        public static Hole valueOf(String p_189613_) {
            return Enum.valueOf(Hole.class, p_189613_);
        }

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189600_;
        }

        @Override
        public Condition apply(Context p_189608_) {
            return p_189608_.f_189538_;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        private static /* synthetic */ Hole[] m_189611_() {
            return new Hole[]{INSTANCE};
        }

        static {
            $VALUES = Hole.m_189611_();
            f_189600_ = Codec.unit((Object)INSTANCE);
        }
    }

    static final class AbovePreliminarySurface
    extends Enum<AbovePreliminarySurface>
    implements ConditionSource {
        public static final /* enum */ AbovePreliminarySurface INSTANCE = new AbovePreliminarySurface();
        static final Codec<AbovePreliminarySurface> f_189429_;
        private static final /* synthetic */ AbovePreliminarySurface[] $VALUES;

        public static AbovePreliminarySurface[] values() {
            return (AbovePreliminarySurface[])$VALUES.clone();
        }

        public static AbovePreliminarySurface valueOf(String p_189442_) {
            return Enum.valueOf(AbovePreliminarySurface.class, p_189442_);
        }

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189429_;
        }

        @Override
        public Condition apply(Context p_189437_) {
            return p_189437_.f_189539_;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        private static /* synthetic */ AbovePreliminarySurface[] m_189440_() {
            return new AbovePreliminarySurface[]{INSTANCE};
        }

        static {
            $VALUES = AbovePreliminarySurface.m_189440_();
            f_189429_ = Codec.unit((Object)INSTANCE);
        }
    }

    static final class Temperature
    extends Enum<Temperature>
    implements ConditionSource {
        public static final /* enum */ Temperature INSTANCE = new Temperature();
        static final Codec<Temperature> f_189778_;
        private static final /* synthetic */ Temperature[] $VALUES;

        public static Temperature[] values() {
            return (Temperature[])$VALUES.clone();
        }

        public static Temperature valueOf(String p_189791_) {
            return Enum.valueOf(Temperature.class, p_189791_);
        }

        @Override
        public Codec<? extends ConditionSource> m_183284_() {
            return f_189778_;
        }

        @Override
        public Condition apply(Context p_189786_) {
            return p_189786_.f_189536_;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        private static /* synthetic */ Temperature[] m_189789_() {
            return new Temperature[]{INSTANCE};
        }

        static {
            $VALUES = Temperature.m_189789_();
            f_189778_ = Codec.unit((Object)INSTANCE);
        }
    }

    record TestRuleSource(ConditionSource f_189808_, RuleSource f_189809_) implements RuleSource
    {
        static final Codec<TestRuleSource> f_189810_ = RecordCodecBuilder.create(p_189817_ -> p_189817_.group((App)ConditionSource.f_189532_.fieldOf("if_true").forGetter(TestRuleSource::f_189808_), (App)RuleSource.f_189682_.fieldOf("then_run").forGetter(TestRuleSource::f_189809_)).apply((Applicative)p_189817_, TestRuleSource::new));

        @Override
        public Codec<? extends RuleSource> m_183290_() {
            return f_189810_;
        }

        @Override
        public SurfaceRule apply(Context p_189819_) {
            return new TestRule((Condition)this.f_189808_.apply(p_189819_), (SurfaceRule)this.f_189809_.apply(p_189819_));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TestRuleSource.class, "ifTrue;thenRun", "f_189808_", "f_189809_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TestRuleSource.class, "ifTrue;thenRun", "f_189808_", "f_189809_"}, this);
        }

        @Override
        public final boolean equals(Object p_189825_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TestRuleSource.class, "ifTrue;thenRun", "f_189808_", "f_189809_"}, this, p_189825_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    public static interface RuleSource
    extends Function<Context, SurfaceRule> {
        public static final Codec<RuleSource> f_189682_ = Registry.f_194574_.m_194605_().dispatch(RuleSource::m_183290_, Function.identity());

        public static Codec<? extends RuleSource> m_189684_() {
            Registry.m_122961_(Registry.f_194574_, "bandlands", Bandlands.f_189474_);
            Registry.m_122961_(Registry.f_194574_, "block", BlockRuleSource.f_189514_);
            Registry.m_122961_(Registry.f_194574_, "sequence", SequenceRuleSource.f_189698_);
            Registry.m_122961_(Registry.f_194574_, "condition", TestRuleSource.f_189810_);
            return (Codec)Registry.f_194574_.iterator().next();
        }

        public Codec<? extends RuleSource> m_183290_();
    }

    record SequenceRuleSource(List<RuleSource> f_189697_) implements RuleSource
    {
        static final Codec<SequenceRuleSource> f_189698_ = RuleSource.f_189682_.listOf().xmap(SequenceRuleSource::new, SequenceRuleSource::f_189697_).fieldOf("sequence").codec();

        @Override
        public Codec<? extends RuleSource> m_183290_() {
            return f_189698_;
        }

        @Override
        public SurfaceRule apply(Context p_189704_) {
            if (this.f_189697_.size() == 1) {
                return (SurfaceRule)this.f_189697_.get(0).apply(p_189704_);
            }
            ImmutableList.Builder $$1 = ImmutableList.builder();
            for (RuleSource $$2 : this.f_189697_) {
                $$1.add((Object)((SurfaceRule)$$2.apply(p_189704_)));
            }
            return new SequenceRule((List<SurfaceRule>)$$1.build());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SequenceRuleSource.class, "sequence", "f_189697_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SequenceRuleSource.class, "sequence", "f_189697_"}, this);
        }

        @Override
        public final boolean equals(Object p_189709_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SequenceRuleSource.class, "sequence", "f_189697_"}, this, p_189709_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    record BlockRuleSource(BlockState f_189512_, StateRule f_189513_) implements RuleSource
    {
        static final Codec<BlockRuleSource> f_189514_ = BlockState.f_61039_.xmap(BlockRuleSource::new, BlockRuleSource::f_189512_).fieldOf("result_state").codec();

        BlockRuleSource(BlockState p_189517_) {
            this(p_189517_, new StateRule(p_189517_));
        }

        @Override
        public Codec<? extends RuleSource> m_183290_() {
            return f_189514_;
        }

        @Override
        public SurfaceRule apply(Context p_189523_) {
            return this.f_189513_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockRuleSource.class, "resultState;rule", "f_189512_", "f_189513_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockRuleSource.class, "resultState;rule", "f_189512_", "f_189513_"}, this);
        }

        @Override
        public final boolean equals(Object p_189529_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockRuleSource.class, "resultState;rule", "f_189512_", "f_189513_"}, this, p_189529_);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }
    }

    static final class Bandlands
    extends Enum<Bandlands>
    implements RuleSource {
        public static final /* enum */ Bandlands INSTANCE = new Bandlands();
        static final Codec<Bandlands> f_189474_;
        private static final /* synthetic */ Bandlands[] $VALUES;

        public static Bandlands[] values() {
            return (Bandlands[])$VALUES.clone();
        }

        public static Bandlands valueOf(String p_189487_) {
            return Enum.valueOf(Bandlands.class, p_189487_);
        }

        @Override
        public Codec<? extends RuleSource> m_183290_() {
            return f_189474_;
        }

        @Override
        public SurfaceRule apply(Context p_189482_) {
            return p_189482_.f_189535_::m_189930_;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((Context)object);
        }

        private static /* synthetic */ Bandlands[] m_189485_() {
            return new Bandlands[]{INSTANCE};
        }

        static {
            $VALUES = Bandlands.m_189485_();
            f_189474_ = Codec.unit((Object)INSTANCE);
        }
    }

    record SequenceRule(List<SurfaceRule> f_189685_) implements SurfaceRule
    {
        @Override
        @Nullable
        public BlockState m_183550_(int p_189694_, int p_189695_, int p_189696_) {
            for (SurfaceRule $$3 : this.f_189685_) {
                BlockState $$4 = $$3.m_183550_(p_189694_, p_189695_, p_189696_);
                if ($$4 == null) continue;
                return $$4;
            }
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SequenceRule.class, "rules", "f_189685_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SequenceRule.class, "rules", "f_189685_"}, this);
        }

        @Override
        public final boolean equals(Object p_189690_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SequenceRule.class, "rules", "f_189685_"}, this, p_189690_);
        }
    }

    record TestRule(Condition f_189793_, SurfaceRule f_189794_) implements SurfaceRule
    {
        @Override
        @Nullable
        public BlockState m_183550_(int p_189805_, int p_189806_, int p_189807_) {
            if (!this.f_189793_.m_183475_()) {
                return null;
            }
            return this.f_189794_.m_183550_(p_189805_, p_189806_, p_189807_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TestRule.class, "condition;followup", "f_189793_", "f_189794_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TestRule.class, "condition;followup", "f_189793_", "f_189794_"}, this);
        }

        @Override
        public final boolean equals(Object p_189801_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TestRule.class, "condition;followup", "f_189793_", "f_189794_"}, this, p_189801_);
        }
    }

    record StateRule(BlockState f_189712_) implements SurfaceRule
    {
        @Override
        public BlockState m_183550_(int p_189721_, int p_189722_, int p_189723_) {
            return this.f_189712_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StateRule.class, "state", "f_189712_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StateRule.class, "state", "f_189712_"}, this);
        }

        @Override
        public final boolean equals(Object p_189717_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StateRule.class, "state", "f_189712_"}, this, p_189717_);
        }
    }

    protected static interface SurfaceRule {
        @Nullable
        public BlockState m_183550_(int var1, int var2, int var3);
    }

    record NotCondition(Condition f_189658_) implements Condition
    {
        @Override
        public boolean m_183475_() {
            return !this.f_189658_.m_183475_();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NotCondition.class, "target", "f_189658_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NotCondition.class, "target", "f_189658_"}, this);
        }

        @Override
        public final boolean equals(Object p_189664_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NotCondition.class, "target", "f_189658_"}, this, p_189664_);
        }
    }

    static abstract class LazyYCondition
    extends LazyCondition {
        protected LazyYCondition(Context p_189625_) {
            super(p_189625_);
        }

        @Override
        protected long m_183477_() {
            return this.f_189616_.f_189553_;
        }
    }

    static abstract class LazyXZCondition
    extends LazyCondition {
        protected LazyXZCondition(Context p_189622_) {
            super(p_189622_);
        }

        @Override
        protected long m_183477_() {
            return this.f_189616_.f_189545_;
        }
    }

    static abstract class LazyCondition
    implements Condition {
        protected final Context f_189616_;
        private long f_189615_;
        @Nullable
        Boolean f_189617_;

        protected LazyCondition(Context p_189619_) {
            this.f_189616_ = p_189619_;
            this.f_189615_ = this.m_183477_() - 1L;
        }

        @Override
        public boolean m_183475_() {
            long $$0 = this.m_183477_();
            if ($$0 == this.f_189615_) {
                if (this.f_189617_ == null) {
                    throw new IllegalStateException("Update triggered but the result is null");
                }
                return this.f_189617_;
            }
            this.f_189615_ = $$0;
            this.f_189617_ = this.m_183479_();
            return this.f_189617_;
        }

        protected abstract long m_183477_();

        protected abstract boolean m_183479_();
    }

    static interface Condition {
        public boolean m_183475_();
    }

    protected static final class Context {
        private static final int f_198274_ = 8;
        private static final int f_198275_ = 4;
        private static final int f_198276_ = 16;
        private static final int f_198277_ = 15;
        final SurfaceSystem f_189535_;
        final Condition f_189536_ = new TemperatureHelperCondition(this);
        final Condition f_189537_ = new SteepMaterialCondition(this);
        final Condition f_189538_ = new HoleCondition(this);
        final Condition f_189539_ = new AbovePreliminarySurfaceCondition();
        final ChunkAccess f_189540_;
        private final NoiseChunk f_189541_;
        private final Function<BlockPos, Biome> f_189542_;
        private final Registry<Biome> f_189543_;
        final WorldGenerationContext f_189544_;
        private long f_198278_ = Long.MAX_VALUE;
        private final int[] f_198279_ = new int[4];
        long f_189545_ = -9223372036854775807L;
        int f_189546_;
        int f_189547_;
        int f_189548_;
        private long f_189549_ = this.f_189545_ - 1L;
        private int f_189550_;
        private long f_189551_ = this.f_189545_ - 1L;
        private int f_189552_;
        long f_189553_ = -9223372036854775807L;
        final BlockPos.MutableBlockPos f_189554_ = new BlockPos.MutableBlockPos();
        Supplier<Biome> f_189555_;
        Supplier<ResourceKey<Biome>> f_189556_;
        int f_189557_;
        int f_189558_;
        int f_189559_;
        int f_189560_;

        protected Context(SurfaceSystem p_189562_, ChunkAccess p_189563_, NoiseChunk p_189564_, Function<BlockPos, Biome> p_189565_, Registry<Biome> p_189566_, WorldGenerationContext p_189567_) {
            this.f_189535_ = p_189562_;
            this.f_189540_ = p_189563_;
            this.f_189541_ = p_189564_;
            this.f_189542_ = p_189565_;
            this.f_189543_ = p_189566_;
            this.f_189544_ = p_189567_;
        }

        protected void m_189569_(int p_189570_, int p_189571_) {
            ++this.f_189545_;
            ++this.f_189553_;
            this.f_189546_ = p_189570_;
            this.f_189547_ = p_189571_;
            this.f_189548_ = this.f_189535_.m_189927_(p_189570_, p_189571_);
        }

        protected void m_189576_(int p_189577_, int p_189578_, int p_189579_, int p_189580_, int p_189581_, int p_189582_) {
            ++this.f_189553_;
            this.f_189555_ = Suppliers.memoize(() -> this.f_189542_.apply(this.f_189554_.m_122178_(p_189580_, p_189581_, p_189582_)));
            this.f_189556_ = Suppliers.memoize(() -> this.f_189543_.m_7854_(this.f_189555_.get()).orElseThrow(() -> new IllegalStateException("Unregistered biome: " + this.f_189555_)));
            this.f_189557_ = p_189581_;
            this.f_189558_ = p_189579_;
            this.f_189559_ = p_189578_;
            this.f_189560_ = p_189577_;
        }

        protected int m_189568_() {
            if (this.f_189549_ != this.f_189545_) {
                this.f_189549_ = this.f_189545_;
                this.f_189550_ = this.f_189535_.m_189993_(this.f_189546_, this.f_189547_);
            }
            return this.f_189550_;
        }

        private static int m_198280_(int p_198281_) {
            return p_198281_ >> 4;
        }

        private static int m_198282_(int p_198283_) {
            return p_198283_ << 4;
        }

        protected int m_189583_() {
            if (this.f_189551_ != this.f_189545_) {
                int $$1;
                this.f_189551_ = this.f_189545_;
                int $$0 = Context.m_198280_(this.f_189546_);
                long $$2 = ChunkPos.m_45589_($$0, $$1 = Context.m_198280_(this.f_189547_));
                if (this.f_198278_ != $$2) {
                    this.f_198278_ = $$2;
                    this.f_198279_[0] = this.f_189541_.m_198256_(Context.m_198282_($$0), Context.m_198282_($$1));
                    this.f_198279_[1] = this.f_189541_.m_198256_(Context.m_198282_($$0 + 1), Context.m_198282_($$1));
                    this.f_198279_[2] = this.f_189541_.m_198256_(Context.m_198282_($$0), Context.m_198282_($$1 + 1));
                    this.f_198279_[3] = this.f_189541_.m_198256_(Context.m_198282_($$0 + 1), Context.m_198282_($$1 + 1));
                }
                int $$3 = Mth.m_14107_(Mth.m_14012_((float)(this.f_189546_ & 0xF) / 16.0f, (float)(this.f_189547_ & 0xF) / 16.0f, this.f_198279_[0], this.f_198279_[1], this.f_198279_[2], this.f_198279_[3]));
                this.f_189552_ = $$3 + this.f_189548_ - 8;
            }
            return this.f_189552_;
        }

        static class TemperatureHelperCondition
        extends LazyYCondition {
            TemperatureHelperCondition(Context p_189597_) {
                super(p_189597_);
            }

            @Override
            protected boolean m_183479_() {
                return this.f_189616_.f_189555_.get().m_198904_(this.f_189616_.f_189554_.m_122178_(this.f_189616_.f_189546_, this.f_189616_.f_189557_, this.f_189616_.f_189547_));
            }
        }

        static class SteepMaterialCondition
        extends LazyXZCondition {
            SteepMaterialCondition(Context p_189594_) {
                super(p_189594_);
            }

            @Override
            protected boolean m_183479_() {
                int $$10;
                int $$0 = this.f_189616_.f_189546_ & 0xF;
                int $$1 = this.f_189616_.f_189547_ & 0xF;
                int $$2 = Math.max($$1 - 1, 0);
                int $$3 = Math.min($$1 + 1, 15);
                ChunkAccess $$4 = this.f_189616_.f_189540_;
                int $$5 = $$4.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, $$0, $$2);
                int $$6 = $$4.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, $$0, $$3);
                if ($$6 >= $$5 + 4) {
                    return true;
                }
                int $$7 = Math.max($$0 - 1, 0);
                int $$8 = Math.min($$0 + 1, 15);
                int $$9 = $$4.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, $$7, $$1);
                return $$9 >= ($$10 = $$4.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, $$8, $$1)) + 4;
            }
        }

        static final class HoleCondition
        extends LazyXZCondition {
            HoleCondition(Context p_189591_) {
                super(p_189591_);
            }

            @Override
            protected boolean m_183479_() {
                return this.f_189616_.f_189548_ <= 0;
            }
        }

        final class AbovePreliminarySurfaceCondition
        implements Condition {
            AbovePreliminarySurfaceCondition() {
            }

            @Override
            public boolean m_183475_() {
                return Context.this.f_189557_ >= Context.this.m_189583_();
            }
        }
    }
}

