/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger f_63515_ = LogManager.getLogger();
    private final AtomicBoolean f_63516_ = new AtomicBoolean();
    private final ProcessorMailbox<StrictQueue.IntRunnable> f_63517_;
    private final RegionFileStorage f_63518_;
    private final Map<ChunkPos, PendingStore> f_63519_ = Maps.newLinkedHashMap();

    protected IOWorker(Path p_196930_, boolean p_196931_, String p_196932_) {
        this.f_63518_ = new RegionFileStorage(p_196930_, p_196931_);
        this.f_63517_ = new ProcessorMailbox<StrictQueue.IntRunnable>(new StrictQueue.FixedPriorityQueue(Priority.values().length), Util.m_183992_(), "IOWorker-" + p_196932_);
    }

    public CompletableFuture<Void> m_63538_(ChunkPos p_63539_, @Nullable CompoundTag p_63540_) {
        return this.m_63545_(() -> {
            PendingStore $$2 = this.f_63519_.computeIfAbsent(p_63539_, p_156584_ -> new PendingStore(p_63540_));
            $$2.f_63565_ = p_63540_;
            return Either.left($$2.f_63566_);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public CompoundTag m_63533_(ChunkPos p_63534_) throws IOException {
        CompletableFuture<CompoundTag> $$1 = this.m_156587_(p_63534_);
        try {
            return $$1.join();
        }
        catch (CompletionException $$2) {
            if ($$2.getCause() instanceof IOException) {
                throw (IOException)$$2.getCause();
            }
            throw $$2;
        }
    }

    protected CompletableFuture<CompoundTag> m_156587_(ChunkPos p_156588_) {
        return this.m_63545_(() -> {
            PendingStore $$1 = this.f_63519_.get(p_156588_);
            if ($$1 != null) {
                return Either.left((Object)$$1.f_63565_);
            }
            try {
                CompoundTag $$2 = this.f_63518_.m_63706_(p_156588_);
                return Either.left((Object)$$2);
            }
            catch (Exception $$3) {
                f_63515_.warn("Failed to read chunk {}", (Object)p_156588_, (Object)$$3);
                return Either.right((Object)$$3);
            }
        });
    }

    public CompletableFuture<Void> m_182498_(boolean p_182499_) {
        CompletionStage $$1 = this.m_63545_(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.f_63519_.values().stream().map(p_156581_ -> p_156581_.f_63566_).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        if (p_182499_) {
            return ((CompletableFuture)$$1).thenCompose(p_63544_ -> this.m_63545_(() -> {
                try {
                    this.f_63518_.m_63705_();
                    return Either.left(null);
                }
                catch (Exception $$0) {
                    f_63515_.warn("Failed to synchronize chunks", (Throwable)$$0);
                    return Either.right((Object)$$0);
                }
            }));
        }
        return ((CompletableFuture)$$1).thenCompose(p_182494_ -> this.m_63545_(() -> Either.left(null)));
    }

    @Override
    public CompletableFuture<Void> m_196358_(ChunkPos p_196939_, StreamTagVisitor p_196940_) {
        return this.m_63545_(() -> {
            try {
                PendingStore $$2 = this.f_63519_.get(p_196939_);
                if ($$2 != null) {
                    if ($$2.f_63565_ != null) {
                        $$2.f_63565_.m_197573_(p_196940_);
                    }
                } else {
                    this.f_63518_.m_196956_(p_196939_, p_196940_);
                }
                return Either.left(null);
            }
            catch (Exception $$3) {
                f_63515_.warn("Failed to bulk scan chunk {}", (Object)p_196939_, (Object)$$3);
                return Either.right((Object)$$3);
            }
        });
    }

    private <T> CompletableFuture<T> m_63545_(Supplier<Either<T, Exception>> p_63546_) {
        return this.f_63517_.m_18722_(p_196943_ -> new StrictQueue.IntRunnable(Priority.FOREGROUND.ordinal(), () -> this.m_196935_(p_196943_, (Supplier)p_63546_)));
    }

    private void m_63553_() {
        if (this.f_63519_.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ChunkPos, PendingStore>> $$0 = this.f_63519_.entrySet().iterator();
        Map.Entry<ChunkPos, PendingStore> $$1 = $$0.next();
        $$0.remove();
        this.m_63535_($$1.getKey(), $$1.getValue());
        this.m_63561_();
    }

    private void m_63561_() {
        this.f_63517_.m_6937_(new StrictQueue.IntRunnable(Priority.BACKGROUND.ordinal(), this::m_63553_));
    }

    private void m_63535_(ChunkPos p_63536_, PendingStore p_63537_) {
        try {
            this.f_63518_.m_63708_(p_63536_, p_63537_.f_63565_);
            p_63537_.f_63566_.complete(null);
        }
        catch (Exception $$2) {
            f_63515_.error("Failed to store chunk {}", (Object)p_63536_, (Object)$$2);
            p_63537_.f_63566_.completeExceptionally($$2);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.f_63516_.compareAndSet(false, true)) {
            return;
        }
        this.f_63517_.m_18720_(p_196934_ -> new StrictQueue.IntRunnable(Priority.SHUTDOWN.ordinal(), () -> p_196934_.m_6937_(Unit.INSTANCE))).join();
        this.f_63517_.close();
        try {
            this.f_63518_.close();
        }
        catch (Exception $$0) {
            f_63515_.error("Failed to close storage", (Throwable)$$0);
        }
    }

    private /* synthetic */ void m_196935_(ProcessorHandle p_196936_, Supplier p_196937_) {
        if (!this.f_63516_.get()) {
            p_196936_.m_6937_((Either)p_196937_.get());
        }
        this.m_63561_();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority FOREGROUND = new Priority();
        public static final /* enum */ Priority BACKGROUND = new Priority();
        public static final /* enum */ Priority SHUTDOWN = new Priority();
        private static final /* synthetic */ Priority[] $VALUES;

        public static Priority[] values() {
            return (Priority[])$VALUES.clone();
        }

        public static Priority valueOf(String p_63584_) {
            return Enum.valueOf(Priority.class, p_63584_);
        }

        private static /* synthetic */ Priority[] m_156595_() {
            return new Priority[]{FOREGROUND, BACKGROUND, SHUTDOWN};
        }

        static {
            $VALUES = Priority.m_156595_();
        }
    }

    static class PendingStore {
        @Nullable
        CompoundTag f_63565_;
        final CompletableFuture<Void> f_63566_ = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag p_63568_) {
            this.f_63565_ = p_63568_;
        }
    }
}

