/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.util.Graph;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class BiomeSource
implements BiomeResolver {
    public static final Codec<BiomeSource> f_47888_;
    private final Set<Biome> f_47891_;
    private final List<StepFeatureData> f_186695_;

    protected BiomeSource(Stream<Supplier<Biome>> p_47896_) {
        this((List)p_47896_.map(Supplier::get).distinct().collect(ImmutableList.toImmutableList()));
    }

    protected BiomeSource(List<Biome> p_47894_) {
        this.f_47891_ = new ObjectLinkedOpenHashSet(p_47894_);
        this.f_186695_ = this.m_186727_(p_47894_, true);
    }

    private List<StepFeatureData> m_186727_(List<Biome> p_186728_, boolean p_186729_) {
        Object2IntOpenHashMap $$2 = new Object2IntOpenHashMap();
        MutableInt $$3 = new MutableInt(0);
        record FeatureData(int f_186739_, int f_186740_, PlacedFeature f_186741_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{FeatureData.class, "featureIndex;step;feature", "f_186739_", "f_186740_", "f_186741_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FeatureData.class, "featureIndex;step;feature", "f_186739_", "f_186740_", "f_186741_"}, this);
            }

            @Override
            public final boolean equals(Object p_186750_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FeatureData.class, "featureIndex;step;feature", "f_186739_", "f_186740_", "f_186741_"}, this, p_186750_);
            }
        }
        Comparator<FeatureData> $$4 = Comparator.comparingInt(FeatureData::f_186740_).thenComparingInt(FeatureData::f_186739_);
        TreeMap<FeatureData, Set> $$5 = new TreeMap<FeatureData, Set>($$4);
        int $$6 = 0;
        for (Biome $$7 : p_186728_) {
            ArrayList $$8 = Lists.newArrayList();
            List<List<Supplier<PlacedFeature>>> $$9 = $$7.m_47536_().m_47818_();
            $$6 = Math.max($$6, $$9.size());
            for (int $$10 = 0; $$10 < $$9.size(); ++$$10) {
                for (Supplier $$11 : (List)$$9.get($$10)) {
                    PlacedFeature $$12 = (PlacedFeature)$$11.get();
                    $$8.add(new FeatureData($$2.computeIfAbsent((Object)$$12, p_186732_ -> $$3.getAndIncrement()), $$10, $$12));
                }
            }
            for (int $$13 = 0; $$13 < $$8.size(); ++$$13) {
                Set $$14 = $$5.computeIfAbsent((FeatureData)$$8.get($$13), p_186723_ -> new TreeSet($$4));
                if ($$13 >= $$8.size() - 1) continue;
                $$14.add((FeatureData)$$8.get($$13 + 1));
            }
        }
        TreeSet<FeatureData> $$15 = new TreeSet<FeatureData>($$4);
        TreeSet<FeatureData> $$16 = new TreeSet<FeatureData>($$4);
        ArrayList $$17 = Lists.newArrayList();
        for (FeatureData $$18 : $$5.keySet()) {
            if (!$$16.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if ($$15.contains($$18) || !Graph.m_184556_($$5, $$15, $$16, $$17::add, $$18)) continue;
            if (p_186729_) {
                int $$20;
                ArrayList<Biome> $$19 = new ArrayList<Biome>(p_186728_);
                do {
                    $$20 = $$19.size();
                    ListIterator<Biome> $$21 = $$19.listIterator();
                    while ($$21.hasNext()) {
                        Biome $$22 = (Biome)$$21.next();
                        $$21.remove();
                        try {
                            this.m_186727_($$19, false);
                        }
                        catch (IllegalStateException $$23) {
                            continue;
                        }
                        $$21.add($$22);
                    }
                } while ($$20 != $$19.size());
                throw new IllegalStateException("Feature order cycle found, involved biomes: " + $$19);
            }
            throw new IllegalStateException("Feature order cycle found");
        }
        Collections.reverse($$17);
        ImmutableList.Builder $$24 = ImmutableList.builder();
        for (int $$25 = 0; $$25 < $$6; ++$$25) {
            int $$26 = $$25;
            List<PlacedFeature> $$27 = $$17.stream().filter(p_186720_ -> p_186720_.f_186740_() == $$26).map(FeatureData::f_186741_).collect(Collectors.toList());
            int $$28 = $$27.size();
            Object2IntOpenCustomHashMap $$29 = new Object2IntOpenCustomHashMap($$28, Util.m_137583_());
            for (int $$30 = 0; $$30 < $$28; ++$$30) {
                $$29.put((Object)((PlacedFeature)$$27.get($$30)), $$30);
            }
            $$24.add((Object)new StepFeatureData($$27, (ToIntFunction<PlacedFeature>)$$29));
        }
        return $$24.build();
    }

    protected abstract Codec<? extends BiomeSource> m_5820_();

    public abstract BiomeSource m_7206_(long var1);

    public Set<Biome> m_196676_() {
        return this.f_47891_;
    }

    public Set<Biome> m_183399_(int p_186705_, int p_186706_, int p_186707_, int p_186708_, Climate.Sampler p_186709_) {
        int $$5 = QuartPos.m_175400_(p_186705_ - p_186708_);
        int $$6 = QuartPos.m_175400_(p_186706_ - p_186708_);
        int $$7 = QuartPos.m_175400_(p_186707_ - p_186708_);
        int $$8 = QuartPos.m_175400_(p_186705_ + p_186708_);
        int $$9 = QuartPos.m_175400_(p_186706_ + p_186708_);
        int $$10 = QuartPos.m_175400_(p_186707_ + p_186708_);
        int $$11 = $$8 - $$5 + 1;
        int $$12 = $$9 - $$6 + 1;
        int $$13 = $$10 - $$7 + 1;
        HashSet $$14 = Sets.newHashSet();
        for (int $$15 = 0; $$15 < $$13; ++$$15) {
            for (int $$16 = 0; $$16 < $$11; ++$$16) {
                for (int $$17 = 0; $$17 < $$12; ++$$17) {
                    int $$18 = $$5 + $$16;
                    int $$19 = $$6 + $$17;
                    int $$20 = $$7 + $$15;
                    $$14.add(this.m_183546_($$18, $$19, $$20, p_186709_));
                }
            }
        }
        return $$14;
    }

    @Nullable
    public BlockPos m_186710_(int p_186711_, int p_186712_, int p_186713_, int p_186714_, Predicate<Biome> p_186715_, Random p_186716_, Climate.Sampler p_186717_) {
        return this.m_183287_(p_186711_, p_186712_, p_186713_, p_186714_, 1, p_186715_, p_186716_, false, p_186717_);
    }

    @Nullable
    public BlockPos m_183287_(int p_186696_, int p_186697_, int p_186698_, int p_186699_, int p_186700_, Predicate<Biome> p_186701_, Random p_186702_, boolean p_186703_, Climate.Sampler p_186704_) {
        int $$15;
        int $$9 = QuartPos.m_175400_(p_186696_);
        int $$10 = QuartPos.m_175400_(p_186698_);
        int $$11 = QuartPos.m_175400_(p_186699_);
        int $$12 = QuartPos.m_175400_(p_186697_);
        BlockPos $$13 = null;
        int $$14 = 0;
        for (int $$16 = $$15 = p_186703_ ? 0 : $$11; $$16 <= $$11; $$16 += p_186700_) {
            int $$17;
            int n = $$17 = SharedConstants.f_183698_ ? 0 : -$$16;
            while ($$17 <= $$16) {
                boolean $$18 = Math.abs($$17) == $$16;
                for (int $$19 = -$$16; $$19 <= $$16; $$19 += p_186700_) {
                    int $$22;
                    int $$21;
                    if (p_186703_) {
                        boolean $$20;
                        boolean bl = $$20 = Math.abs($$19) == $$16;
                        if (!$$20 && !$$18) continue;
                    }
                    if (!p_186701_.test(this.m_183546_($$21 = $$9 + $$19, $$12, $$22 = $$10 + $$17, p_186704_))) continue;
                    if ($$13 == null || p_186702_.nextInt($$14 + 1) == 0) {
                        $$13 = new BlockPos(QuartPos.m_175402_($$21), p_186697_, QuartPos.m_175402_($$22));
                        if (p_186703_) {
                            return $$13;
                        }
                    }
                    ++$$14;
                }
                $$17 += p_186700_;
            }
        }
        return $$13;
    }

    @Override
    public abstract Biome m_183546_(int var1, int var2, int var3, Climate.Sampler var4);

    public void m_183543_(List<String> p_186724_, BlockPos p_186725_, Climate.Sampler p_186726_) {
    }

    public List<StepFeatureData> m_186733_() {
        return this.f_186695_;
    }

    static {
        Registry.m_122961_(Registry.f_122889_, "fixed", FixedBiomeSource.f_48251_);
        Registry.m_122961_(Registry.f_122889_, "multi_noise", MultiNoiseBiomeSource.f_48425_);
        Registry.m_122961_(Registry.f_122889_, "checkerboard", CheckerboardColumnBiomeSource.f_48230_);
        Registry.m_122961_(Registry.f_122889_, "the_end", TheEndBiomeSource.f_48617_);
        f_47888_ = Registry.f_122889_.m_194605_().dispatchStable(BiomeSource::m_5820_, Function.identity());
    }

    public record StepFeatureData(List<PlacedFeature> f_196677_, ToIntFunction<PlacedFeature> f_196678_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StepFeatureData.class, "features;indexMapping", "f_196677_", "f_196678_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StepFeatureData.class, "features;indexMapping", "f_196677_", "f_196678_"}, this);
        }

        @Override
        public final boolean equals(Object p_196685_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StepFeatureData.class, "features;indexMapping", "f_196677_", "f_196678_"}, this, p_196685_);
        }
    }
}

