/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ProfiledReloadInstance;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class SimpleReloadableResourceManager
implements ReloadableResourceManager {
    private static final Logger f_10869_ = LogManager.getLogger();
    private final Map<String, FallbackResourceManager> f_10870_ = Maps.newHashMap();
    private final List<PreparableReloadListener> f_10871_ = Lists.newArrayList();
    private final Set<String> f_10873_ = Sets.newLinkedHashSet();
    private final List<PackResources> f_10874_ = Lists.newArrayList();
    private final PackType f_10875_;

    public SimpleReloadableResourceManager(PackType p_10878_) {
        this.f_10875_ = p_10878_;
    }

    public void m_10880_(PackResources p_10881_) {
        this.f_10874_.add(p_10881_);
        for (String $$1 : p_10881_.m_5698_(this.f_10875_)) {
            this.f_10873_.add($$1);
            FallbackResourceManager $$2 = this.f_10870_.get($$1);
            if ($$2 == null) {
                $$2 = new FallbackResourceManager(this.f_10875_, $$1);
                this.f_10870_.put($$1, $$2);
            }
            $$2.m_10608_(p_10881_);
        }
    }

    @Override
    public Set<String> m_7187_() {
        return this.f_10873_;
    }

    @Override
    public Resource m_142591_(ResourceLocation p_10895_) throws IOException {
        ResourceManager $$1 = this.f_10870_.get(p_10895_.m_135827_());
        if ($$1 != null) {
            return $$1.m_142591_(p_10895_);
        }
        throw new FileNotFoundException(p_10895_.toString());
    }

    @Override
    public boolean m_7165_(ResourceLocation p_10903_) {
        ResourceManager $$1 = this.f_10870_.get(p_10903_.m_135827_());
        if ($$1 != null) {
            return $$1.m_7165_(p_10903_);
        }
        return false;
    }

    @Override
    public List<Resource> m_7396_(ResourceLocation p_10906_) throws IOException {
        ResourceManager $$1 = this.f_10870_.get(p_10906_.m_135827_());
        if ($$1 != null) {
            return $$1.m_7396_(p_10906_);
        }
        throw new FileNotFoundException(p_10906_.toString());
    }

    @Override
    public Collection<ResourceLocation> m_6540_(String p_10885_, Predicate<String> p_10886_) {
        HashSet $$2 = Sets.newHashSet();
        for (FallbackResourceManager $$3 : this.f_10870_.values()) {
            $$2.addAll($$3.m_6540_(p_10885_, p_10886_));
        }
        ArrayList $$4 = Lists.newArrayList((Iterable)$$2);
        Collections.sort($$4);
        return $$4;
    }

    private void m_10904_() {
        this.f_10870_.clear();
        this.f_10873_.clear();
        this.f_10874_.forEach(PackResources::close);
        this.f_10874_.clear();
    }

    @Override
    public void close() {
        this.m_10904_();
    }

    @Override
    public void m_7217_(PreparableReloadListener p_10883_) {
        this.f_10871_.add(p_10883_);
    }

    @Override
    public ReloadInstance m_142463_(Executor p_143947_, Executor p_143948_, CompletableFuture<Unit> p_143949_, List<PackResources> p_143950_) {
        f_10869_.info("Reloading ResourceManager: {}", new Supplier[]{() -> p_143950_.stream().map(PackResources::m_8017_).collect(Collectors.joining(", "))});
        this.m_10904_();
        for (PackResources $$4 : p_143950_) {
            try {
                this.m_10880_($$4);
            }
            catch (Exception $$5) {
                f_10869_.error("Failed to add resource pack {}", (Object)$$4.m_8017_(), (Object)$$5);
                return new FailingReloadInstance(new ResourcePackLoadingFailure($$4, (Throwable)$$5));
            }
        }
        if (f_10869_.isDebugEnabled()) {
            return new ProfiledReloadInstance(this, Lists.newArrayList(this.f_10871_), p_143947_, p_143948_, p_143949_);
        }
        return SimpleReloadInstance.m_10815_(this, Lists.newArrayList(this.f_10871_), p_143947_, p_143948_, p_143949_);
    }

    @Override
    public Stream<PackResources> m_7536_() {
        return this.f_10874_.stream();
    }

    static class FailingReloadInstance
    implements ReloadInstance {
        private final ResourcePackLoadingFailure f_10908_;
        private final CompletableFuture<Unit> f_10909_;

        public FailingReloadInstance(ResourcePackLoadingFailure p_10911_) {
            this.f_10908_ = p_10911_;
            this.f_10909_ = new CompletableFuture();
            this.f_10909_.completeExceptionally(p_10911_);
        }

        @Override
        public CompletableFuture<Unit> m_7237_() {
            return this.f_10909_;
        }

        @Override
        public float m_7750_() {
            return 0.0f;
        }

        @Override
        public boolean m_7746_() {
            return true;
        }

        @Override
        public void m_7748_() {
            throw this.f_10908_;
        }
    }

    public static class ResourcePackLoadingFailure
    extends RuntimeException {
        private final PackResources f_10917_;

        public ResourcePackLoadingFailure(PackResources p_10919_, Throwable p_10920_) {
            super(p_10919_.m_8017_(), p_10920_);
            this.f_10917_ = p_10919_;
        }

        public PackResources m_10921_() {
            return this.f_10917_;
        }
    }
}

