/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.thread.ProcessorMailbox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextFilterClient
implements AutoCloseable {
    private static final Logger f_10098_ = LogManager.getLogger();
    private static final AtomicInteger f_10099_ = new AtomicInteger(1);
    private static final ThreadFactory f_10100_ = p_10148_ -> {
        Thread $$1 = new Thread(p_10148_);
        $$1.setName("Chat-Filter-Worker-" + f_10099_.getAndIncrement());
        return $$1;
    };
    private final URL f_10101_;
    final URL f_10102_;
    final URL f_10103_;
    private final String f_10104_;
    private final int f_10105_;
    private final String f_10106_;
    private final String f_200894_;
    final IgnoreStrategy f_10107_;
    final ExecutorService f_10108_;

    private TextFilterClient(URI p_200896_, String p_200897_, int p_200898_, String p_200899_, String p_200900_, IgnoreStrategy p_200901_, int p_200902_) throws MalformedURLException {
        this.f_10104_ = p_200897_;
        this.f_10105_ = p_200898_;
        this.f_10106_ = p_200899_;
        this.f_200894_ = p_200900_;
        this.f_10107_ = p_200901_;
        this.f_10101_ = p_200896_.resolve("/v1/chat").toURL();
        this.f_10102_ = p_200896_.resolve("/v1/join").toURL();
        this.f_10103_ = p_200896_.resolve("/v1/leave").toURL();
        this.f_10108_ = Executors.newFixedThreadPool(p_200902_, f_10100_);
    }

    @Nullable
    public static TextFilterClient m_143736_(String p_143737_) {
        if (Strings.isNullOrEmpty((String)p_143737_)) {
            return null;
        }
        try {
            JsonObject $$1 = GsonHelper.m_13864_(p_143737_);
            URI $$2 = new URI(GsonHelper.m_13906_($$1, "apiServer"));
            String $$3 = GsonHelper.m_13906_($$1, "apiKey");
            if ($$3.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int $$4 = GsonHelper.m_13824_($$1, "ruleId", 1);
            String $$5 = GsonHelper.m_13851_($$1, "serverId", "");
            String $$6 = GsonHelper.m_13851_($$1, "roomId", "Java:Chat");
            int $$7 = GsonHelper.m_13824_($$1, "hashesToDrop", -1);
            int $$8 = GsonHelper.m_13824_($$1, "maxConcurrentRequests", 7);
            IgnoreStrategy $$9 = IgnoreStrategy.m_143744_($$7);
            return new TextFilterClient($$2, Base64.getEncoder().encodeToString($$3.getBytes(StandardCharsets.US_ASCII)), $$4, $$5, $$6, $$9, $$8);
        }
        catch (Exception $$10) {
            f_10098_.warn("Failed to parse chat filter config {}", (Object)p_143737_, (Object)$$10);
            return null;
        }
    }

    void m_10141_(GameProfile p_10142_, URL p_10143_, Executor p_10144_) {
        JsonObject $$3 = new JsonObject();
        $$3.addProperty("server", this.f_10106_);
        $$3.addProperty("room", this.f_200894_);
        $$3.addProperty("user_id", p_10142_.getId().toString());
        $$3.addProperty("user_display_name", p_10142_.getName());
        p_10144_.execute(() -> {
            try {
                this.m_10151_($$3, p_10143_);
            }
            catch (Exception $$3) {
                f_10098_.warn("Failed to send join/leave packet to {} for player {}", (Object)p_10143_, (Object)p_10142_, (Object)$$3);
            }
        });
    }

    CompletableFuture<TextFilter.FilteredText> m_10136_(GameProfile p_10137_, String p_10138_, IgnoreStrategy p_10139_, Executor p_10140_) {
        if (p_10138_.isEmpty()) {
            return CompletableFuture.completedFuture(TextFilter.FilteredText.f_143712_);
        }
        JsonObject $$4 = new JsonObject();
        $$4.addProperty("rule", (Number)this.f_10105_);
        $$4.addProperty("server", this.f_10106_);
        $$4.addProperty("room", this.f_200894_);
        $$4.addProperty("player", p_10137_.getId().toString());
        $$4.addProperty("player_display_name", p_10137_.getName());
        $$4.addProperty("text", p_10138_);
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject $$3 = this.m_10127_($$4, this.f_10101_);
                boolean $$4 = GsonHelper.m_13855_($$3, "response", false);
                if ($$4) {
                    return TextFilter.FilteredText.m_143720_(p_10138_);
                }
                String $$5 = GsonHelper.m_13851_($$3, "hashed", null);
                if ($$5 == null) {
                    return TextFilter.FilteredText.m_143723_(p_10138_);
                }
                int $$6 = GsonHelper.m_13933_($$3, "hashes").size();
                return p_10139_.m_10171_($$5, $$6) ? TextFilter.FilteredText.m_143723_(p_10138_) : new TextFilter.FilteredText(p_10138_, $$5);
            }
            catch (Exception $$7) {
                f_10098_.warn("Failed to validate message '{}'", (Object)p_10138_, (Object)$$7);
                return TextFilter.FilteredText.m_143723_(p_10138_);
            }
        }, p_10140_);
    }

    @Override
    public void close() {
        this.f_10108_.shutdownNow();
    }

    private void m_10145_(InputStream p_10146_) throws IOException {
        byte[] $$1 = new byte[1024];
        while (p_10146_.read($$1) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject m_10127_(JsonObject p_10128_, URL p_10129_) throws IOException {
        HttpURLConnection $$2 = this.m_10156_(p_10128_, p_10129_);
        try (InputStream $$3 = $$2.getInputStream();){
            JsonObject jsonObject;
            if ($$2.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader($$3))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.m_10145_($$3);
                throw throwable;
            }
            this.m_10145_($$3);
            return jsonObject;
        }
    }

    private void m_10151_(JsonObject p_10152_, URL p_10153_) throws IOException {
        HttpURLConnection $$2 = this.m_10156_(p_10152_, p_10153_);
        try (InputStream $$3 = $$2.getInputStream();){
            this.m_10145_($$3);
        }
    }

    private HttpURLConnection m_10156_(JsonObject p_10157_, URL p_10158_) throws IOException {
        HttpURLConnection $$2 = (HttpURLConnection)p_10158_.openConnection();
        $$2.setConnectTimeout(15000);
        $$2.setReadTimeout(2000);
        $$2.setUseCaches(false);
        $$2.setDoOutput(true);
        $$2.setDoInput(true);
        $$2.setRequestMethod("POST");
        $$2.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        $$2.setRequestProperty("Accept", "application/json");
        $$2.setRequestProperty("Authorization", "Basic " + this.f_10104_);
        $$2.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.m_183709_().getName());
        try (OutputStreamWriter $$3 = new OutputStreamWriter($$2.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter $$4 = new JsonWriter((Writer)$$3);){
            Streams.write((JsonElement)p_10157_, (JsonWriter)$$4);
        }
        int $$5 = $$2.getResponseCode();
        if ($$5 < 200 || $$5 >= 300) {
            throw new RequestFailedException($$5 + " " + $$2.getResponseMessage());
        }
        return $$2;
    }

    public TextFilter m_10134_(GameProfile p_10135_) {
        return new PlayerContext(p_10135_);
    }

    @FunctionalInterface
    public static interface IgnoreStrategy {
        public static final IgnoreStrategy f_10162_ = (p_10169_, p_10170_) -> false;
        public static final IgnoreStrategy f_10163_ = (p_10166_, p_10167_) -> p_10166_.length() == p_10167_;

        public static IgnoreStrategy m_143738_(int p_143739_) {
            return (p_143742_, p_143743_) -> p_143743_ >= p_143739_;
        }

        public static IgnoreStrategy m_143744_(int p_143745_) {
            switch (p_143745_) {
                case -1: {
                    return f_10162_;
                }
                case 0: {
                    return f_10163_;
                }
            }
            return IgnoreStrategy.m_143738_(p_143745_);
        }

        public boolean m_10171_(String var1, int var2);
    }

    public static class RequestFailedException
    extends RuntimeException {
        RequestFailedException(String p_10199_) {
            super(p_10199_);
        }
    }

    class PlayerContext
    implements TextFilter {
        private final GameProfile f_10175_;
        private final Executor f_10176_;

        PlayerContext(GameProfile p_10179_) {
            this.f_10175_ = p_10179_;
            ProcessorMailbox<Runnable> $$1 = ProcessorMailbox.m_18751_(TextFilterClient.this.f_10108_, "chat stream for " + p_10179_.getName());
            this.f_10176_ = $$1::m_6937_;
        }

        @Override
        public void m_7674_() {
            TextFilterClient.this.m_10141_(this.f_10175_, TextFilterClient.this.f_10102_, this.f_10176_);
        }

        @Override
        public void m_7670_() {
            TextFilterClient.this.m_10141_(this.f_10175_, TextFilterClient.this.f_10103_, this.f_10176_);
        }

        @Override
        public CompletableFuture<List<TextFilter.FilteredText>> m_5925_(List<String> p_10190_) {
            List $$1 = (List)p_10190_.stream().map(p_10195_ -> TextFilterClient.this.m_10136_(this.f_10175_, (String)p_10195_, TextFilterClient.this.f_10107_, this.f_10176_)).collect(ImmutableList.toImmutableList());
            return Util.m_143840_($$1).exceptionally(p_143747_ -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<TextFilter.FilteredText> m_6770_(String p_10186_) {
            return TextFilterClient.this.m_10136_(this.f_10175_, p_10186_, TextFilterClient.this.f_10107_, this.f_10176_);
        }
    }
}

