/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerResources;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger f_129670_;

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.m_142977_();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$39;
            OptionSet $$17 = $$1.parse(p_129699_);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.m_127529_();
            if ($$17.has((OptionSpec)$$15)) {
                JvmProfiler.f_185340_.m_183425_(Environment.SERVER);
            }
            Bootstrap.m_135870_();
            Bootstrap.m_135889_();
            Util.m_137584_();
            RegistryAccess.RegistryHolder $$18 = RegistryAccess.m_123086_();
            Path $$19 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings $$20 = new DedicatedServerSettings($$19);
            $$20.m_139780_();
            Path $$21 = Paths.get("eula.txt", new String[0]);
            Eula $$22 = new Eula($$21);
            if ($$17.has((OptionSpec)$$3)) {
                f_129670_.info("Initialized '{}' and '{}'", (Object)$$19.toAbsolutePath(), (Object)$$21.toAbsolutePath());
                return;
            }
            if (!$$22.m_135944_()) {
                f_129670_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$23 = new File((String)$$17.valueOf((OptionSpec)$$11));
            YggdrasilAuthenticationService $$24 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService $$25 = $$24.createMinecraftSessionService();
            GameProfileRepository $$26 = $$24.createProfileRepository();
            GameProfileCache $$27 = new GameProfileCache($$26, new File($$23, MinecraftServer.f_129742_.getName()));
            String $$28 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$12)).orElse($$20.m_139777_().f_139741_);
            LevelStorageSource $$29 = LevelStorageSource.m_78242_($$23.toPath());
            LevelStorageSource.LevelStorageAccess $$30 = $$29.m_78260_($$28);
            LevelSummary $$31 = $$30.m_78308_();
            if ($$31 != null) {
                if ($$31.m_193020_()) {
                    f_129670_.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$31.m_193021_()) {
                    f_129670_.info("This world was created by an incompatible version.");
                    return;
                }
            }
            DataPackConfig $$32 = $$30.m_78309_();
            boolean $$33 = $$17.has((OptionSpec)$$8);
            if ($$33) {
                f_129670_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository $$34 = new PackRepository(PackType.SERVER_DATA, new ServerPacksSource(), new FolderRepositorySource($$30.m_78283_(LevelResource.f_78180_).toFile(), PackSource.f_10529_));
            DataPackConfig $$35 = MinecraftServer.m_129819_($$34, $$32 == null ? DataPackConfig.f_45842_ : $$32, $$33);
            CompletableFuture<ServerResources> $$36 = ServerResources.m_180005_($$34.m_10525_(), $$18, Commands.CommandSelection.DEDICATED, $$20.m_139777_().f_139711_, Util.m_183991_(), Runnable::run);
            try {
                ServerResources $$37 = $$36.get();
            }
            catch (Exception $$38) {
                f_129670_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$38);
                $$34.close();
                return;
            }
            $$39.m_136179_();
            RegistryReadOps<Tag> $$40 = RegistryReadOps.m_179866_(NbtOps.f_128958_, $$39.m_136178_(), $$18);
            $$20.m_139777_().m_180927_($$18);
            WorldData $$41 = $$30.m_78280_($$40, $$35);
            if ($$41 == null) {
                WorldGenSettings $$46;
                LevelSettings $$45;
                if ($$17.has((OptionSpec)$$4)) {
                    LevelSettings $$42 = MinecraftServer.f_129743_;
                    WorldGenSettings $$43 = WorldGenSettings.m_64645_($$18);
                } else {
                    DedicatedServerProperties $$44 = $$20.m_139777_();
                    $$45 = new LevelSettings($$44.f_139741_, $$44.f_139740_, $$44.f_139752_, $$44.f_139739_, false, new GameRules(), $$35);
                    $$46 = $$17.has((OptionSpec)$$5) ? $$44.m_180927_($$18).m_64671_() : $$44.m_180927_($$18);
                }
                $$41 = new PrimaryLevelData($$45, $$46, Lifecycle.stable());
            }
            if ($$17.has((OptionSpec)$$6)) {
                Main.m_195488_($$30, DataFixers.m_14512_(), $$17.has((OptionSpec)$$7), () -> true, $$41.m_5961_());
            }
            $$30.m_78287_($$18, $$41);
            WorldData $$47 = $$41;
            final DedicatedServer $$48 = MinecraftServer.m_129872_(arg_0 -> Main.m_129680_($$18, $$30, $$34, (ServerResources)$$39, $$47, $$20, $$25, $$26, $$27, $$17, (OptionSpec)$$10, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$49 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$48.m_7570_(true);
                }
            };
            $$49.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_129670_));
            Runtime.getRuntime().addShutdownHook($$49);
        }
        catch (Exception $$50) {
            f_129670_.fatal("Failed to start the minecraft server", (Throwable)$$50);
        }
    }

    private static void m_195488_(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, WorldGenSettings p_195493_) {
        f_129670_.info("Forcing world upgrade!");
        WorldUpgrader $$5 = new WorldUpgrader(p_195489_, p_195490_, p_195493_, p_195491_);
        Component $$6 = null;
        while (!$$5.m_18829_()) {
            int $$8;
            Component $$7 = $$5.m_18837_();
            if ($$6 != $$7) {
                $$6 = $$7;
                f_129670_.info($$5.m_18837_().getString());
            }
            if (($$8 = $$5.m_18834_()) > 0) {
                int $$9 = $$5.m_18835_() + $$5.m_18836_();
                f_129670_.info("{}% completed ({} / {} chunks)...", (Object)Mth.m_14143_((float)$$9 / (float)$$8 * 100.0f), (Object)$$9, (Object)$$8);
            }
            if (!p_195492_.getAsBoolean()) {
                $$5.m_18820_();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer m_129680_(RegistryAccess.RegistryHolder p_129681_, LevelStorageSource.LevelStorageAccess p_129682_, PackRepository p_129683_, ServerResources p_129684_, WorldData p_129685_, DedicatedServerSettings p_129686_, MinecraftSessionService p_129687_, GameProfileRepository p_129688_, GameProfileCache p_129689_, OptionSet p_129690_, OptionSpec p_129691_, OptionSpec p_129692_, OptionSpec p_129693_, OptionSpec p_129694_, OptionSpec p_129695_, OptionSpec p_129696_, Thread p_129697_) {
        boolean $$18;
        DedicatedServer $$17 = new DedicatedServer(p_129697_, p_129681_, p_129682_, p_129683_, p_129684_, p_129685_, p_129686_, DataFixers.m_14512_(), p_129687_, p_129688_, p_129689_, LoggerChunkProgressListener::new);
        $$17.m_129981_((String)p_129690_.valueOf(p_129691_));
        $$17.m_129801_((Integer)p_129690_.valueOf(p_129692_));
        $$17.m_129975_(p_129690_.has(p_129693_));
        $$17.m_129948_((String)p_129690_.valueOf(p_129694_));
        boolean bl = $$18 = !p_129690_.has(p_129695_) && !p_129690_.valuesOf(p_129696_).contains("nogui");
        if ($$18 && !GraphicsEnvironment.isHeadless()) {
            $$17.m_139667_();
        }
        return $$17;
    }

    static {
        Util.m_201353_();
        f_129670_ = LogManager.getLogger();
    }
}

