/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class RegistryReadOps<T>
extends DelegatingOps<T> {
    private final RegistryResourceAccess f_135635_;
    private final RegistryAccess f_179860_;
    private final Map<ResourceKey<? extends Registry<?>>, ReadCache<?>> f_135637_;
    private final RegistryReadOps<JsonElement> f_135638_;

    public static <T> RegistryReadOps<T> m_179866_(DynamicOps<T> p_179867_, ResourceManager p_179868_, RegistryAccess p_179869_) {
        return RegistryReadOps.m_195841_(p_179867_, RegistryResourceAccess.m_195881_(p_179868_), p_179869_);
    }

    public static <T> RegistryReadOps<T> m_195841_(DynamicOps<T> p_195842_, RegistryResourceAccess p_195843_, RegistryAccess p_195844_) {
        RegistryReadOps<T> $$3 = new RegistryReadOps<T>(p_195842_, p_195843_, p_195844_, Maps.newIdentityHashMap());
        RegistryAccess.m_175500_(p_195844_, $$3);
        return $$3;
    }

    public static <T> RegistryReadOps<T> m_179882_(DynamicOps<T> p_179883_, ResourceManager p_179884_, RegistryAccess p_179885_) {
        return RegistryReadOps.m_195867_(p_179883_, RegistryResourceAccess.m_195881_(p_179884_), p_179885_);
    }

    public static <T> RegistryReadOps<T> m_195867_(DynamicOps<T> p_195868_, RegistryResourceAccess p_195869_, RegistryAccess p_195870_) {
        return new RegistryReadOps<T>(p_195868_, p_195869_, p_195870_, Maps.newIdentityHashMap());
    }

    private RegistryReadOps(DynamicOps<T> p_195837_, RegistryResourceAccess p_195838_, RegistryAccess p_195839_, IdentityHashMap<ResourceKey<? extends Registry<?>>, ReadCache<?>> p_195840_) {
        super(p_195837_);
        this.f_135635_ = p_195838_;
        this.f_179860_ = p_195839_;
        this.f_135637_ = p_195840_;
        this.f_135638_ = p_195837_ == JsonOps.INSTANCE ? this : new RegistryReadOps<T>(JsonOps.INSTANCE, p_195838_, p_195839_, (IdentityHashMap<ResourceKey<Registry<?>>, ReadCache<?>>)p_195840_);
    }

    protected <E> DataResult<Pair<Supplier<E>, T>> m_135677_(T p_135678_, ResourceKey<? extends Registry<E>> p_135679_, Codec<E> p_135680_, boolean p_135681_) {
        Optional $$4 = this.f_179860_.m_142664_(p_135679_);
        if (!$$4.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + p_135679_));
        }
        WritableRegistry $$5 = $$4.get();
        DataResult $$6 = ResourceLocation.f_135803_.decode(this.f_135465_, p_135678_);
        if (!$$6.result().isPresent()) {
            if (!p_135681_) {
                return DataResult.error((String)"Inline definitions not allowed here");
            }
            return p_135680_.decode((DynamicOps)this, p_135678_).map(p_135647_ -> p_135647_.mapFirst(p_179881_ -> () -> p_179881_));
        }
        Pair $$7 = (Pair)$$6.result().get();
        ResourceKey $$8 = ResourceKey.m_135785_(p_135679_, (ResourceLocation)$$7.getFirst());
        return this.m_195862_(p_135679_, $$5, p_135680_, $$8).map(p_135650_ -> Pair.of((Object)p_135650_, (Object)$$7.getSecond()));
    }

    public <E> DataResult<MappedRegistry<E>> m_135662_(MappedRegistry<E> p_135663_, ResourceKey<? extends Registry<E>> p_135664_, Codec<E> p_135665_) {
        Collection $$3 = this.f_135635_.m_183590_(p_135664_);
        DataResult $$4 = DataResult.success(p_135663_, (Lifecycle)Lifecycle.stable());
        for (ResourceKey $$5 : $$3) {
            $$4 = $$4.flatMap(p_195861_ -> this.m_195862_(p_135664_, (WritableRegistry)p_195861_, p_135665_, $$5).map(p_179876_ -> p_195861_));
        }
        return $$4.setPartial(p_135663_);
    }

    private <E> DataResult<Supplier<E>> m_195862_(ResourceKey<? extends Registry<E>> p_195863_, WritableRegistry<E> p_195864_, Codec<E> p_195865_, ResourceKey<E> p_195866_) {
        DataResult $$12;
        ReadCache<E> $$4 = this.m_135699_(p_195863_);
        DataResult $$5 = $$4.f_135708_.get(p_195866_);
        if ($$5 != null) {
            return $$5;
        }
        $$4.f_135708_.put(p_195866_, DataResult.success(RegistryReadOps.m_195850_(p_195864_, p_195866_)));
        Optional<DataResult<RegistryResourceAccess.ParsedEntry<E>>> $$6 = this.f_135635_.m_183313_((DynamicOps<JsonElement>)this.f_135638_, p_195863_, p_195866_, p_195865_);
        if ($$6.isEmpty()) {
            if (p_195864_.m_142003_(p_195866_)) {
                DataResult $$7 = DataResult.success(RegistryReadOps.m_195845_(p_195864_, p_195866_), (Lifecycle)Lifecycle.stable());
            } else {
                DataResult $$8 = DataResult.error((String)("Missing referenced custom/removed registry entry for registry " + p_195863_ + " named " + p_195866_.m_135782_()));
            }
        } else {
            DataResult<RegistryResourceAccess.ParsedEntry<E>> $$9 = $$6.get();
            Optional $$10 = $$9.result();
            if ($$10.isPresent()) {
                RegistryResourceAccess.ParsedEntry $$11 = (RegistryResourceAccess.ParsedEntry)$$10.get();
                p_195864_.m_7794_($$11.f_195951_(), p_195866_, $$11.f_195950_(), $$9.lifecycle());
            }
            $$12 = $$9.map(p_195856_ -> RegistryReadOps.m_195845_(p_195864_, p_195866_));
        }
        $$4.f_135708_.put(p_195866_, $$12);
        return $$12;
    }

    private static <E> Supplier<E> m_195850_(WritableRegistry<E> p_195851_, ResourceKey<E> p_195852_) {
        return Suppliers.memoize(() -> {
            Object $$2 = p_195851_.m_6246_(p_195852_);
            if ($$2 == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + p_195852_);
            }
            return $$2;
        });
    }

    private static <E> Supplier<E> m_195845_(final Registry<E> p_195846_, final ResourceKey<E> p_195847_) {
        return new Supplier<E>(){

            @Override
            public E get() {
                return p_195846_.m_6246_(p_195847_);
            }

            public String toString() {
                return p_195847_.toString();
            }
        };
    }

    private <E> ReadCache<E> m_135699_(ResourceKey<? extends Registry<E>> p_135700_) {
        return this.f_135637_.computeIfAbsent(p_135700_, p_195877_ -> new ReadCache());
    }

    protected <E> DataResult<Registry<E>> m_135682_(ResourceKey<? extends Registry<E>> p_135683_) {
        return this.f_179860_.m_142664_(p_135683_).map(p_195849_ -> DataResult.success((Object)p_195849_, (Lifecycle)p_195849_.m_7837_())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + p_135683_)));
    }

    static final class ReadCache<E> {
        final Map<ResourceKey<E>, DataResult<Supplier<E>>> f_135708_ = Maps.newIdentityHashMap();

        ReadCache() {
        }
    }
}

