/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnbtToNbt
implements DataProvider {
    @Nullable
    private static final Path f_176815_ = null;
    private static final Logger f_126443_ = LogManager.getLogger();
    private final DataGenerator f_126444_;
    private final List<Filter> f_126445_ = Lists.newArrayList();

    public SnbtToNbt(DataGenerator p_126448_) {
        this.f_126444_ = p_126448_;
    }

    public SnbtToNbt m_126475_(Filter p_126476_) {
        this.f_126445_.add(p_126476_);
        return this;
    }

    private CompoundTag m_126460_(String p_126461_, CompoundTag p_126462_) {
        CompoundTag $$2 = p_126462_;
        for (Filter $$3 : this.f_126445_) {
            $$2 = $$3.m_6392_(p_126461_, $$2);
        }
        return $$2;
    }

    @Override
    public void m_6865_(HashCache p_126451_) throws IOException {
        Path $$1 = this.f_126444_.m_123916_();
        ArrayList $$2 = Lists.newArrayList();
        for (Path $$3 : this.f_126444_.m_123913_()) {
            Files.walk($$3, new FileVisitOption[0]).filter(p_126464_ -> p_126464_.toString().endsWith(".snbt")).forEach(p_126474_ -> $$2.add(CompletableFuture.supplyAsync(() -> this.m_126465_((Path)p_126474_, this.m_126468_($$3, (Path)p_126474_)), Util.m_183991_())));
        }
        boolean $$4 = false;
        for (CompletableFuture $$5 : $$2) {
            try {
                this.m_126456_(p_126451_, (TaskResult)$$5.get(), $$1);
            }
            catch (Exception $$6) {
                f_126443_.error("Failed to process structure", (Throwable)$$6);
                $$4 = true;
            }
        }
        if ($$4) {
            throw new IllegalStateException("Failed to convert all structures, aborting");
        }
    }

    @Override
    public String m_6055_() {
        return "SNBT -> NBT";
    }

    private String m_126468_(Path p_126469_, Path p_126470_) {
        String $$2 = p_126469_.relativize(p_126470_).toString().replaceAll("\\\\", "/");
        return $$2.substring(0, $$2.length() - ".snbt".length());
    }

    private TaskResult m_126465_(Path p_126466_, String p_126467_) {
        TaskResult taskResult;
        block10: {
            BufferedReader $$2 = Files.newBufferedReader(p_126466_);
            try {
                String $$9;
                String $$3 = IOUtils.toString((Reader)$$2);
                CompoundTag $$4 = this.m_126460_(p_126467_, NbtUtils.m_178024_($$3));
                ByteArrayOutputStream $$5 = new ByteArrayOutputStream();
                NbtIo.m_128947_($$4, $$5);
                byte[] $$6 = $$5.toByteArray();
                String $$7 = f_123918_.hashBytes($$6).toString();
                if (f_176815_ != null) {
                    String $$8 = NbtUtils.m_178063_($$4);
                } else {
                    $$9 = null;
                }
                taskResult = new TaskResult(p_126467_, $$6, $$9, $$7);
                if ($$2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if ($$2 != null) {
                        try {
                            $$2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable $$10) {
                    throw new StructureConversionException(p_126466_, $$10);
                }
            }
            $$2.close();
        }
        return taskResult;
    }

    private void m_126456_(HashCache p_126457_, TaskResult p_126458_, Path p_126459_) {
        if (p_126458_.f_126484_ != null) {
            Path $$3 = f_176815_.resolve(p_126458_.f_126482_ + ".snbt");
            try {
                NbtToSnbt.m_176812_($$3, p_126458_.f_126484_);
            }
            catch (IOException $$4) {
                f_126443_.error("Couldn't write structure SNBT {} at {}", (Object)p_126458_.f_126482_, (Object)$$3, (Object)$$4);
            }
        }
        Path $$5 = p_126459_.resolve(p_126458_.f_126482_ + ".nbt");
        try {
            if (!Objects.equals(p_126457_.m_123938_($$5), p_126458_.f_126485_) || !Files.exists($$5, new LinkOption[0])) {
                Files.createDirectories($$5.getParent(), new FileAttribute[0]);
                try (OutputStream $$6 = Files.newOutputStream($$5, new OpenOption[0]);){
                    $$6.write(p_126458_.f_126483_);
                }
            }
            p_126457_.m_123940_($$5, p_126458_.f_126485_);
        }
        catch (IOException $$7) {
            f_126443_.error("Couldn't write structure {} at {}", (Object)p_126458_.f_126482_, (Object)$$5, (Object)$$7);
        }
    }

    @FunctionalInterface
    public static interface Filter {
        public CompoundTag m_6392_(String var1, CompoundTag var2);
    }

    static class TaskResult {
        final String f_126482_;
        final byte[] f_126483_;
        @Nullable
        final String f_126484_;
        final String f_126485_;

        public TaskResult(String p_126487_, byte[] p_126488_, @Nullable String p_126489_, String p_126490_) {
            this.f_126482_ = p_126487_;
            this.f_126483_ = p_126488_;
            this.f_126484_ = p_126489_;
            this.f_126485_ = p_126490_;
        }
    }

    static class StructureConversionException
    extends RuntimeException {
        public StructureConversionException(Path p_176820_, Throwable p_176821_) {
            super(p_176820_.toAbsolutePath().toString(), p_176821_);
        }
    }
}

