/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RegistryAccess {
    static final Logger f_123047_ = LogManager.getLogger();
    static final Map<ResourceKey<? extends Registry<?>>, RegistryData<?>> f_123048_ = (Map)Util.m_137537_(() -> {
        ImmutableMap.Builder $$0 = ImmutableMap.builder();
        RegistryAccess.m_123057_($$0, Registry.f_122818_, DimensionType.f_63843_, DimensionType.f_63843_);
        RegistryAccess.m_123057_($$0, Registry.f_122885_, Biome.f_47429_, Biome.f_47430_);
        RegistryAccess.m_123053_($$0, Registry.f_122880_, ConfiguredWorldCarver.f_64846_);
        RegistryAccess.m_123053_($$0, Registry.f_122881_, ConfiguredFeature.f_65373_);
        RegistryAccess.m_123053_($$0, Registry.f_194567_, PlacedFeature.f_191772_);
        RegistryAccess.m_123053_($$0, Registry.f_122882_, ConfiguredStructureFeature.f_65400_);
        RegistryAccess.m_123053_($$0, Registry.f_122883_, StructureProcessorType.f_74467_);
        RegistryAccess.m_123053_($$0, Registry.f_122884_, StructureTemplatePool.f_69245_);
        RegistryAccess.m_123053_($$0, Registry.f_122878_, NoiseGeneratorSettings.f_64430_);
        RegistryAccess.m_123053_($$0, Registry.f_194568_, NormalNoise.NoiseParameters.f_192851_);
        return $$0.build();
    });
    private static final RegistryHolder f_123049_ = Util.m_137537_(() -> {
        RegistryHolder $$0 = new RegistryHolder();
        DimensionType.m_188315_($$0);
        f_123048_.keySet().stream().filter(p_175518_ -> !p_175518_.equals(Registry.f_122818_)).forEach(p_175511_ -> RegistryAccess.m_123078_($$0, p_175511_));
        return $$0;
    });

    public abstract <E> Optional<WritableRegistry<E>> m_142664_(ResourceKey<? extends Registry<? extends E>> var1);

    public <E> WritableRegistry<E> m_175512_(ResourceKey<? extends Registry<? extends E>> p_175513_) {
        return this.m_142664_(p_175513_).orElseThrow(() -> new IllegalStateException("Missing registry: " + p_175513_));
    }

    public <E> Optional<? extends Registry<E>> m_6632_(ResourceKey<? extends Registry<? extends E>> p_123085_) {
        Optional<WritableRegistry<E>> $$1 = this.m_142664_(p_123085_);
        if ($$1.isPresent()) {
            return $$1;
        }
        return Registry.f_122897_.m_6612_(p_123085_.m_135782_());
    }

    public <E> Registry<E> m_175515_(ResourceKey<? extends Registry<? extends E>> p_175516_) {
        return this.m_6632_(p_175516_).orElseThrow(() -> new IllegalStateException("Missing registry: " + p_175516_));
    }

    private static <E> void m_123053_(ImmutableMap.Builder<ResourceKey<? extends Registry<?>>, RegistryData<?>> p_123054_, ResourceKey<? extends Registry<E>> p_123055_, Codec<E> p_123056_) {
        p_123054_.put(p_123055_, new RegistryData<E>(p_123055_, p_123056_, null));
    }

    private static <E> void m_123057_(ImmutableMap.Builder<ResourceKey<? extends Registry<?>>, RegistryData<?>> p_123058_, ResourceKey<? extends Registry<E>> p_123059_, Codec<E> p_123060_, Codec<E> p_123061_) {
        p_123058_.put(p_123059_, new RegistryData<E>(p_123059_, p_123060_, p_123061_));
    }

    public static Iterable<RegistryData<?>> m_194613_() {
        return f_123048_.values();
    }

    public static RegistryHolder m_123086_() {
        RegistryHolder $$0 = new RegistryHolder();
        RegistryResourceAccess.InMemoryStorage $$1 = new RegistryResourceAccess.InMemoryStorage();
        for (RegistryData<?> $$2 : f_123048_.values()) {
            RegistryAccess.m_194614_($$0, $$1, $$2);
        }
        RegistryReadOps.m_195841_(JsonOps.INSTANCE, $$1, $$0);
        return $$0;
    }

    private static <E> void m_194614_(RegistryHolder p_194615_, RegistryResourceAccess.InMemoryStorage p_194616_, RegistryData<E> p_194617_) {
        ResourceKey<Registry<E>> $$3 = p_194617_.f_123101_();
        boolean $$4 = !$$3.equals(Registry.f_122878_) && !$$3.equals(Registry.f_122818_);
        Registry<E> $$5 = f_123049_.m_175515_($$3);
        WritableRegistry<E> $$6 = p_194615_.m_175512_($$3);
        for (Map.Entry<ResourceKey<E>, E> $$7 : $$5.m_6579_()) {
            ResourceKey<E> $$8 = $$7.getKey();
            E $$9 = $$7.getValue();
            if ($$4) {
                p_194616_.m_195921_(f_123049_, $$8, p_194617_.f_123102_(), $$5.m_7447_($$9), $$9, $$5.m_6228_($$9));
                continue;
            }
            $$6.m_5748_($$5.m_7447_($$9), $$8, $$9, $$5.m_6228_($$9));
        }
    }

    private static <R extends Registry<?>> void m_123078_(RegistryHolder p_123079_, ResourceKey<R> p_123080_) {
        Registry<Registry<?>> $$2 = BuiltinRegistries.f_123858_;
        Registry<?> $$3 = $$2.m_123013_(p_123080_);
        RegistryAccess.m_123068_(p_123079_, $$3);
    }

    private static <E> void m_123068_(RegistryHolder p_123069_, Registry<E> p_123070_) {
        WritableRegistry<E> $$2 = p_123069_.m_175512_(p_123070_.m_123023_());
        for (Map.Entry<ResourceKey<E>, E> $$3 : p_123070_.m_6579_()) {
            E $$4 = $$3.getValue();
            $$2.m_5748_(p_123070_.m_7447_($$4), $$3.getKey(), $$4, p_123070_.m_6228_($$4));
        }
    }

    public static void m_175500_(RegistryAccess p_175501_, RegistryReadOps<?> p_175502_) {
        for (RegistryData<?> $$2 : f_123048_.values()) {
            RegistryAccess.m_175503_(p_175502_, p_175501_, $$2);
        }
    }

    private static <E> void m_175503_(RegistryReadOps<?> p_175504_, RegistryAccess p_175505_, RegistryData<E> p_175506_) {
        ResourceKey<Registry<E>> $$3 = p_175506_.f_123101_();
        MappedRegistry $$4 = (MappedRegistry)p_175505_.m_175512_($$3);
        DataResult<MappedRegistry<E>> $$5 = p_175504_.m_135662_($$4, p_175506_.f_123101_(), p_175506_.f_123102_());
        $$5.error().ifPresent(p_175499_ -> {
            throw new JsonParseException("Error loading registry data: " + p_175499_.message());
        });
    }

    public record RegistryData<E>(ResourceKey<? extends Registry<E>> f_123101_, Codec<E> f_123102_, @Nullable Codec<E> f_123103_) {
        public boolean m_123111_() {
            return this.f_123103_ != null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "f_123101_", "f_123102_", "f_123103_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "f_123101_", "f_123102_", "f_123103_"}, this);
        }

        @Override
        public final boolean equals(Object p_194619_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryData.class, "key;codec;networkCodec", "f_123101_", "f_123102_", "f_123103_"}, this, p_194619_);
        }
    }

    public static final class RegistryHolder
    extends RegistryAccess {
        public static final Codec<RegistryHolder> f_123112_ = RegistryHolder.m_123139_();
        private final Map<? extends ResourceKey<? extends Registry<?>>, ? extends MappedRegistry<?>> f_123113_;

        private static <E> Codec<RegistryHolder> m_123139_() {
            Codec $$0 = ResourceLocation.f_135803_.xmap(ResourceKey::m_135788_, ResourceKey::m_135782_);
            Codec $$1 = $$0.partialDispatch("type", p_123134_ -> DataResult.success(p_123134_.m_123023_()), p_123145_ -> RegistryHolder.m_123137_(p_123145_).map(p_175531_ -> MappedRegistry.m_122715_(p_123145_, Lifecycle.experimental(), p_175531_)));
            UnboundedMapCodec $$2 = Codec.unboundedMap((Codec)$$0, (Codec)$$1);
            return RegistryHolder.m_123118_($$2);
        }

        private static <K extends ResourceKey<? extends Registry<?>>, V extends MappedRegistry<?>> Codec<RegistryHolder> m_123118_(UnboundedMapCodec<K, V> p_123119_) {
            return p_123119_.xmap(RegistryHolder::new, p_123136_ -> (Map)p_123136_.f_123113_.entrySet().stream().filter(p_175526_ -> f_123048_.get(p_175526_.getKey()).m_123111_()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private static <E> DataResult<? extends Codec<E>> m_123137_(ResourceKey<? extends Registry<E>> p_123138_) {
            return Optional.ofNullable(f_123048_.get(p_123138_)).map(p_123123_ -> p_123123_.f_123103_()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + p_123138_)));
        }

        public RegistryHolder() {
            this(f_123048_.keySet().stream().collect(Collectors.toMap(Function.identity(), RegistryHolder::m_123140_)));
        }

        public static RegistryAccess m_194622_(Dynamic<?> p_194623_) {
            return new RegistryHolder(f_123048_.keySet().stream().collect(Collectors.toMap(Function.identity(), p_194626_ -> RegistryHolder.m_194629_(p_194626_, p_194623_))));
        }

        private static <E> MappedRegistry<?> m_194629_(ResourceKey<? extends Registry<?>> p_194630_, Dynamic<?> p_194631_) {
            return (MappedRegistry)RegistryLookupCodec.m_135622_(p_194630_).codec().parse(p_194631_).resultOrPartial(Util.m_137489_(p_194630_ + " registry: ", arg_0 -> ((Logger)f_123047_).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get " + p_194630_ + " registry"));
        }

        private RegistryHolder(Map<? extends ResourceKey<? extends Registry<?>>, ? extends MappedRegistry<?>> p_123117_) {
            this.f_123113_ = p_123117_;
        }

        private static <E> MappedRegistry<?> m_123140_(ResourceKey<? extends Registry<?>> p_123141_) {
            return new MappedRegistry(p_123141_, Lifecycle.stable());
        }

        @Override
        public <E> Optional<WritableRegistry<E>> m_142664_(ResourceKey<? extends Registry<? extends E>> p_175528_) {
            return Optional.ofNullable(this.f_123113_.get(p_175528_)).map(p_194628_ -> p_194628_);
        }
    }
}

