/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryDataPackCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappedRegistry<T>
extends WritableRegistry<T> {
    protected static final Logger f_122670_ = LogManager.getLogger();
    private final ObjectList<T> f_122672_ = new ObjectArrayList(256);
    private final Object2IntMap<T> f_122673_ = (Object2IntMap)Util.m_137469_(new Object2IntOpenCustomHashMap(Util.m_137583_()), p_194539_ -> p_194539_.defaultReturnValue(-1));
    private final BiMap<ResourceLocation, T> f_122674_ = HashBiMap.create();
    private final BiMap<ResourceKey<T>, T> f_122675_ = HashBiMap.create();
    private final Map<T, Lifecycle> f_122676_ = Maps.newIdentityHashMap();
    private Lifecycle f_122677_;
    @Nullable
    protected Object[] f_122671_;
    private int f_122678_;

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_122681_, Lifecycle p_122682_) {
        super(p_122681_, p_122682_);
        this.f_122677_ = p_122682_;
    }

    public static <T> MapCodec<RegistryEntry<T>> m_122727_(ResourceKey<? extends Registry<T>> p_122728_, MapCodec<T> p_122729_) {
        return RecordCodecBuilder.mapCodec(p_194551_ -> p_194551_.group((App)ResourceLocation.f_135803_.xmap(ResourceKey.m_135797_(p_122728_), ResourceKey::m_135782_).fieldOf("name").forGetter(RegistryEntry::f_122766_), (App)Codec.INT.fieldOf("id").forGetter(RegistryEntry::f_122767_), (App)p_122729_.forGetter(RegistryEntry::f_122768_)).apply((Applicative)p_194551_, RegistryEntry::new));
    }

    @Override
    public <V extends T> V m_5748_(int p_122686_, ResourceKey<T> p_122687_, V p_122688_, Lifecycle p_122689_) {
        return this.m_122690_(p_122686_, p_122687_, p_122688_, p_122689_, true);
    }

    private <V extends T> V m_122690_(int p_122691_, ResourceKey<T> p_122692_, V p_122693_, Lifecycle p_122694_, boolean p_122695_) {
        Validate.notNull(p_122692_);
        Validate.notNull(p_122693_);
        this.f_122672_.size(Math.max(this.f_122672_.size(), p_122691_ + 1));
        this.f_122672_.set(p_122691_, p_122693_);
        this.f_122673_.put(p_122693_, p_122691_);
        this.f_122671_ = null;
        if (p_122695_ && this.f_122675_.containsKey(p_122692_)) {
            Util.m_143785_("Adding duplicate key '" + p_122692_ + "' to registry");
        }
        if (this.f_122674_.containsValue(p_122693_)) {
            Util.m_143785_("Adding duplicate value '" + p_122693_ + "' to registry");
        }
        this.f_122674_.put((Object)p_122692_.m_135782_(), p_122693_);
        this.f_122675_.put(p_122692_, p_122693_);
        this.f_122676_.put(p_122693_, p_122694_);
        this.f_122677_ = this.f_122677_.add(p_122694_);
        if (this.f_122678_ <= p_122691_) {
            this.f_122678_ = p_122691_ + 1;
        }
        return p_122693_;
    }

    @Override
    public <V extends T> V m_7135_(ResourceKey<T> p_122735_, V p_122736_, Lifecycle p_122737_) {
        return this.m_5748_(this.f_122678_, p_122735_, p_122736_, p_122737_);
    }

    @Override
    public <V extends T> V m_7794_(OptionalInt p_122708_, ResourceKey<T> p_122709_, V p_122710_, Lifecycle p_122711_) {
        int $$6;
        Validate.notNull(p_122709_);
        Validate.notNull(p_122710_);
        Object $$4 = this.f_122675_.get(p_122709_);
        if ($$4 == null) {
            int $$5 = p_122708_.isPresent() ? p_122708_.getAsInt() : this.f_122678_;
        } else {
            $$6 = this.f_122673_.getInt($$4);
            if (p_122708_.isPresent() && p_122708_.getAsInt() != $$6) {
                throw new IllegalStateException("ID mismatch");
            }
            this.f_122673_.removeInt($$4);
            this.f_122676_.remove($$4);
        }
        return this.m_122690_($$6, p_122709_, p_122710_, p_122711_, false);
    }

    @Override
    @Nullable
    public ResourceLocation m_7981_(T p_122746_) {
        return (ResourceLocation)this.f_122674_.inverse().get(p_122746_);
    }

    @Override
    public Optional<ResourceKey<T>> m_7854_(T p_122755_) {
        return Optional.ofNullable((ResourceKey)this.f_122675_.inverse().get(p_122755_));
    }

    @Override
    public int m_7447_(@Nullable T p_122706_) {
        return this.f_122673_.getInt(p_122706_);
    }

    @Override
    @Nullable
    public T m_6246_(@Nullable ResourceKey<T> p_122714_) {
        return (T)this.f_122675_.get(p_122714_);
    }

    @Override
    @Nullable
    public T m_7942_(int p_122684_) {
        if (p_122684_ < 0 || p_122684_ >= this.f_122672_.size()) {
            return null;
        }
        return (T)this.f_122672_.get(p_122684_);
    }

    @Override
    public int m_183450_() {
        return this.f_122674_.size();
    }

    @Override
    public Lifecycle m_6228_(T p_122764_) {
        return this.f_122676_.get(p_122764_);
    }

    @Override
    public Lifecycle m_7837_() {
        return this.f_122677_;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.f_122672_.iterator(), Objects::nonNull);
    }

    @Override
    @Nullable
    public T m_7745_(@Nullable ResourceLocation p_122739_) {
        return (T)this.f_122674_.get((Object)p_122739_);
    }

    @Override
    public Set<ResourceLocation> m_6566_() {
        return Collections.unmodifiableSet(this.f_122674_.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
        return Collections.unmodifiableMap(this.f_122675_).entrySet();
    }

    @Override
    public boolean m_142427_() {
        return this.f_122674_.isEmpty();
    }

    @Override
    @Nullable
    public T m_142697_(Random p_122712_) {
        if (this.f_122671_ == null) {
            Set $$1 = this.f_122674_.values();
            if ($$1.isEmpty()) {
                return null;
            }
            this.f_122671_ = $$1.toArray(Object[]::new);
        }
        return (T)Util.m_137545_(this.f_122671_, p_122712_);
    }

    @Override
    public boolean m_7804_(ResourceLocation p_122761_) {
        return this.f_122674_.containsKey((Object)p_122761_);
    }

    @Override
    public boolean m_142003_(ResourceKey<T> p_175392_) {
        return this.f_122675_.containsKey(p_175392_);
    }

    public static <T> Codec<MappedRegistry<T>> m_122715_(ResourceKey<? extends Registry<T>> p_122716_, Lifecycle p_122717_, Codec<T> p_122718_) {
        return MappedRegistry.m_122727_(p_122716_, p_122718_.fieldOf("element")).codec().listOf().xmap(p_194543_ -> {
            MappedRegistry $$3 = new MappedRegistry(p_122716_, p_122717_);
            for (RegistryEntry $$4 : p_194543_) {
                $$3.m_5748_($$4.f_122767_(), $$4.f_122766_(), $$4.f_122768_(), p_122717_);
            }
            return $$3;
        }, p_194556_ -> {
            ImmutableList.Builder $$1 = ImmutableList.builder();
            for (Object $$2 : p_194556_) {
                $$1.add(new RegistryEntry(p_194556_.m_7854_($$2).get(), p_194556_.m_7447_($$2), $$2));
            }
            return $$1.build();
        });
    }

    public static <T> Codec<MappedRegistry<T>> m_122747_(ResourceKey<? extends Registry<T>> p_122748_, Lifecycle p_122749_, Codec<T> p_122750_) {
        return RegistryDataPackCodec.m_135558_(p_122748_, p_122749_, p_122750_);
    }

    public static <T> Codec<MappedRegistry<T>> m_122756_(ResourceKey<? extends Registry<T>> p_122757_, Lifecycle p_122758_, Codec<T> p_122759_) {
        return Codec.unboundedMap((Codec)ResourceLocation.f_135803_.xmap(ResourceKey.m_135797_(p_122757_), ResourceKey::m_135782_), p_122759_).xmap(p_194547_ -> {
            MappedRegistry $$3 = new MappedRegistry(p_122757_, p_122758_);
            p_194547_.forEach((? super K p_194536_, ? super V p_194537_) -> $$3.m_7135_((ResourceKey)p_194536_, (Object)p_194537_, p_122758_));
            return $$3;
        }, p_194532_ -> ImmutableMap.copyOf(p_194532_.f_122675_));
    }

    record RegistryEntry<T>(ResourceKey<T> f_122766_, int f_122767_, T f_122768_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryEntry.class, "key;id;value", "f_122766_", "f_122767_", "f_122768_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryEntry.class, "key;id;value", "f_122766_", "f_122767_", "f_122768_"}, this);
        }

        @Override
        public final boolean equals(Object p_194561_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryEntry.class, "key;id;value", "f_122766_", "f_122767_", "f_122768_"}, this, p_194561_);
        }
    }
}

