/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateParser {
    public static final SimpleCommandExceptionType f_116741_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType f_116742_ = new DynamicCommandExceptionType(p_116790_ -> new TranslatableComponent("argument.block.id.invalid", p_116790_));
    public static final Dynamic2CommandExceptionType f_116743_ = new Dynamic2CommandExceptionType((p_116820_, p_116821_) -> new TranslatableComponent("argument.block.property.unknown", p_116820_, p_116821_));
    public static final Dynamic2CommandExceptionType f_116744_ = new Dynamic2CommandExceptionType((p_116813_, p_116814_) -> new TranslatableComponent("argument.block.property.duplicate", p_116814_, p_116813_));
    public static final Dynamic3CommandExceptionType f_116745_ = new Dynamic3CommandExceptionType((p_116795_, p_116796_, p_116797_) -> new TranslatableComponent("argument.block.property.invalid", p_116795_, p_116797_, p_116796_));
    public static final Dynamic2CommandExceptionType f_116746_ = new Dynamic2CommandExceptionType((p_116792_, p_116793_) -> new TranslatableComponent("argument.block.property.novalue", p_116792_, p_116793_));
    public static final SimpleCommandExceptionType f_116747_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.block.property.unclosed"));
    private static final char f_174101_ = '[';
    private static final char f_174102_ = '{';
    private static final char f_174103_ = ']';
    private static final char f_174104_ = '=';
    private static final char f_174105_ = ',';
    private static final char f_174106_ = '#';
    private static final BiFunction<SuggestionsBuilder, TagCollection<Block>, CompletableFuture<Suggestions>> f_116748_ = (p_116857_, p_116858_) -> p_116857_.buildFuture();
    private final StringReader f_116749_;
    private final boolean f_116750_;
    private final Map<Property<?>, Comparable<?>> f_116751_ = Maps.newHashMap();
    private final Map<String, String> f_116752_ = Maps.newHashMap();
    private ResourceLocation f_116753_ = new ResourceLocation("");
    private StateDefinition<Block, BlockState> f_116754_;
    private BlockState f_116755_;
    @Nullable
    private CompoundTag f_116756_;
    private ResourceLocation f_116757_ = new ResourceLocation("");
    private int f_116758_;
    private BiFunction<SuggestionsBuilder, TagCollection<Block>, CompletableFuture<Suggestions>> f_116759_ = f_116748_;

    public BlockStateParser(StringReader p_116762_, boolean p_116763_) {
        this.f_116749_ = p_116762_;
        this.f_116750_ = p_116763_;
    }

    public Map<Property<?>, Comparable<?>> m_116764_() {
        return this.f_116751_;
    }

    @Nullable
    public BlockState m_116808_() {
        return this.f_116755_;
    }

    @Nullable
    public CompoundTag m_116815_() {
        return this.f_116756_;
    }

    @Nullable
    public ResourceLocation m_116822_() {
        return this.f_116757_;
    }

    public BlockStateParser m_116806_(boolean p_116807_) throws CommandSyntaxException {
        this.f_116759_ = this::m_116853_;
        if (this.f_116749_.canRead() && this.f_116749_.peek() == '#') {
            this.m_116830_();
            this.f_116759_ = this::m_116843_;
            if (this.f_116749_.canRead() && this.f_116749_.peek() == '[') {
                this.m_116838_();
                this.f_116759_ = this::m_116831_;
            }
        } else {
            this.m_116826_();
            this.f_116759_ = this::m_116847_;
            if (this.f_116749_.canRead() && this.f_116749_.peek() == '[') {
                this.m_116834_();
                this.f_116759_ = this::m_116831_;
            }
        }
        if (p_116807_ && this.f_116749_.canRead() && this.f_116749_.peek() == '{') {
            this.f_116759_ = f_116748_;
            this.m_116842_();
        }
        return this;
    }

    private CompletableFuture<Suggestions> m_116809_(SuggestionsBuilder p_116810_, TagCollection<Block> p_116811_) {
        if (p_116810_.getRemaining().isEmpty()) {
            p_116810_.suggest(String.valueOf(']'));
        }
        return this.m_116823_(p_116810_, p_116811_);
    }

    private CompletableFuture<Suggestions> m_116816_(SuggestionsBuilder p_116817_, TagCollection<Block> p_116818_) {
        if (p_116817_.getRemaining().isEmpty()) {
            p_116817_.suggest(String.valueOf(']'));
        }
        return this.m_116827_(p_116817_, p_116818_);
    }

    private CompletableFuture<Suggestions> m_116823_(SuggestionsBuilder p_116824_, TagCollection<Block> p_116825_) {
        String $$2 = p_116824_.getRemaining().toLowerCase(Locale.ROOT);
        for (Property<?> $$3 : this.f_116755_.m_61147_()) {
            if (this.f_116751_.containsKey($$3) || !$$3.m_61708_().startsWith($$2)) continue;
            p_116824_.suggest($$3.m_61708_() + "=");
        }
        return p_116824_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_116827_(SuggestionsBuilder p_116828_, TagCollection<Block> p_116829_) {
        Tag<Block> $$3;
        String $$2 = p_116828_.getRemaining().toLowerCase(Locale.ROOT);
        if (this.f_116757_ != null && !this.f_116757_.m_135815_().isEmpty() && ($$3 = p_116829_.m_13404_(this.f_116757_)) != null) {
            for (Block $$4 : $$3.m_6497_()) {
                for (Property<?> $$5 : $$4.m_49965_().m_61092_()) {
                    if (this.f_116752_.containsKey($$5.m_61708_()) || !$$5.m_61708_().startsWith($$2)) continue;
                    p_116828_.suggest($$5.m_61708_() + "=");
                }
            }
        }
        return p_116828_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_116831_(SuggestionsBuilder p_116832_, TagCollection<Block> p_116833_) {
        if (p_116832_.getRemaining().isEmpty() && this.m_116767_(p_116833_)) {
            p_116832_.suggest(String.valueOf('{'));
        }
        return p_116832_.buildFuture();
    }

    private boolean m_116767_(TagCollection<Block> p_116768_) {
        Tag<Block> $$1;
        if (this.f_116755_ != null) {
            return this.f_116755_.m_155947_();
        }
        if (this.f_116757_ != null && ($$1 = p_116768_.m_13404_(this.f_116757_)) != null) {
            for (Block $$2 : $$1.m_6497_()) {
                if (!$$2.m_49966_().m_155947_()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> m_116835_(SuggestionsBuilder p_116836_, TagCollection<Block> p_116837_) {
        if (p_116836_.getRemaining().isEmpty()) {
            p_116836_.suggest(String.valueOf('='));
        }
        return p_116836_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_116839_(SuggestionsBuilder p_116840_, TagCollection<Block> p_116841_) {
        if (p_116840_.getRemaining().isEmpty()) {
            p_116840_.suggest(String.valueOf(']'));
        }
        if (p_116840_.getRemaining().isEmpty() && this.f_116751_.size() < this.f_116755_.m_61147_().size()) {
            p_116840_.suggest(String.valueOf(','));
        }
        return p_116840_.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder m_116786_(SuggestionsBuilder p_116787_, Property<T> p_116788_) {
        for (Comparable $$2 : p_116788_.m_6908_()) {
            if ($$2 instanceof Integer) {
                p_116787_.suggest(((Integer)$$2).intValue());
                continue;
            }
            p_116787_.suggest(p_116788_.m_6940_($$2));
        }
        return p_116787_;
    }

    private CompletableFuture<Suggestions> m_116782_(SuggestionsBuilder p_116783_, TagCollection<Block> p_116784_, String p_116785_) {
        Tag<Block> $$4;
        boolean $$3 = false;
        if (this.f_116757_ != null && !this.f_116757_.m_135815_().isEmpty() && ($$4 = p_116784_.m_13404_(this.f_116757_)) != null) {
            block0: for (Block $$5 : $$4.m_6497_()) {
                Property<?> $$6 = $$5.m_49965_().m_61081_(p_116785_);
                if ($$6 != null) {
                    BlockStateParser.m_116786_(p_116783_, $$6);
                }
                if ($$3) continue;
                for (Property<?> $$7 : $$5.m_49965_().m_61092_()) {
                    if (this.f_116752_.containsKey($$7.m_61708_())) continue;
                    $$3 = true;
                    continue block0;
                }
            }
        }
        if ($$3) {
            p_116783_.suggest(String.valueOf(','));
        }
        p_116783_.suggest(String.valueOf(']'));
        return p_116783_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_116843_(SuggestionsBuilder p_116844_, TagCollection<Block> p_116845_) {
        Tag<Block> $$2;
        if (p_116844_.getRemaining().isEmpty() && ($$2 = p_116845_.m_13404_(this.f_116757_)) != null) {
            Block $$5;
            boolean $$3 = false;
            boolean $$4 = false;
            Iterator<Block> iterator = $$2.m_6497_().iterator();
            while (!(!iterator.hasNext() || ($$3 |= !($$5 = iterator.next()).m_49965_().m_61092_().isEmpty()) && ($$4 |= $$5.m_49966_().m_155947_()))) {
            }
            if ($$3) {
                p_116844_.suggest(String.valueOf('['));
            }
            if ($$4) {
                p_116844_.suggest(String.valueOf('{'));
            }
        }
        return this.m_116850_(p_116844_, p_116845_);
    }

    private CompletableFuture<Suggestions> m_116847_(SuggestionsBuilder p_116848_, TagCollection<Block> p_116849_) {
        if (p_116848_.getRemaining().isEmpty()) {
            if (!this.f_116755_.m_60734_().m_49965_().m_61092_().isEmpty()) {
                p_116848_.suggest(String.valueOf('['));
            }
            if (this.f_116755_.m_155947_()) {
                p_116848_.suggest(String.valueOf('{'));
            }
        }
        return p_116848_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_116850_(SuggestionsBuilder p_116851_, TagCollection<Block> p_116852_) {
        return SharedSuggestionProvider.m_82926_(p_116852_.m_13406_(), p_116851_.createOffset(this.f_116758_).add(p_116851_));
    }

    private CompletableFuture<Suggestions> m_116853_(SuggestionsBuilder p_116854_, TagCollection<Block> p_116855_) {
        if (this.f_116750_) {
            SharedSuggestionProvider.m_82929_(p_116855_.m_13406_(), p_116854_, String.valueOf('#'));
        }
        SharedSuggestionProvider.m_82926_(Registry.f_122824_.m_6566_(), p_116854_);
        return p_116854_.buildFuture();
    }

    public void m_116826_() throws CommandSyntaxException {
        int $$0 = this.f_116749_.getCursor();
        this.f_116753_ = ResourceLocation.m_135818_(this.f_116749_);
        Block $$1 = Registry.f_122824_.m_6612_(this.f_116753_).orElseThrow(() -> {
            this.f_116749_.setCursor($$0);
            return f_116742_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString());
        });
        this.f_116754_ = $$1.m_49965_();
        this.f_116755_ = $$1.m_49966_();
    }

    public void m_116830_() throws CommandSyntaxException {
        if (!this.f_116750_) {
            throw f_116741_.create();
        }
        this.f_116759_ = this::m_116850_;
        this.f_116749_.expect('#');
        this.f_116758_ = this.f_116749_.getCursor();
        this.f_116757_ = ResourceLocation.m_135818_(this.f_116749_);
    }

    public void m_116834_() throws CommandSyntaxException {
        this.f_116749_.skip();
        this.f_116759_ = this::m_116809_;
        this.f_116749_.skipWhitespace();
        while (this.f_116749_.canRead() && this.f_116749_.peek() != ']') {
            this.f_116749_.skipWhitespace();
            int $$0 = this.f_116749_.getCursor();
            String $$1 = this.f_116749_.readString();
            Property<?> $$2 = this.f_116754_.m_61081_($$1);
            if ($$2 == null) {
                this.f_116749_.setCursor($$0);
                throw f_116743_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)$$1);
            }
            if (this.f_116751_.containsKey($$2)) {
                this.f_116749_.setCursor($$0);
                throw f_116744_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)$$1);
            }
            this.f_116749_.skipWhitespace();
            this.f_116759_ = this::m_116835_;
            if (!this.f_116749_.canRead() || this.f_116749_.peek() != '=') {
                throw f_116746_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)$$1);
            }
            this.f_116749_.skip();
            this.f_116749_.skipWhitespace();
            this.f_116759_ = (p_116773_, p_116774_) -> BlockStateParser.m_116786_(p_116773_, $$2).buildFuture();
            int $$3 = this.f_116749_.getCursor();
            this.m_116775_($$2, this.f_116749_.readString(), $$3);
            this.f_116759_ = this::m_116839_;
            this.f_116749_.skipWhitespace();
            if (!this.f_116749_.canRead()) continue;
            if (this.f_116749_.peek() == ',') {
                this.f_116749_.skip();
                this.f_116759_ = this::m_116823_;
                continue;
            }
            if (this.f_116749_.peek() == ']') break;
            throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
        }
        if (!this.f_116749_.canRead()) {
            throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
        }
        this.f_116749_.skip();
    }

    public void m_116838_() throws CommandSyntaxException {
        this.f_116749_.skip();
        this.f_116759_ = this::m_116816_;
        int $$0 = -1;
        this.f_116749_.skipWhitespace();
        while (this.f_116749_.canRead() && this.f_116749_.peek() != ']') {
            this.f_116749_.skipWhitespace();
            int $$1 = this.f_116749_.getCursor();
            String $$2 = this.f_116749_.readString();
            if (this.f_116752_.containsKey($$2)) {
                this.f_116749_.setCursor($$1);
                throw f_116744_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)$$2);
            }
            this.f_116749_.skipWhitespace();
            if (!this.f_116749_.canRead() || this.f_116749_.peek() != '=') {
                this.f_116749_.setCursor($$1);
                throw f_116746_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)$$2);
            }
            this.f_116749_.skip();
            this.f_116749_.skipWhitespace();
            this.f_116759_ = (p_116800_, p_116801_) -> this.m_116782_((SuggestionsBuilder)p_116800_, (TagCollection<Block>)p_116801_, $$2);
            $$0 = this.f_116749_.getCursor();
            String $$3 = this.f_116749_.readString();
            this.f_116752_.put($$2, $$3);
            this.f_116749_.skipWhitespace();
            if (!this.f_116749_.canRead()) continue;
            $$0 = -1;
            if (this.f_116749_.peek() == ',') {
                this.f_116749_.skip();
                this.f_116759_ = this::m_116827_;
                continue;
            }
            if (this.f_116749_.peek() == ']') break;
            throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
        }
        if (!this.f_116749_.canRead()) {
            if ($$0 >= 0) {
                this.f_116749_.setCursor($$0);
            }
            throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
        }
        this.f_116749_.skip();
    }

    public void m_116842_() throws CommandSyntaxException {
        this.f_116756_ = new TagParser(this.f_116749_).m_129373_();
    }

    private <T extends Comparable<T>> void m_116775_(Property<T> p_116776_, String p_116777_, int p_116778_) throws CommandSyntaxException {
        Optional<T> $$3 = p_116776_.m_6215_(p_116777_);
        if (!$$3.isPresent()) {
            this.f_116749_.setCursor(p_116778_);
            throw f_116745_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)p_116776_.m_61708_(), (Object)p_116777_);
        }
        this.f_116755_ = (BlockState)this.f_116755_.m_61124_(p_116776_, (Comparable)$$3.get());
        this.f_116751_.put(p_116776_, (Comparable)$$3.get());
    }

    public static String m_116769_(BlockState p_116770_) {
        StringBuilder $$1 = new StringBuilder(Registry.f_122824_.m_7981_(p_116770_.m_60734_()).toString());
        if (!p_116770_.m_61147_().isEmpty()) {
            $$1.append('[');
            boolean $$2 = false;
            for (Map.Entry $$3 : p_116770_.m_61148_().entrySet()) {
                if ($$2) {
                    $$1.append(',');
                }
                BlockStateParser.m_116802_($$1, (Property)$$3.getKey(), (Comparable)$$3.getValue());
                $$2 = true;
            }
            $$1.append(']');
        }
        return $$1.toString();
    }

    private static <T extends Comparable<T>> void m_116802_(StringBuilder p_116803_, Property<T> p_116804_, Comparable<?> p_116805_) {
        p_116803_.append(p_116804_.m_61708_());
        p_116803_.append('=');
        p_116803_.append(p_116804_.m_6940_(p_116805_));
    }

    public CompletableFuture<Suggestions> m_116779_(SuggestionsBuilder p_116780_, TagCollection<Block> p_116781_) {
        return this.f_116759_.apply(p_116780_.createOffset(this.f_116749_.getCursor()), p_116781_);
    }

    public Map<String, String> m_116846_() {
        return this.f_116752_;
    }
}

