/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlayerPredicate {
    public static final PlayerPredicate f_62244_ = new Builder().m_62313_();
    public static final int f_156743_ = 100;
    private final MinMaxBounds.Ints f_62245_;
    @Nullable
    private final GameType f_62246_;
    private final Map<Stat<?>, MinMaxBounds.Ints> f_62247_;
    private final Object2BooleanMap<ResourceLocation> f_62248_;
    private final Map<ResourceLocation, AdvancementPredicate> f_62249_;
    private final EntityPredicate f_156744_;

    private static AdvancementPredicate m_62289_(JsonElement p_62290_) {
        if (p_62290_.isJsonPrimitive()) {
            boolean $$1 = p_62290_.getAsBoolean();
            return new AdvancementDonePredicate($$1);
        }
        Object2BooleanOpenHashMap $$2 = new Object2BooleanOpenHashMap();
        JsonObject $$3 = GsonHelper.m_13918_(p_62290_, "criterion data");
        $$3.entrySet().forEach(arg_0 -> PlayerPredicate.m_62286_((Object2BooleanMap)$$2, arg_0));
        return new AdvancementCriterionsPredicate((Object2BooleanMap<String>)$$2);
    }

    PlayerPredicate(MinMaxBounds.Ints p_156746_, @Nullable GameType p_156747_, Map<Stat<?>, MinMaxBounds.Ints> p_156748_, Object2BooleanMap<ResourceLocation> p_156749_, Map<ResourceLocation, AdvancementPredicate> p_156750_, EntityPredicate p_156751_) {
        this.f_62245_ = p_156746_;
        this.f_62246_ = p_156747_;
        this.f_62247_ = p_156748_;
        this.f_62248_ = p_156749_;
        this.f_62249_ = p_156750_;
        this.f_156744_ = p_156751_;
    }

    public boolean m_62270_(Entity p_62271_) {
        if (this == f_62244_) {
            return true;
        }
        if (!(p_62271_ instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer $$1 = (ServerPlayer)p_62271_;
        if (!this.f_62245_.m_55390_($$1.f_36078_)) {
            return false;
        }
        if (this.f_62246_ != null && this.f_62246_ != $$1.f_8941_.m_9290_()) {
            return false;
        }
        ServerStatsCounter $$2 = $$1.m_8951_();
        for (Map.Entry<Stat<?>, MinMaxBounds.Ints> entry : this.f_62247_.entrySet()) {
            int $$4 = $$2.m_13015_(entry.getKey());
            if (entry.getValue().m_55390_($$4)) continue;
            return false;
        }
        ServerRecipeBook $$5 = $$1.m_8952_();
        for (Object2BooleanMap.Entry $$6 : this.f_62248_.object2BooleanEntrySet()) {
            if ($$5.m_12711_((ResourceLocation)$$6.getKey()) == $$6.getBooleanValue()) continue;
            return false;
        }
        if (!this.f_62249_.isEmpty()) {
            PlayerAdvancements playerAdvancements = $$1.m_8960_();
            ServerAdvancementManager $$8 = $$1.m_20194_().m_129889_();
            for (Map.Entry<ResourceLocation, AdvancementPredicate> $$9 : this.f_62249_.entrySet()) {
                Advancement $$10 = $$8.m_136041_($$9.getKey());
                if ($$10 != null && $$9.getValue().test(playerAdvancements.m_135996_($$10))) continue;
                return false;
            }
        }
        if (this.f_156744_ != EntityPredicate.f_36550_) {
            Vec3 vec3 = $$1.m_146892_();
            Vec3 $$12 = $$1.m_20252_(1.0f);
            Vec3 $$13 = vec3.m_82520_($$12.f_82479_ * 100.0, $$12.f_82480_ * 100.0, $$12.f_82481_ * 100.0);
            EntityHitResult $$14 = ProjectileUtil.m_150175_($$1.f_19853_, $$1, vec3, $$13, new AABB(vec3, $$13).m_82400_(1.0), p_156765_ -> !p_156765_.m_5833_(), 0.0f);
            if ($$14 == null || $$14.m_6662_() != HitResult.Type.ENTITY) {
                return false;
            }
            Entity $$15 = $$14.m_82443_();
            if (!this.f_156744_.m_36611_($$1, $$15) || !$$1.m_142582_($$15)) {
                return false;
            }
        }
        return true;
    }

    public static PlayerPredicate m_62276_(@Nullable JsonElement p_62277_) {
        if (p_62277_ == null || p_62277_.isJsonNull()) {
            return f_62244_;
        }
        JsonObject $$1 = GsonHelper.m_13918_(p_62277_, "player");
        MinMaxBounds.Ints $$2 = MinMaxBounds.Ints.m_55373_($$1.get("level"));
        String $$3 = GsonHelper.m_13851_($$1, "gamemode", "");
        GameType $$4 = GameType.m_46402_($$3, null);
        HashMap $$5 = Maps.newHashMap();
        JsonArray $$6 = GsonHelper.m_13832_($$1, "stats", null);
        if ($$6 != null) {
            for (JsonElement $$7 : $$6) {
                JsonObject $$8 = GsonHelper.m_13918_($$7, "stats entry");
                ResourceLocation $$9 = new ResourceLocation(GsonHelper.m_13906_($$8, "type"));
                StatType<?> $$10 = Registry.f_122867_.m_7745_($$9);
                if ($$10 == null) {
                    throw new JsonParseException("Invalid stat type: " + $$9);
                }
                ResourceLocation $$11 = new ResourceLocation(GsonHelper.m_13906_($$8, "stat"));
                Stat<?> $$12 = PlayerPredicate.m_62267_($$10, $$11);
                MinMaxBounds.Ints $$13 = MinMaxBounds.Ints.m_55373_($$8.get("value"));
                $$5.put($$12, $$13);
            }
        }
        Object2BooleanOpenHashMap $$14 = new Object2BooleanOpenHashMap();
        JsonObject $$15 = GsonHelper.m_13841_($$1, "recipes", new JsonObject());
        for (Map.Entry $$16 : $$15.entrySet()) {
            ResourceLocation $$17 = new ResourceLocation((String)$$16.getKey());
            boolean $$18 = GsonHelper.m_13877_((JsonElement)$$16.getValue(), "recipe present");
            $$14.put((Object)$$17, $$18);
        }
        HashMap $$19 = Maps.newHashMap();
        JsonObject $$20 = GsonHelper.m_13841_($$1, "advancements", new JsonObject());
        for (Map.Entry $$21 : $$20.entrySet()) {
            ResourceLocation $$22 = new ResourceLocation((String)$$21.getKey());
            AdvancementPredicate $$23 = PlayerPredicate.m_62289_((JsonElement)$$21.getValue());
            $$19.put($$22, $$23);
        }
        EntityPredicate $$24 = EntityPredicate.m_36614_($$1.get("looking_at"));
        return new PlayerPredicate($$2, $$4, $$5, (Object2BooleanMap<ResourceLocation>)$$14, $$19, $$24);
    }

    private static <T> Stat<T> m_62267_(StatType<T> p_62268_, ResourceLocation p_62269_) {
        Registry<T> $$2 = p_62268_.m_12893_();
        T $$3 = $$2.m_7745_(p_62269_);
        if ($$3 == null) {
            throw new JsonParseException("Unknown object " + p_62269_ + " for stat type " + Registry.f_122867_.m_7981_(p_62268_));
        }
        return p_62268_.m_12902_($$3);
    }

    private static <T> ResourceLocation m_62265_(Stat<T> p_62266_) {
        return p_62266_.m_12859_().m_12893_().m_7981_(p_62266_.m_12867_());
    }

    public JsonElement m_62264_() {
        if (this == f_62244_) {
            return JsonNull.INSTANCE;
        }
        JsonObject $$0 = new JsonObject();
        $$0.add("level", this.f_62245_.m_55328_());
        if (this.f_62246_ != null) {
            $$0.addProperty("gamemode", this.f_62246_.m_46405_());
        }
        if (!this.f_62247_.isEmpty()) {
            JsonArray $$1 = new JsonArray();
            this.f_62247_.forEach((p_156754_, p_156755_) -> {
                JsonObject $$3 = new JsonObject();
                $$3.addProperty("type", Registry.f_122867_.m_7981_(p_156754_.m_12859_()).toString());
                $$3.addProperty("stat", PlayerPredicate.m_62265_(p_156754_).toString());
                $$3.add("value", p_156755_.m_55328_());
                $$1.add((JsonElement)$$3);
            });
            $$0.add("stats", (JsonElement)$$1);
        }
        if (!this.f_62248_.isEmpty()) {
            JsonObject $$2 = new JsonObject();
            this.f_62248_.forEach((p_156762_, p_156763_) -> $$2.addProperty(p_156762_.toString(), p_156763_));
            $$0.add("recipes", (JsonElement)$$2);
        }
        if (!this.f_62249_.isEmpty()) {
            JsonObject $$3 = new JsonObject();
            this.f_62249_.forEach((p_156758_, p_156759_) -> $$3.add(p_156758_.toString(), p_156759_.m_7943_()));
            $$0.add("advancements", (JsonElement)$$3);
        }
        $$0.add("looking_at", this.f_156744_.m_36606_());
        return $$0;
    }

    private static /* synthetic */ void m_62286_(Object2BooleanMap p_62287_, Map.Entry p_62288_) {
        boolean $$2 = GsonHelper.m_13877_((JsonElement)p_62288_.getValue(), "criterion test");
        p_62287_.put((Object)((String)p_62288_.getKey()), $$2);
    }

    static class AdvancementDonePredicate
    implements AdvancementPredicate {
        private final boolean f_62299_;

        public AdvancementDonePredicate(boolean p_62301_) {
            this.f_62299_ = p_62301_;
        }

        @Override
        public JsonElement m_7943_() {
            return new JsonPrimitive(Boolean.valueOf(this.f_62299_));
        }

        @Override
        public boolean test(AdvancementProgress p_62304_) {
            return p_62304_.m_8193_() == this.f_62299_;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static class AdvancementCriterionsPredicate
    implements AdvancementPredicate {
        private final Object2BooleanMap<String> f_62291_;

        public AdvancementCriterionsPredicate(Object2BooleanMap<String> p_62293_) {
            this.f_62291_ = p_62293_;
        }

        @Override
        public JsonElement m_7943_() {
            JsonObject $$0 = new JsonObject();
            this.f_62291_.forEach((arg_0, arg_1) -> ((JsonObject)$$0).addProperty(arg_0, arg_1));
            return $$0;
        }

        @Override
        public boolean test(AdvancementProgress p_62296_) {
            for (Object2BooleanMap.Entry $$1 : this.f_62291_.object2BooleanEntrySet()) {
                CriterionProgress $$2 = p_62296_.m_8214_((String)$$1.getKey());
                if ($$2 != null && $$2.m_12911_() == $$1.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static interface AdvancementPredicate
    extends Predicate<AdvancementProgress> {
        public JsonElement m_7943_();
    }

    public static class Builder {
        private MinMaxBounds.Ints f_62307_ = MinMaxBounds.Ints.f_55364_;
        @Nullable
        private GameType f_62308_;
        private final Map<Stat<?>, MinMaxBounds.Ints> f_62309_ = Maps.newHashMap();
        private final Object2BooleanMap<ResourceLocation> f_62310_ = new Object2BooleanOpenHashMap();
        private final Map<ResourceLocation, AdvancementPredicate> f_62311_ = Maps.newHashMap();
        private EntityPredicate f_156766_ = EntityPredicate.f_36550_;

        public static Builder m_156767_() {
            return new Builder();
        }

        public Builder m_156775_(MinMaxBounds.Ints p_156776_) {
            this.f_62307_ = p_156776_;
            return this;
        }

        public Builder m_156768_(Stat<?> p_156769_, MinMaxBounds.Ints p_156770_) {
            this.f_62309_.put(p_156769_, p_156770_);
            return this;
        }

        public Builder m_156780_(ResourceLocation p_156781_, boolean p_156782_) {
            this.f_62310_.put((Object)p_156781_, p_156782_);
            return this;
        }

        public Builder m_156773_(GameType p_156774_) {
            this.f_62308_ = p_156774_;
            return this;
        }

        public Builder m_156771_(EntityPredicate p_156772_) {
            this.f_156766_ = p_156772_;
            return this;
        }

        public Builder m_156783_(ResourceLocation p_156784_, boolean p_156785_) {
            this.f_62311_.put(p_156784_, new AdvancementDonePredicate(p_156785_));
            return this;
        }

        public Builder m_156777_(ResourceLocation p_156778_, Map<String, Boolean> p_156779_) {
            this.f_62311_.put(p_156778_, new AdvancementCriterionsPredicate((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(p_156779_)));
            return this;
        }

        public PlayerPredicate m_62313_() {
            return new PlayerPredicate(this.f_62307_, this.f_62308_, this.f_62309_, this.f_62310_, this.f_62311_, this.f_156766_);
        }
    }
}

