/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import com.google.common.collect.ImmutableSetMultimap;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.logging.Level;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.util.TemporaryFiles;
import me.lucko.spark.lib.asyncprofiler.AsyncProfiler;

public enum AsyncProfilerAccess {
    INSTANCE;

    private final AsyncProfiler profiler;
    private final ProfilingEvent profilingEvent;
    private final Exception setupException;

    private AsyncProfilerAccess() {
        AsyncProfiler profiler;
        ProfilingEvent profilingEvent = null;
        Exception setupException = null;
        try {
            profiler = AsyncProfilerAccess.load();
            if (AsyncProfilerAccess.isEventSupported(profiler, ProfilingEvent.CPU, false)) {
                profilingEvent = ProfilingEvent.CPU;
            } else if (AsyncProfilerAccess.isEventSupported(profiler, ProfilingEvent.WALL, true)) {
                profilingEvent = ProfilingEvent.WALL;
            }
        }
        catch (Exception e) {
            profiler = null;
            setupException = e;
        }
        this.profiler = profiler;
        this.profilingEvent = profilingEvent;
        this.setupException = setupException;
    }

    public AsyncProfiler getProfiler() {
        if (this.profiler == null) {
            throw new UnsupportedOperationException("async-profiler not supported", this.setupException);
        }
        return this.profiler;
    }

    public ProfilingEvent getProfilingEvent() {
        return this.profilingEvent;
    }

    public boolean checkSupported(SparkPlatform platform) {
        if (this.setupException != null) {
            if (this.setupException instanceof UnsupportedSystemException) {
                platform.getPlugin().log(Level.INFO, "The async-profiler engine is not supported for your os/arch (" + this.setupException.getMessage() + "), so the built-in Java engine will be used instead.");
            } else if (this.setupException instanceof NativeLoadingException && this.setupException.getCause().getMessage().contains("libstdc++")) {
                platform.getPlugin().log(Level.WARNING, "Unable to initialise the async-profiler engine because libstdc++ is not installed.");
                platform.getPlugin().log(Level.WARNING, "Please see here for more information: https://spark.lucko.me/docs/misc/Using-async-profiler#install-libstdc");
            } else {
                platform.getPlugin().log(Level.WARNING, "Unable to initialise the async-profiler engine: " + this.setupException.getMessage());
                platform.getPlugin().log(Level.WARNING, "Please see here for more information: https://spark.lucko.me/docs/misc/Using-async-profiler");
                this.setupException.printStackTrace();
            }
        }
        return this.profiler != null;
    }

    private static AsyncProfiler load() throws Exception {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT).replace(" ", "");
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        ImmutableSetMultimap supported = ImmutableSetMultimap.builder().put((Object)"linux", (Object)"amd64").put((Object)"macosx", (Object)"amd64").put((Object)"macosx", (Object)"aarch64").build();
        if (!supported.containsEntry((Object)os, (Object)arch)) {
            throw new UnsupportedSystemException(os, arch);
        }
        String resource = "spark/" + os + "/libasyncProfiler.so";
        URL profilerResource = AsyncProfilerAccess.class.getClassLoader().getResource(resource);
        if (profilerResource == null) {
            throw new IllegalStateException("Could not find " + resource + " in spark jar file");
        }
        Path extractPath = TemporaryFiles.create("spark-", "-libasyncProfiler.so.tmp");
        try (InputStream in = profilerResource.openStream();){
            Files.copy(in, extractPath, StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            return AsyncProfiler.getInstance(extractPath.toAbsolutePath().toString());
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeLoadingException(e);
        }
    }

    private static boolean isEventSupported(AsyncProfiler profiler, ProfilingEvent event, boolean throwException) {
        block4: {
            try {
                String resp = profiler.execute("check,event=" + (Object)((Object)event)).trim();
                if (resp.equalsIgnoreCase("ok")) {
                    return true;
                }
                if (throwException) {
                    throw new IllegalArgumentException(resp);
                }
            }
            catch (Exception e) {
                if (!throwException) break block4;
                throw new RuntimeException("Event " + (Object)((Object)event) + " is not supported", e);
            }
        }
        return false;
    }

    static enum ProfilingEvent {
        CPU("cpu"),
        WALL("wall");

        private final String id;

        private ProfilingEvent(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    private static final class UnsupportedSystemException
    extends UnsupportedOperationException {
        public UnsupportedSystemException(String os, String arch) {
            super(os + '/' + arch);
        }
    }

    private static final class NativeLoadingException
    extends RuntimeException {
        public NativeLoadingException(Throwable cause) {
            super("A runtime error occurred whilst loading the native library", cause);
        }
    }
}

