/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.monitor.cpu.CpuInfo;
import me.lucko.spark.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.common.monitor.disk.DiskUsage;
import me.lucko.spark.common.monitor.memory.GarbageCollectorStatistics;
import me.lucko.spark.common.monitor.memory.MemoryInfo;
import me.lucko.spark.common.monitor.ping.PingStatistics;
import me.lucko.spark.common.monitor.tick.TickStatistics;
import me.lucko.spark.common.util.RollingAverage;
import me.lucko.spark.proto.SparkProtos;

public class PlatformStatisticsProvider {
    private final SparkPlatform platform;

    public PlatformStatisticsProvider(SparkPlatform platform) {
        this.platform = platform;
    }

    public SparkProtos.SystemStatistics getSystemStatistics() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        SparkProtos.SystemStatistics.Builder builder = SparkProtos.SystemStatistics.newBuilder().setCpu((SparkProtos.SystemStatistics.Cpu)SparkProtos.SystemStatistics.Cpu.newBuilder().setThreads(Runtime.getRuntime().availableProcessors()).setProcessUsage((SparkProtos.SystemStatistics.Cpu.Usage)SparkProtos.SystemStatistics.Cpu.Usage.newBuilder().setLast1M(CpuMonitor.processLoad1MinAvg()).setLast15M(CpuMonitor.processLoad15MinAvg()).build()).setSystemUsage((SparkProtos.SystemStatistics.Cpu.Usage)SparkProtos.SystemStatistics.Cpu.Usage.newBuilder().setLast1M(CpuMonitor.systemLoad1MinAvg()).setLast15M(CpuMonitor.systemLoad15MinAvg()).build()).setModelName(CpuInfo.queryCpuModel()).build()).setMemory((SparkProtos.SystemStatistics.Memory)SparkProtos.SystemStatistics.Memory.newBuilder().setPhysical((SparkProtos.SystemStatistics.Memory.MemoryPool)SparkProtos.SystemStatistics.Memory.MemoryPool.newBuilder().setUsed(MemoryInfo.getUsedPhysicalMemory()).setTotal(MemoryInfo.getTotalPhysicalMemory()).build()).setSwap((SparkProtos.SystemStatistics.Memory.MemoryPool)SparkProtos.SystemStatistics.Memory.MemoryPool.newBuilder().setUsed(MemoryInfo.getUsedSwap()).setTotal(MemoryInfo.getTotalSwap()).build()).build()).setDisk((SparkProtos.SystemStatistics.Disk)SparkProtos.SystemStatistics.Disk.newBuilder().setTotal(DiskUsage.getTotal()).setUsed(DiskUsage.getUsed()).build()).setOs((SparkProtos.SystemStatistics.Os)SparkProtos.SystemStatistics.Os.newBuilder().setArch(System.getProperty("os.arch")).setName(System.getProperty("os.name")).setVersion(System.getProperty("os.version")).build()).setJava((SparkProtos.SystemStatistics.Java)SparkProtos.SystemStatistics.Java.newBuilder().setVendor(System.getProperty("java.vendor", "unknown")).setVersion(System.getProperty("java.version", "unknown")).setVendorVersion(System.getProperty("java.vendor.version", "unknown")).setVmArgs(String.join((CharSequence)" ", runtimeBean.getInputArguments())).build());
        long uptime = runtimeBean.getUptime();
        builder.setUptime(uptime);
        Map<String, GarbageCollectorStatistics> gcStats = GarbageCollectorStatistics.pollStats();
        gcStats.forEach((name, statistics) -> builder.putGc((String)name, (SparkProtos.SystemStatistics.Gc)SparkProtos.SystemStatistics.Gc.newBuilder().setTotal(statistics.getCollectionCount()).setAvgTime(statistics.getAverageCollectionTime()).setAvgFrequency(statistics.getAverageCollectionFrequency(uptime)).build()));
        return (SparkProtos.SystemStatistics)builder.build();
    }

    public SparkProtos.PlatformStatistics getPlatformStatistics(Map<String, GarbageCollectorStatistics> startingGcStatistics) {
        PingStatistics pingStatistics;
        TickStatistics tickStatistics;
        SparkProtos.PlatformStatistics.Builder builder = SparkProtos.PlatformStatistics.newBuilder();
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        builder.setMemory((SparkProtos.PlatformStatistics.Memory)SparkProtos.PlatformStatistics.Memory.newBuilder().setHeap((SparkProtos.PlatformStatistics.Memory.MemoryPool)SparkProtos.PlatformStatistics.Memory.MemoryPool.newBuilder().setUsed(memoryUsage.getUsed()).setTotal(memoryUsage.getCommitted()).build()).build());
        long uptime = System.currentTimeMillis() - this.platform.getServerNormalOperationStartTime();
        builder.setUptime(uptime);
        if (startingGcStatistics != null) {
            Map<String, GarbageCollectorStatistics> gcStats = GarbageCollectorStatistics.pollStatsSubtractInitial(startingGcStatistics);
            gcStats.forEach((name, statistics) -> builder.putGc((String)name, (SparkProtos.PlatformStatistics.Gc)SparkProtos.PlatformStatistics.Gc.newBuilder().setTotal(statistics.getCollectionCount()).setAvgTime(statistics.getAverageCollectionTime()).setAvgFrequency(statistics.getAverageCollectionFrequency(uptime)).build()));
        }
        if ((tickStatistics = this.platform.getTickStatistics()) != null) {
            builder.setTps((SparkProtos.PlatformStatistics.Tps)SparkProtos.PlatformStatistics.Tps.newBuilder().setLast1M(tickStatistics.tps1Min()).setLast5M(tickStatistics.tps5Min()).setLast15M(tickStatistics.tps15Min()).build());
            if (tickStatistics.isDurationSupported()) {
                builder.setMspt((SparkProtos.PlatformStatistics.Mspt)SparkProtos.PlatformStatistics.Mspt.newBuilder().setLast1M(PlatformStatisticsProvider.rollingAverageValues(tickStatistics.duration1Min())).setLast5M(PlatformStatisticsProvider.rollingAverageValues(tickStatistics.duration5Min())).build());
            }
        }
        if ((pingStatistics = this.platform.getPingStatistics()) != null && pingStatistics.getPingAverage().getSamples() != 0) {
            builder.setPing((SparkProtos.PlatformStatistics.Ping)SparkProtos.PlatformStatistics.Ping.newBuilder().setLast15M(PlatformStatisticsProvider.rollingAverageValues(pingStatistics.getPingAverage())).build());
        }
        return (SparkProtos.PlatformStatistics)builder.build();
    }

    private static SparkProtos.PlatformStatistics.RollingAverageValues rollingAverageValues(RollingAverage rollingAverage) {
        return (SparkProtos.PlatformStatistics.RollingAverageValues)SparkProtos.PlatformStatistics.RollingAverageValues.newBuilder().setMean(rollingAverage.mean()).setMax(rollingAverage.max()).setMin(rollingAverage.min()).setMedian(rollingAverage.median()).setPercentile95(rollingAverage.percentile95th()).build();
    }
}

