/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.monitor.memory;

import java.lang.management.ManagementFactory;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class MemoryInfo
extends Enum<MemoryInfo> {
    private static final String OPERATING_SYSTEM_BEAN = "java.lang:type=OperatingSystem";
    private static final OperatingSystemMXBean BEAN;
    private static final /* synthetic */ MemoryInfo[] $VALUES;

    public static MemoryInfo[] values() {
        return (MemoryInfo[])$VALUES.clone();
    }

    public static MemoryInfo valueOf(String name) {
        return Enum.valueOf(MemoryInfo.class, name);
    }

    public static long getUsedSwap() {
        return BEAN.getTotalSwapSpaceSize() - BEAN.getFreeSwapSpaceSize();
    }

    public static long getTotalSwap() {
        return BEAN.getTotalSwapSpaceSize();
    }

    public static long getUsedPhysicalMemory() {
        return BEAN.getTotalPhysicalMemorySize() - BEAN.getFreePhysicalMemorySize();
    }

    public static long getTotalPhysicalMemory() {
        return BEAN.getTotalPhysicalMemorySize();
    }

    public static long getTotalVirtualMemory() {
        return BEAN.getCommittedVirtualMemorySize();
    }

    private static /* synthetic */ MemoryInfo[] $values() {
        return new MemoryInfo[0];
    }

    static {
        $VALUES = MemoryInfo.$values();
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName diagnosticBeanName = ObjectName.getInstance(OPERATING_SYSTEM_BEAN);
            BEAN = JMX.newMXBeanProxy(beanServer, diagnosticBeanName, OperatingSystemMXBean.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("OperatingSystemMXBean is not supported by the system", e);
        }
    }

    public static interface OperatingSystemMXBean {
        public long getCommittedVirtualMemorySize();

        public long getTotalSwapSpaceSize();

        public long getFreeSwapSpaceSize();

        public long getFreePhysicalMemorySize();

        public long getTotalPhysicalMemorySize();
    }
}

