/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CanyonWorldCarver;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.NetherWorldCarver;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldCarver<C extends CarverConfiguration>
extends ForgeRegistryEntry<WorldCarver<?>> {
    public static final WorldCarver<CaveCarverConfiguration> f_64974_ = WorldCarver.m_65065_("cave", new CaveWorldCarver(CaveCarverConfiguration.f_159154_));
    public static final WorldCarver<CaveCarverConfiguration> f_64975_ = WorldCarver.m_65065_("nether_cave", new NetherWorldCarver(CaveCarverConfiguration.f_159154_));
    public static final WorldCarver<CanyonCarverConfiguration> f_64976_ = WorldCarver.m_65065_("canyon", new CanyonWorldCarver(CanyonCarverConfiguration.f_158966_));
    protected static final BlockState f_64979_ = Blocks.f_50016_.m_49966_();
    protected static final BlockState f_64980_ = Blocks.f_50627_.m_49966_();
    protected static final FluidState f_64981_ = Fluids.f_76193_.m_76145_();
    protected static final FluidState f_64982_ = Fluids.f_76195_.m_76145_();
    protected Set<Block> f_64983_ = ImmutableSet.of((Object)((Object)Blocks.f_49990_), (Object)((Object)Blocks.f_50069_), (Object)((Object)Blocks.f_50122_), (Object)((Object)Blocks.f_50228_), (Object)((Object)Blocks.f_50334_), (Object)((Object)Blocks.f_50493_), (Object[])new Block[]{Blocks.f_50546_, Blocks.f_50599_, Blocks.f_50440_, Blocks.f_50352_, Blocks.f_50287_, Blocks.f_50288_, Blocks.f_50289_, Blocks.f_50290_, Blocks.f_50291_, Blocks.f_50292_, Blocks.f_50293_, Blocks.f_50294_, Blocks.f_50295_, Blocks.f_50296_, Blocks.f_50297_, Blocks.f_50298_, Blocks.f_50299_, Blocks.f_50300_, Blocks.f_50301_, Blocks.f_50302_, Blocks.f_50062_, Blocks.f_50394_, Blocks.f_50195_, Blocks.f_50125_, Blocks.f_50354_, Blocks.f_152550_, Blocks.f_152497_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_49994_, Blocks.f_152496_, Blocks.f_50122_, Blocks.f_49996_, Blocks.f_152468_, Blocks.f_152598_, Blocks.f_152505_, Blocks.f_152506_, Blocks.f_152599_});
    protected Set<Fluid> f_64984_ = ImmutableSet.of((Object)((Object)Fluids.f_76193_));
    private final Codec<ConfiguredWorldCarver<C>> f_64986_;

    private static <C extends CarverConfiguration, F extends WorldCarver<C>> F m_65065_(String p_65066_, F p_65067_) {
        return (F)((Object)Registry.m_122961_(Registry.f_122837_, p_65066_, p_65067_));
    }

    public WorldCarver(Codec<C> p_159366_) {
        this.f_64986_ = p_159366_.fieldOf("config").xmap(this::m_65063_, ConfiguredWorldCarver::m_64855_).codec();
    }

    public ConfiguredWorldCarver<C> m_65063_(C p_65064_) {
        return new ConfiguredWorldCarver(this, p_65064_);
    }

    public Codec<ConfiguredWorldCarver<C>> m_65072_() {
        return this.f_64986_;
    }

    public int m_65073_() {
        return 4;
    }

    protected boolean m_190753_(CarvingContext p_190754_, C p_190755_, ChunkAccess p_190756_, Function<BlockPos, Biome> p_190757_, Aquifer p_190758_, double p_190759_, double p_190760_, double p_190761_, double p_190762_, double p_190763_, CarvingMask p_190764_, CarveSkipChecker p_190765_) {
        ChunkPos chunkpos = p_190756_.m_7697_();
        double d0 = chunkpos.m_151390_();
        double d1 = chunkpos.m_151393_();
        double d2 = 16.0 + p_190762_ * 2.0;
        if (!(Math.abs(p_190759_ - d0) > d2) && !(Math.abs(p_190761_ - d1) > d2)) {
            int i = chunkpos.m_45604_();
            int j = chunkpos.m_45605_();
            int k = Math.max(Mth.m_14107_((double)(p_190759_ - p_190762_)) - i - 1, 0);
            int l = Math.min(Mth.m_14107_((double)(p_190759_ + p_190762_)) - i, 15);
            int i1 = Math.max(Mth.m_14107_((double)(p_190760_ - p_190763_)) - 1, p_190754_.m_142201_() + 1);
            int j1 = p_190756_.m_187679_() ? 0 : 7;
            int k1 = Math.min(Mth.m_14107_((double)(p_190760_ + p_190763_)) + 1, p_190754_.m_142201_() + p_190754_.m_142208_() - 1 - j1);
            int l1 = Math.max(Mth.m_14107_((double)(p_190761_ - p_190762_)) - j - 1, 0);
            int i2 = Math.min(Mth.m_14107_((double)(p_190761_ + p_190762_)) - j, 15);
            boolean flag = false;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (int j2 = k; j2 <= l; ++j2) {
                int k2 = chunkpos.m_151382_(j2);
                double d3 = ((double)k2 + 0.5 - p_190759_) / p_190762_;
                for (int l2 = l1; l2 <= i2; ++l2) {
                    int i3 = chunkpos.m_151391_(l2);
                    double d4 = ((double)i3 + 0.5 - p_190761_) / p_190762_;
                    if (d3 * d3 + d4 * d4 >= 1.0) continue;
                    MutableBoolean mutableboolean = new MutableBoolean(false);
                    for (int j3 = k1; j3 > i1; --j3) {
                        double d5 = ((double)j3 - 0.5 - p_190760_) / p_190763_;
                        if (p_190765_.m_159425_(p_190754_, d3, d5, d4, j3) || p_190764_.m_187594_(j2, j3, l2) && !WorldCarver.m_159423_(p_190755_)) continue;
                        p_190764_.m_187585_(j2, j3, l2);
                        blockpos$mutableblockpos.m_122178_(k2, j3, i3);
                        flag |= this.m_183633_(p_190754_, p_190755_, p_190756_, p_190757_, p_190764_, blockpos$mutableblockpos, blockpos$mutableblockpos1, p_190758_, mutableboolean);
                    }
                }
            }
            return flag;
        }
        return false;
    }

    protected boolean m_183633_(CarvingContext p_190744_, C p_190745_, ChunkAccess p_190746_, Function<BlockPos, Biome> p_190747_, CarvingMask p_190748_, BlockPos.MutableBlockPos p_190749_, BlockPos.MutableBlockPos p_190750_, Aquifer p_190751_, MutableBoolean p_190752_) {
        BlockState blockstate = p_190746_.m_8055_((BlockPos)p_190749_);
        if (blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_50195_)) {
            p_190752_.setTrue();
        }
        if (!this.m_65010_(blockstate) && !WorldCarver.m_159423_(p_190745_)) {
            return false;
        }
        BlockState blockstate1 = this.m_159418_(p_190744_, p_190745_, (BlockPos)p_190749_, p_190751_);
        if (blockstate1 == null) {
            return false;
        }
        p_190746_.m_6978_((BlockPos)p_190749_, blockstate1, false);
        if (p_190751_.m_142203_() && !blockstate1.m_60819_().m_76178_()) {
            p_190746_.m_8113_((BlockPos)p_190749_);
        }
        if (p_190752_.isTrue()) {
            p_190750_.m_122159_((Vec3i)p_190749_, Direction.DOWN);
            if (p_190746_.m_8055_((BlockPos)p_190750_).m_60713_(Blocks.f_50493_)) {
                p_190744_.m_190646_(p_190747_, p_190746_, (BlockPos)p_190750_, !blockstate1.m_60819_().m_76178_()).ifPresent(p_190743_ -> {
                    p_190746_.m_6978_((BlockPos)p_190750_, (BlockState)((Object)p_190743_), false);
                    if (!p_190743_.m_60819_().m_76178_()) {
                        p_190746_.m_8113_((BlockPos)p_190750_);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState m_159418_(CarvingContext p_159419_, C p_159420_, BlockPos p_159421_, Aquifer p_159422_) {
        if (p_159421_.m_123342_() <= ((CarverConfiguration)p_159420_).f_159090_.m_142322_((WorldGenerationContext)p_159419_)) {
            return f_64982_.m_76188_();
        }
        BlockState blockstate = p_159422_.m_183427_(p_159421_.m_123341_(), p_159421_.m_123342_(), p_159421_.m_123343_(), 0.0, 0.0);
        if (blockstate == null) {
            return WorldCarver.m_159423_(p_159420_) ? ((CarverConfiguration)p_159420_).f_159092_.m_159148_() : null;
        }
        return WorldCarver.m_159423_(p_159420_) ? WorldCarver.m_159381_(p_159420_, blockstate) : blockstate;
    }

    private static BlockState m_159381_(CarverConfiguration p_159382_, BlockState p_159383_) {
        if (p_159383_.m_60713_(Blocks.f_50016_)) {
            return p_159382_.f_159092_.m_159145_();
        }
        if (p_159383_.m_60713_(Blocks.f_49990_)) {
            BlockState blockstate = p_159382_.f_159092_.m_159146_();
            return blockstate.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)((Object)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, Boolean.valueOf(true))) : blockstate;
        }
        return p_159383_.m_60713_(Blocks.f_49991_) ? p_159382_.f_159092_.m_159147_() : p_159383_;
    }

    public abstract boolean m_183279_(CarvingContext var1, C var2, ChunkAccess var3, Function<BlockPos, Biome> var4, Random var5, Aquifer var6, ChunkPos var7, CarvingMask var8);

    public abstract boolean m_142512_(C var1, Random var2);

    protected boolean m_65010_(BlockState p_65011_) {
        return this.f_64983_.contains((Object)p_65011_.m_60734_());
    }

    protected static boolean m_159367_(ChunkPos p_159368_, double p_159369_, double p_159370_, int p_159371_, int p_159372_, float p_159373_) {
        double d5;
        double d4;
        double d1;
        double d3;
        double d0 = p_159368_.m_151390_();
        double d2 = p_159369_ - d0;
        return d2 * d2 + (d3 = p_159370_ - (d1 = (double)p_159368_.m_151393_())) * d3 - (d4 = (double)(p_159372_ - p_159371_)) * d4 <= (d5 = (double)(p_159373_ + 2.0f + 16.0f)) * d5;
    }

    private static boolean m_159423_(CarverConfiguration p_159424_) {
        return p_159424_.f_159092_.m_159128_();
    }

    public static interface CarveSkipChecker {
        public boolean m_159425_(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

