/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;
import net.minecraft.world.level.levelgen.material.WorldGenMaterialRule;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.world.StructureSpawnManager;

public class NoiseBasedChunkGenerator
extends ChunkGenerator {
    public static final Codec<NoiseBasedChunkGenerator> f_64314_ = RecordCodecBuilder.create(p_188643_ -> p_188643_.group((App)RegistryLookupCodec.m_135622_(Registry.f_194568_).forGetter(p_188716_ -> p_188716_.f_188604_), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(p_188711_ -> p_188711_.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_188690_ -> p_188690_.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(p_188652_ -> p_188652_.f_64318_)).apply((Applicative)p_188643_, p_188643_.stable(NoiseBasedChunkGenerator::new)));
    private static final BlockState f_64321_ = Blocks.f_50016_.m_49966_();
    private static final BlockState[] f_158373_ = new BlockState[0];
    protected final BlockState f_64316_;
    private final Registry<NormalNoise.NoiseParameters> f_188604_;
    protected final long f_64333_;
    protected final Supplier<NoiseGeneratorSettings> f_64318_;
    protected final NoiseSampler f_158382_;
    private final SurfaceSystem f_188605_;
    private final WorldGenMaterialRule f_188606_;
    private final Aquifer.FluidPicker f_188607_;

    public NoiseBasedChunkGenerator(Registry<NormalNoise.NoiseParameters> p_188609_, BiomeSource p_188610_, long p_188611_, Supplier<NoiseGeneratorSettings> p_188612_) {
        this(p_188609_, p_188610_, p_188610_, p_188611_, p_188612_);
    }

    private NoiseBasedChunkGenerator(Registry<NormalNoise.NoiseParameters> p_188614_, BiomeSource p_188615_, BiomeSource p_188616_, long p_188617_, Supplier<NoiseGeneratorSettings> p_188618_) {
        super(p_188615_, p_188616_, p_188618_.get().m_64457_(), p_188617_);
        this.f_188604_ = p_188614_;
        this.f_64333_ = p_188617_;
        this.f_64318_ = p_188618_;
        NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.get();
        this.f_64316_ = noisegeneratorsettings.m_64482_();
        NoiseSettings noisesettings = noisegeneratorsettings.m_64481_();
        this.f_158382_ = new NoiseSampler(noisesettings, noisegeneratorsettings.m_158568_(), p_188617_, p_188614_, noisegeneratorsettings.m_188893_());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(NoiseChunk::m_188754_);
        builder.add(NoiseChunk::m_188800_);
        this.f_188606_ = new MaterialRuleList((List)builder.build());
        Aquifer.FluidStatus aquifer$fluidstatus = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int i = noisegeneratorsettings.m_64486_();
        Aquifer.FluidStatus aquifer$fluidstatus1 = new Aquifer.FluidStatus(i, noisegeneratorsettings.m_64483_());
        Aquifer.FluidStatus aquifer$fluidstatus2 = new Aquifer.FluidStatus(noisesettings.f_158688_() - 1, Blocks.f_50016_.m_49966_());
        this.f_188607_ = (p_198228_, p_198229_, p_198230_) -> p_198229_ < Math.min(-54, i) ? aquifer$fluidstatus : aquifer$fluidstatus1;
        this.f_188605_ = new SurfaceSystem(p_188614_, this.f_64316_, i, p_188617_, noisegeneratorsettings.m_188893_());
    }

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> p_197005_, Executor p_197006_, Blender p_197007_, StructureFeatureManager p_197008_, ChunkAccess p_197009_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            this.m_196999_(p_197005_, p_197007_, p_197008_, p_197009_);
            return p_197009_;
        }), Util.m_183991_());
    }

    private void m_196999_(Registry<Biome> p_197000_, Blender p_197001_, StructureFeatureManager p_197002_, ChunkAccess p_197003_) {
        NoiseChunk noisechunk = p_197003_.m_187640_(this.f_158382_, () -> new Beardifier(p_197002_, p_197003_), this.f_64318_.get(), this.f_188607_, p_197001_);
        BiomeResolver biomeresolver = BelowZeroRetrogen.m_196981_((BiomeResolver)p_197001_.m_183383_((BiomeResolver)this.f_62138_), p_197000_, (ChunkAccess)p_197003_);
        p_197003_.m_183442_(biomeresolver, (p_188655_, p_188656_, p_188657_) -> this.f_158382_.m_188976_(p_188655_, p_188656_, p_188657_, noisechunk.m_188751_(p_188655_, p_188657_)));
    }

    public Climate.Sampler m_183403_() {
        return this.f_158382_;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return f_64314_;
    }

    public ChunkGenerator m_6819_(long p_64374_) {
        return new NoiseBasedChunkGenerator(this.f_188604_, this.f_62137_.m_7206_(p_64374_), p_64374_, this.f_64318_);
    }

    public boolean m_64375_(long p_64376_, ResourceKey<NoiseGeneratorSettings> p_64377_) {
        return this.f_64333_ == p_64376_ && this.f_64318_.get().m_64476_(p_64377_);
    }

    public int m_142647_(int p_158405_, int p_158406_, Heightmap.Types p_158407_, LevelHeightAccessor p_158408_) {
        NoiseSettings noisesettings = this.f_64318_.get().m_64481_();
        int i = Math.max(noisesettings.f_158688_(), p_158408_.m_141937_());
        int j = Math.min(noisesettings.f_158688_() + noisesettings.f_64508_(), p_158408_.m_151558_());
        int k = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int l = Mth.m_14042_((int)(j - i), (int)noisesettings.m_189212_());
        return l <= 0 ? p_158408_.m_141937_() : this.m_158413_(p_158405_, p_158406_, null, p_158407_.m_64299_(), k, l).orElse(p_158408_.m_141937_());
    }

    public NoiseColumn m_141914_(int p_158401_, int p_158402_, LevelHeightAccessor p_158403_) {
        NoiseSettings noisesettings = this.f_64318_.get().m_64481_();
        int i = Math.max(noisesettings.f_158688_(), p_158403_.m_141937_());
        int j = Math.min(noisesettings.f_158688_() + noisesettings.f_64508_(), p_158403_.m_151558_());
        int k = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int l = Mth.m_14042_((int)(j - i), (int)noisesettings.m_189212_());
        if (l <= 0) {
            return new NoiseColumn(i, f_158373_);
        }
        BlockState[] ablockstate = new BlockState[l * noisesettings.m_189212_()];
        this.m_158413_(p_158401_, p_158402_, ablockstate, null, k, l);
        return new NoiseColumn(i, ablockstate);
    }

    protected OptionalInt m_158413_(int p_158414_, int p_158415_, @Nullable BlockState[] p_158416_, @Nullable Predicate<BlockState> p_158417_, int p_158418_, int p_158419_) {
        NoiseSettings noisesettings = this.f_64318_.get().m_64481_();
        int i = noisesettings.m_189213_();
        int j = noisesettings.m_189212_();
        int k = Math.floorDiv(p_158414_, i);
        int l = Math.floorDiv(p_158415_, i);
        int i1 = Math.floorMod(p_158414_, i);
        int j1 = Math.floorMod(p_158415_, i);
        int k1 = k * i;
        int l1 = l * i;
        double d0 = (double)i1 / (double)i;
        double d1 = (double)j1 / (double)i;
        NoiseChunk noisechunk = NoiseChunk.m_188758_((int)k1, (int)l1, (int)p_158418_, (int)p_158419_, (NoiseSampler)this.f_158382_, (NoiseGeneratorSettings)this.f_64318_.get(), (Aquifer.FluidPicker)this.f_188607_);
        noisechunk.m_188791_();
        noisechunk.m_188749_(0);
        for (int i2 = p_158419_ - 1; i2 >= 0; --i2) {
            noisechunk.m_188810_(i2, 0);
            for (int j2 = j - 1; j2 >= 0; --j2) {
                BlockState blockstate1;
                int k2 = (p_158418_ + i2) * j + j2;
                double d2 = (double)j2 / (double)j;
                noisechunk.m_188744_(d2);
                noisechunk.m_188792_(d0);
                noisechunk.m_188805_(d1);
                BlockState blockstate = this.f_188606_.m_183577_(noisechunk, p_158414_, k2, p_158415_);
                BlockState blockState = blockstate1 = blockstate == null ? this.f_64316_ : blockstate;
                if (p_158416_ != null) {
                    int l2 = i2 * j + j2;
                    p_158416_[l2] = blockstate1;
                }
                if (p_158417_ == null || !p_158417_.test(blockstate1)) continue;
                return OptionalInt.of(k2 + 1);
            }
        }
        return OptionalInt.empty();
    }

    public void m_183621_(WorldGenRegion p_188636_, StructureFeatureManager p_188637_, ChunkAccess p_188638_) {
        if (!SharedConstants.m_183707_(p_188638_.m_7697_())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)p_188636_);
            NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.get();
            NoiseChunk noisechunk = p_188638_.m_187640_(this.f_158382_, () -> new Beardifier(p_188637_, p_188638_), noisegeneratorsettings, this.f_188607_, Blender.m_190202_((WorldGenRegion)p_188636_));
            this.f_188605_.m_189944_(p_188636_.m_7062_(), p_188636_.m_5962_().m_175515_(Registry.f_122885_), noisegeneratorsettings.m_188892_(), worldgenerationcontext, p_188638_, noisechunk, noisegeneratorsettings.m_188891_());
        }
    }

    public void m_183516_(WorldGenRegion p_188629_, long p_188630_, BiomeManager p_188631_, StructureFeatureManager p_188632_, ChunkAccess p_188633_, GenerationStep.Carving p_188634_) {
        BiomeManager biomemanager = p_188631_.m_186687_((p_188620_, p_188621_, p_188622_) -> this.f_62137_.m_183546_(p_188620_, p_188621_, p_188622_, this.m_183403_()));
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
        int i = 8;
        ChunkPos chunkpos = p_188633_.m_7697_();
        NoiseChunk noisechunk = p_188633_.m_187640_(this.f_158382_, () -> new Beardifier(p_188632_, p_188633_), this.f_64318_.get(), this.f_188607_, Blender.m_190202_((WorldGenRegion)p_188629_));
        Aquifer aquifer = noisechunk.m_188817_();
        CarvingContext carvingcontext = new CarvingContext(this, p_188629_.m_5962_(), p_188633_.m_183618_(), noisechunk);
        CarvingMask carvingmask = ((ProtoChunk)p_188633_).m_183613_(p_188634_);
        for (int j = -8; j <= 8; ++j) {
            for (int k = -8; k <= 8; ++k) {
                ChunkPos chunkpos1 = new ChunkPos(chunkpos.f_45578_ + j, chunkpos.f_45579_ + k);
                ChunkAccess chunkaccess = p_188629_.m_6325_(chunkpos1.f_45578_, chunkpos1.f_45579_);
                BiomeGenerationSettings biomegenerationsettings = chunkaccess.m_187655_(() -> this.f_62137_.m_183546_(QuartPos.m_175400_((int)chunkpos1.m_45604_()), 0, QuartPos.m_175400_((int)chunkpos1.m_45605_()), this.m_183403_())).m_47536_();
                List<Supplier<ConfiguredWorldCarver<?>>> list = biomegenerationsettings.m_47799_(p_188634_);
                ListIterator<Supplier<ConfiguredWorldCarver<?>>> listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int l = listiterator.nextIndex();
                    ConfiguredWorldCarver<?> configuredworldcarver = listiterator.next().get();
                    worldgenrandom.m_190068_(p_188630_ + (long)l, chunkpos1.f_45578_, chunkpos1.f_45579_);
                    if (!configuredworldcarver.m_159273_((Random)worldgenrandom)) continue;
                    configuredworldcarver.m_190712_(carvingcontext, p_188633_, arg_0 -> ((BiomeManager)biomemanager).m_47881_(arg_0), (Random)worldgenrandom, aquifer, chunkpos1, carvingmask);
                }
            }
        }
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor p_188702_, Blender p_188703_, StructureFeatureManager p_188704_, ChunkAccess p_188705_) {
        NoiseSettings noisesettings = this.f_64318_.get().m_64481_();
        LevelHeightAccessor levelheightaccessor = p_188705_.m_183618_();
        int i = Math.max(noisesettings.f_158688_(), levelheightaccessor.m_141937_());
        int j = Math.min(noisesettings.f_158688_() + noisesettings.f_64508_(), levelheightaccessor.m_151558_());
        int k = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int l = Mth.m_14042_((int)(j - i), (int)noisesettings.m_189212_());
        if (l <= 0) {
            return CompletableFuture.completedFuture(p_188705_);
        }
        int i1 = p_188705_.m_151564_(l * noisesettings.m_189212_() - 1 + i);
        int j1 = p_188705_.m_151564_(i);
        HashSet set = Sets.newHashSet();
        for (int k1 = i1; k1 >= j1; --k1) {
            LevelChunkSection levelchunksection = p_188705_.m_183278_(k1);
            levelchunksection.m_62981_();
            set.add(levelchunksection);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_("wgen_fill_noise", () -> this.m_188662_(p_188703_, p_188704_, p_188705_, k, l)), Util.m_183991_()).whenCompleteAsync((p_188677_, p_188678_) -> {
            for (LevelChunkSection levelchunksection1 : set) {
                levelchunksection1.m_63006_();
            }
        }, p_188702_);
    }

    private ChunkAccess m_188662_(Blender p_188663_, StructureFeatureManager p_188664_, ChunkAccess p_188665_, int p_188666_, int p_188667_) {
        NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.get();
        NoiseChunk noisechunk = p_188665_.m_187640_(this.f_158382_, () -> new Beardifier(p_188664_, p_188665_), noisegeneratorsettings, this.f_188607_, p_188663_);
        Heightmap heightmap = p_188665_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_188665_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = p_188665_.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        Aquifer aquifer = noisechunk.m_188817_();
        noisechunk.m_188791_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        NoiseSettings noisesettings = noisegeneratorsettings.m_64481_();
        int k = noisesettings.m_189213_();
        int l = noisesettings.m_189212_();
        int i1 = 16 / k;
        int j1 = 16 / k;
        for (int k1 = 0; k1 < i1; ++k1) {
            noisechunk.m_188749_(k1);
            for (int l1 = 0; l1 < j1; ++l1) {
                LevelChunkSection levelchunksection = p_188665_.m_183278_(p_188665_.m_151559_() - 1);
                for (int i2 = p_188667_ - 1; i2 >= 0; --i2) {
                    noisechunk.m_188810_(i2, l1);
                    for (int j2 = l - 1; j2 >= 0; --j2) {
                        int k2 = (p_188666_ + i2) * l + j2;
                        int l2 = k2 & 0xF;
                        int i3 = p_188665_.m_151564_(k2);
                        if (p_188665_.m_151564_(levelchunksection.m_63017_()) != i3) {
                            levelchunksection = p_188665_.m_183278_(i3);
                        }
                        double d0 = (double)j2 / (double)l;
                        noisechunk.m_188744_(d0);
                        for (int j3 = 0; j3 < k; ++j3) {
                            int k3 = i + k1 * k + j3;
                            int l3 = k3 & 0xF;
                            double d1 = (double)j3 / (double)k;
                            noisechunk.m_188792_(d1);
                            for (int i4 = 0; i4 < k; ++i4) {
                                int j4 = j + l1 * k + i4;
                                int k4 = j4 & 0xF;
                                double d2 = (double)i4 / (double)k;
                                noisechunk.m_188805_(d2);
                                BlockState blockstate = this.f_188606_.m_183577_(noisechunk, k3, k2, j4);
                                if (blockstate == null) {
                                    blockstate = this.f_64316_;
                                }
                                if ((blockstate = this.m_198231_(noisechunk, k3, k2, j4, blockstate)) == f_64321_ || SharedConstants.m_183707_(p_188665_.m_7697_())) continue;
                                if (blockstate.m_60791_() != 0 && p_188665_ instanceof ProtoChunk) {
                                    blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                    ((ProtoChunk)p_188665_).m_63277_((BlockPos)blockpos$mutableblockpos);
                                }
                                levelchunksection.m_62991_(l3, l2, k4, blockstate, false);
                                heightmap.m_64249_(l3, k2, k4, blockstate);
                                heightmap1.m_64249_(l3, k2, k4, blockstate);
                                if (!aquifer.m_142203_() || blockstate.m_60819_().m_76178_()) continue;
                                blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                p_188665_.m_8113_((BlockPos)blockpos$mutableblockpos);
                            }
                        }
                    }
                }
            }
            noisechunk.m_188804_();
        }
        return p_188665_;
    }

    private BlockState m_198231_(NoiseChunk p_198232_, int p_198233_, int p_198234_, int p_198235_, BlockState p_198236_) {
        return p_198236_;
    }

    public int m_6331_() {
        return this.f_64318_.get().m_64481_().f_64508_();
    }

    public int m_6337_() {
        return this.f_64318_.get().m_64486_();
    }

    public int m_142062_() {
        return this.f_64318_.get().m_64481_().f_158688_();
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_142184_(Biome p_158433_, StructureFeatureManager p_158434_, MobCategory p_158435_, BlockPos p_158436_) {
        if (!p_158434_.m_186605_(p_158436_)) {
            return super.m_142184_(p_158433_, p_158434_, p_158435_, p_158436_);
        }
        WeightedRandomList spawns = StructureSpawnManager.getStructureSpawns((StructureFeatureManager)p_158434_, (MobCategory)p_158435_, (BlockPos)p_158436_);
        if (spawns != null) {
            return spawns;
        }
        return (p_158435_ == MobCategory.UNDERGROUND_WATER_CREATURE || p_158435_ == MobCategory.AXOLOTLS) && p_158434_.m_186607_(p_158436_, StructureFeature.f_67023_).m_73603_() ? MobSpawnSettings.f_151796_ : super.m_142184_(p_158433_, p_158434_, p_158435_, p_158436_);
    }

    public void m_6929_(WorldGenRegion p_64379_) {
        if (!this.f_64318_.get().m_64487_()) {
            ChunkPos chunkpos = p_64379_.m_143488_();
            Biome biome = p_64379_.m_46857_(chunkpos.m_45615_().m_175288_(p_64379_.m_151558_() - 1));
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
            worldgenrandom.m_64690_(p_64379_.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
            NaturalSpawner.m_151616_((ServerLevelAccessor)p_64379_, biome, chunkpos, (Random)worldgenrandom);
        }
    }

    @Deprecated
    public Optional<BlockState> m_188668_(CarvingContext p_188669_, Function<BlockPos, Biome> p_188670_, ChunkAccess p_188671_, NoiseChunk p_188672_, BlockPos p_188673_, boolean p_188674_) {
        return this.f_188605_.m_189971_(this.f_64318_.get().m_188891_(), p_188669_, p_188670_, p_188671_, p_188672_, p_188673_, p_188674_);
    }
}

