/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagContainer;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.common.extensions.IForgeLevel;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.server.timings.TimeTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Level
extends CapabilityProvider<Level>
implements LevelAccessor,
AutoCloseable,
IForgeLevel {
    protected static final Logger f_46426_ = LogManager.getLogger();
    public static final Codec<ResourceKey<Level>> f_46427_ = ResourceLocation.f_135803_.xmap(ResourceKey.m_135797_(Registry.f_122819_), ResourceKey::m_135782_);
    public static final ResourceKey<Level> f_46428_ = ResourceKey.m_135785_(Registry.f_122819_, new ResourceLocation("overworld"));
    public static final ResourceKey<Level> f_46429_ = ResourceKey.m_135785_(Registry.f_122819_, new ResourceLocation("the_nether"));
    public static final ResourceKey<Level> f_46430_ = ResourceKey.m_135785_(Registry.f_122819_, new ResourceLocation("the_end"));
    public static final int f_151505_ = 30000000;
    public static final int f_151506_ = 512;
    public static final int f_151507_ = 32;
    private static final Direction[] f_46422_ = Direction.values();
    public static final int f_151508_ = 15;
    public static final int f_151509_ = 24000;
    public static final int f_151510_ = 20000000;
    public static final int f_151511_ = -20000000;
    protected final List<TickingBlockEntity> f_151512_ = Lists.newArrayList();
    private final List<TickingBlockEntity> f_151503_ = Lists.newArrayList();
    private boolean f_151504_;
    private final Thread f_46423_;
    private final boolean f_46424_;
    private int f_46425_;
    protected int f_46435_ = new Random().nextInt();
    protected final int f_46436_ = 1013904223;
    public float f_46437_;
    public float f_46438_;
    public float f_46439_;
    public float f_46440_;
    public final Random f_46441_ = new Random();
    private final DimensionType f_46445_;
    protected final WritableLevelData f_46442_;
    private final Supplier<ProfilerFiller> f_46446_;
    public final boolean f_46443_;
    private final WorldBorder f_46447_;
    private final BiomeManager f_46420_;
    private final ResourceKey<Level> f_46421_;
    private long f_186455_;
    public boolean restoringBlockSnapshots = false;
    public boolean captureBlockSnapshots = false;
    public ArrayList<BlockSnapshot> capturedBlockSnapshots = new ArrayList();
    private final ArrayList<BlockEntity> freshBlockEntities = new ArrayList();
    private final ArrayList<BlockEntity> pendingFreshBlockEntities = new ArrayList();
    private double maxEntityRadius = 2.0;

    protected Level(WritableLevelData p_46450_, ResourceKey<Level> p_46451_, final DimensionType p_46452_, Supplier<ProfilerFiller> p_46453_, boolean p_46454_, boolean p_46455_, long p_46456_) {
        super(Level.class);
        this.f_46446_ = p_46453_;
        this.f_46442_ = p_46450_;
        this.f_46445_ = p_46452_;
        this.f_46421_ = p_46451_;
        this.f_46443_ = p_46454_;
        this.f_46447_ = p_46452_.m_63959_() != 1.0 ? new WorldBorder(){

            public double m_6347_() {
                return super.m_6347_() / p_46452_.m_63959_();
            }

            public double m_6345_() {
                return super.m_6345_() / p_46452_.m_63959_();
            }
        } : new WorldBorder();
        this.f_46423_ = Thread.currentThread();
        this.f_46420_ = new BiomeManager((BiomeManager.NoiseBiomeSource)this, p_46456_);
        this.f_46424_ = p_46455_;
    }

    public boolean m_5776_() {
        return this.f_46443_;
    }

    @Nullable
    public MinecraftServer m_142572_() {
        return null;
    }

    public boolean m_46739_(BlockPos p_46740_) {
        return !this.m_151570_(p_46740_) && Level.m_46457_(p_46740_);
    }

    public static boolean m_46741_(BlockPos p_46742_) {
        return !Level.m_46724_(p_46742_.m_123342_()) && Level.m_46457_(p_46742_);
    }

    private static boolean m_46457_(BlockPos p_46458_) {
        return p_46458_.m_123341_() >= -30000000 && p_46458_.m_123343_() >= -30000000 && p_46458_.m_123341_() < 30000000 && p_46458_.m_123343_() < 30000000;
    }

    private static boolean m_46724_(int p_46725_) {
        return p_46725_ < -20000000 || p_46725_ >= 20000000;
    }

    public LevelChunk m_46745_(BlockPos p_46746_) {
        return this.m_6325_(SectionPos.m_123171_((int)p_46746_.m_123341_()), SectionPos.m_123171_((int)p_46746_.m_123343_()));
    }

    public LevelChunk m_6325_(int p_46727_, int p_46728_) {
        return (LevelChunk)this.m_46819_(p_46727_, p_46728_, ChunkStatus.f_62326_);
    }

    @Nullable
    public ChunkAccess m_6522_(int p_46502_, int p_46503_, ChunkStatus p_46504_, boolean p_46505_) {
        ChunkAccess chunkaccess = this.m_7726_().m_7587_(p_46502_, p_46503_, p_46504_, p_46505_);
        if (chunkaccess == null && p_46505_) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return chunkaccess;
    }

    public boolean m_7731_(BlockPos p_46601_, BlockState p_46602_, int p_46603_) {
        return this.m_6933_(p_46601_, p_46602_, p_46603_, 512);
    }

    public boolean m_6933_(BlockPos p_46605_, BlockState p_46606_, int p_46607_, int p_46608_) {
        if (this.m_151570_(p_46605_)) {
            return false;
        }
        if (!this.f_46443_ && this.m_46659_()) {
            return false;
        }
        LevelChunk levelchunk = this.m_46745_(p_46605_);
        Block block = p_46606_.m_60734_();
        p_46605_ = p_46605_.m_7949_();
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.f_46443_) {
            blockSnapshot = BlockSnapshot.create(this.f_46421_, (LevelAccessor)this, (BlockPos)p_46605_, (int)p_46607_);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        BlockState old = this.m_8055_(p_46605_);
        int oldLight = old.getLightEmission((BlockGetter)((Object)this), p_46605_);
        int oldOpacity = old.m_60739_((BlockGetter)((Object)this), p_46605_);
        BlockState blockstate = levelchunk.m_6978_(p_46605_, p_46606_, (p_46607_ & 0x40) != 0);
        if (blockstate == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        BlockState blockstate1 = this.m_8055_(p_46605_);
        if ((p_46607_ & 0x80) == 0 && blockstate1 != blockstate && (blockstate1.m_60739_((BlockGetter)((Object)this), p_46605_) != oldOpacity || blockstate1.getLightEmission((BlockGetter)((Object)this), p_46605_) != oldLight || blockstate1.m_60787_() || blockstate.m_60787_())) {
            this.m_46473_().m_6180_("queueCheckLight");
            this.m_7726_().m_7827_().m_142202_(p_46605_);
            this.m_46473_().m_7238_();
        }
        if (blockSnapshot == null) {
            this.markAndNotifyBlock(p_46605_, levelchunk, blockstate, p_46606_, p_46607_, p_46608_);
        }
        return true;
    }

    public void markAndNotifyBlock(BlockPos p_46605_, @Nullable LevelChunk levelchunk, BlockState blockstate, BlockState p_46606_, int p_46607_, int p_46608_) {
        Block block = p_46606_.m_60734_();
        BlockState blockstate1 = this.m_8055_(p_46605_);
        if (blockstate1 == p_46606_) {
            if (blockstate != blockstate1) {
                this.m_6550_(p_46605_, blockstate, blockstate1);
            }
            if ((p_46607_ & 2) != 0 && (!this.f_46443_ || (p_46607_ & 4) == 0) && (this.f_46443_ || levelchunk.m_6708_() != null && levelchunk.m_6708_().m_140114_(ChunkHolder.FullChunkStatus.TICKING))) {
                this.m_7260_(p_46605_, blockstate, p_46606_, p_46607_);
            }
            if ((p_46607_ & 1) != 0) {
                this.m_6289_(p_46605_, blockstate.m_60734_());
                if (!this.f_46443_ && p_46606_.m_60807_()) {
                    this.m_46717_(p_46605_, block);
                }
            }
            if ((p_46607_ & 0x10) == 0 && p_46608_ > 0) {
                int i = p_46607_ & 0xFFFFFFDE;
                blockstate.m_60762_(this, p_46605_, i, p_46608_ - 1);
                p_46606_.m_60705_(this, p_46605_, i, p_46608_ - 1);
                p_46606_.m_60762_(this, p_46605_, i, p_46608_ - 1);
            }
            this.m_6559_(p_46605_, blockstate, blockstate1);
        }
    }

    public void m_6559_(BlockPos p_46609_, BlockState p_46610_, BlockState p_46611_) {
    }

    public boolean m_7471_(BlockPos p_46623_, boolean p_46624_) {
        FluidState fluidstate = this.m_6425_(p_46623_);
        return this.m_7731_(p_46623_, fluidstate.m_76188_(), 3 | (p_46624_ ? 64 : 0));
    }

    public boolean m_7740_(BlockPos p_46626_, boolean p_46627_, @Nullable Entity p_46628_, int p_46629_) {
        boolean flag;
        BlockState blockstate = this.m_8055_(p_46626_);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = this.m_6425_(p_46626_);
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            this.m_46796_(2001, p_46626_, Block.m_49956_(blockstate));
        }
        if (p_46627_) {
            BlockEntity blockentity = blockstate.m_155947_() ? this.m_7702_(p_46626_) : null;
            Block.m_49881_(blockstate, this, p_46626_, blockentity, p_46628_, ItemStack.f_41583_);
        }
        if (flag = this.m_6933_(p_46626_, fluidstate.m_76188_(), 3, p_46629_)) {
            this.m_142346_(p_46628_, GameEvent.f_157794_, p_46626_);
        }
        return flag;
    }

    public void m_142052_(BlockPos p_151531_, BlockState p_151532_) {
    }

    public boolean m_46597_(BlockPos p_46598_, BlockState p_46599_) {
        return this.m_7731_(p_46598_, p_46599_, 3);
    }

    public abstract void m_7260_(BlockPos var1, BlockState var2, BlockState var3, int var4);

    public void m_6550_(BlockPos p_46678_, BlockState p_46679_, BlockState p_46680_) {
    }

    public void m_46672_(BlockPos p_46673_, Block p_46674_) {
        if (ForgeEventFactory.onNeighborNotify((Level)this, (BlockPos)p_46673_, (BlockState)this.m_8055_(p_46673_), EnumSet.allOf(Direction.class), (boolean)false).isCanceled()) {
            return;
        }
        this.m_46586_(p_46673_.m_142125_(), p_46674_, p_46673_);
        this.m_46586_(p_46673_.m_142126_(), p_46674_, p_46673_);
        this.m_46586_(p_46673_.m_7495_(), p_46674_, p_46673_);
        this.m_46586_(p_46673_.m_7494_(), p_46674_, p_46673_);
        this.m_46586_(p_46673_.m_142127_(), p_46674_, p_46673_);
        this.m_46586_(p_46673_.m_142128_(), p_46674_, p_46673_);
    }

    public void m_46590_(BlockPos p_46591_, Block p_46592_, Direction p_46593_) {
        EnumSet<Direction> directions = EnumSet.allOf(Direction.class);
        directions.remove((Object)p_46593_);
        if (ForgeEventFactory.onNeighborNotify((Level)this, (BlockPos)p_46591_, (BlockState)this.m_8055_(p_46591_), directions, (boolean)false).isCanceled()) {
            return;
        }
        if (p_46593_ != Direction.WEST) {
            this.m_46586_(p_46591_.m_142125_(), p_46592_, p_46591_);
        }
        if (p_46593_ != Direction.EAST) {
            this.m_46586_(p_46591_.m_142126_(), p_46592_, p_46591_);
        }
        if (p_46593_ != Direction.DOWN) {
            this.m_46586_(p_46591_.m_7495_(), p_46592_, p_46591_);
        }
        if (p_46593_ != Direction.UP) {
            this.m_46586_(p_46591_.m_7494_(), p_46592_, p_46591_);
        }
        if (p_46593_ != Direction.NORTH) {
            this.m_46586_(p_46591_.m_142127_(), p_46592_, p_46591_);
        }
        if (p_46593_ != Direction.SOUTH) {
            this.m_46586_(p_46591_.m_142128_(), p_46592_, p_46591_);
        }
    }

    public void m_46586_(BlockPos p_46587_, Block p_46588_, BlockPos p_46589_) {
        if (!this.f_46443_) {
            BlockState blockstate = this.m_8055_(p_46587_);
            try {
                blockstate.m_60690_(this, p_46587_, p_46588_, p_46589_, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_(throwable, "Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being updated");
                crashreportcategory.m_128165_("Source block type", (CrashReportDetail<String>)((CrashReportDetail)() -> {
                    try {
                        return String.format("ID #%s (%s // %s)", p_46588_.getRegistryName(), p_46588_.m_7705_(), ((Object)((Object)p_46588_)).getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + p_46588_.getRegistryName();
                    }
                }));
                CrashReportCategory.m_178950_(crashreportcategory, (LevelHeightAccessor)this, p_46587_, blockstate);
                throw new ReportedException(crashreport);
            }
        }
    }

    public int m_6924_(Heightmap.Types p_46571_, int p_46572_, int p_46573_) {
        int i = p_46572_ >= -30000000 && p_46573_ >= -30000000 && p_46572_ < 30000000 && p_46573_ < 30000000 ? (this.m_7232_(SectionPos.m_123171_((int)p_46572_), SectionPos.m_123171_((int)p_46573_)) ? this.m_6325_(SectionPos.m_123171_((int)p_46572_), SectionPos.m_123171_((int)p_46573_)).m_5885_(p_46571_, p_46572_ & 0xF, p_46573_ & 0xF) + 1 : this.m_141937_()) : this.m_5736_() + 1;
        return i;
    }

    public LevelLightEngine m_5518_() {
        return this.m_7726_().m_7827_();
    }

    public BlockState m_8055_(BlockPos p_46732_) {
        if (this.m_151570_(p_46732_)) {
            return Blocks.f_50626_.m_49966_();
        }
        LevelChunk levelchunk = this.m_6325_(SectionPos.m_123171_((int)p_46732_.m_123341_()), SectionPos.m_123171_((int)p_46732_.m_123343_()));
        return levelchunk.m_8055_(p_46732_);
    }

    public FluidState m_6425_(BlockPos p_46671_) {
        if (this.m_151570_(p_46671_)) {
            return Fluids.f_76191_.m_76145_();
        }
        LevelChunk levelchunk = this.m_46745_(p_46671_);
        return levelchunk.m_6425_(p_46671_);
    }

    public boolean m_46461_() {
        return !this.m_6042_().m_63967_() && this.f_46425_ < 4;
    }

    public boolean m_46462_() {
        return !this.m_6042_().m_63967_() && !this.m_46461_();
    }

    public void m_5594_(@Nullable Player p_46560_, BlockPos p_46561_, SoundEvent p_46562_, SoundSource p_46563_, float p_46564_, float p_46565_) {
        this.m_6263_(p_46560_, (double)p_46561_.m_123341_() + 0.5, (double)p_46561_.m_123342_() + 0.5, (double)p_46561_.m_123343_() + 0.5, p_46562_, p_46563_, p_46564_, p_46565_);
    }

    public abstract void m_6263_(@Nullable Player var1, double var2, double var4, double var6, SoundEvent var8, SoundSource var9, float var10, float var11);

    public abstract void m_6269_(@Nullable Player var1, Entity var2, SoundEvent var3, SoundSource var4, float var5, float var6);

    public void m_7785_(double p_46482_, double p_46483_, double p_46484_, SoundEvent p_46485_, SoundSource p_46486_, float p_46487_, float p_46488_, boolean p_46489_) {
    }

    public void m_7106_(ParticleOptions p_46631_, double p_46632_, double p_46633_, double p_46634_, double p_46635_, double p_46636_, double p_46637_) {
    }

    public void m_6493_(ParticleOptions p_46638_, boolean p_46639_, double p_46640_, double p_46641_, double p_46642_, double p_46643_, double p_46644_, double p_46645_) {
    }

    public void m_7107_(ParticleOptions p_46684_, double p_46685_, double p_46686_, double p_46687_, double p_46688_, double p_46689_, double p_46690_) {
    }

    public void m_6485_(ParticleOptions p_46691_, boolean p_46692_, double p_46693_, double p_46694_, double p_46695_, double p_46696_, double p_46697_, double p_46698_) {
    }

    public float m_46490_(float p_46491_) {
        float f = this.m_46942_(p_46491_);
        return f * ((float)Math.PI * 2);
    }

    public void m_151525_(TickingBlockEntity p_151526_) {
        (this.f_151504_ ? this.f_151503_ : this.f_151512_).add(p_151526_);
    }

    public void addFreshBlockEntities(Collection<BlockEntity> beList) {
        if (this.f_151504_) {
            this.pendingFreshBlockEntities.addAll(beList);
        } else {
            this.freshBlockEntities.addAll(beList);
        }
    }

    protected void m_46463_() {
        ProfilerFiller profilerfiller = this.m_46473_();
        profilerfiller.m_6180_("blockEntities");
        if (!this.pendingFreshBlockEntities.isEmpty()) {
            this.freshBlockEntities.addAll(this.pendingFreshBlockEntities);
            this.pendingFreshBlockEntities.clear();
        }
        this.f_151504_ = true;
        if (!this.freshBlockEntities.isEmpty()) {
            this.freshBlockEntities.forEach(IForgeBlockEntity::onLoad);
            this.freshBlockEntities.clear();
        }
        if (!this.f_151503_.isEmpty()) {
            this.f_151512_.addAll(this.f_151503_);
            this.f_151503_.clear();
        }
        Iterator<TickingBlockEntity> iterator = this.f_151512_.iterator();
        while (iterator.hasNext()) {
            TickingBlockEntity tickingblockentity = iterator.next();
            if (tickingblockentity.m_142220_()) {
                iterator.remove();
                continue;
            }
            if (!this.m_183438_(ChunkPos.m_151388_((BlockPos)tickingblockentity.m_142689_()))) continue;
            tickingblockentity.m_142224_();
        }
        this.f_151504_ = false;
        profilerfiller.m_7238_();
    }

    public <T extends Entity> void m_46653_(Consumer<T> p_46654_, T p_46655_) {
        try {
            TimeTracker.ENTITY_UPDATE.trackStart(p_46655_);
            p_46654_.accept(p_46655_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Ticking entity");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being ticked");
            p_46655_.m_7976_(crashreportcategory);
            throw new ReportedException(crashreport);
        }
        finally {
            TimeTracker.ENTITY_UPDATE.trackEnd(p_46655_);
        }
    }

    public boolean m_183599_(Entity p_186458_) {
        return true;
    }

    public boolean m_183438_(long p_186456_) {
        return true;
    }

    public Explosion m_46511_(@Nullable Entity p_46512_, double p_46513_, double p_46514_, double p_46515_, float p_46516_, Explosion.BlockInteraction p_46517_) {
        return this.m_7703_(p_46512_, null, null, p_46513_, p_46514_, p_46515_, p_46516_, false, p_46517_);
    }

    public Explosion m_46518_(@Nullable Entity p_46519_, double p_46520_, double p_46521_, double p_46522_, float p_46523_, boolean p_46524_, Explosion.BlockInteraction p_46525_) {
        return this.m_7703_(p_46519_, null, null, p_46520_, p_46521_, p_46522_, p_46523_, p_46524_, p_46525_);
    }

    public Explosion m_7703_(@Nullable Entity p_46526_, @Nullable DamageSource p_46527_, @Nullable ExplosionDamageCalculator p_46528_, double p_46529_, double p_46530_, double p_46531_, float p_46532_, boolean p_46533_, Explosion.BlockInteraction p_46534_) {
        Explosion explosion = new Explosion(this, p_46526_, p_46527_, p_46528_, p_46529_, p_46530_, p_46531_, p_46532_, p_46533_, p_46534_);
        if (ForgeEventFactory.onExplosionStart((Level)this, (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }

    public abstract String m_46464_();

    @Nullable
    public BlockEntity m_7702_(BlockPos p_46716_) {
        if (this.m_151570_(p_46716_)) {
            return null;
        }
        return !this.f_46443_ && Thread.currentThread() != this.f_46423_ ? null : this.m_46745_(p_46716_).m_5685_(p_46716_, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public void m_151523_(BlockEntity p_151524_) {
        BlockPos blockpos = p_151524_.m_58899_();
        if (!this.m_151570_(blockpos)) {
            this.m_46745_(blockpos).m_142170_(p_151524_);
        }
    }

    public void m_46747_(BlockPos p_46748_) {
        if (!this.m_151570_(p_46748_)) {
            this.m_46745_(p_46748_).m_8114_(p_46748_);
        }
        this.m_46717_(p_46748_, this.m_8055_(p_46748_).m_60734_());
    }

    public boolean m_46749_(BlockPos p_46750_) {
        return this.m_151570_(p_46750_) ? false : this.m_7726_().m_5563_(SectionPos.m_123171_((int)p_46750_.m_123341_()), SectionPos.m_123171_((int)p_46750_.m_123343_()));
    }

    public boolean m_46578_(BlockPos p_46579_, Entity p_46580_, Direction p_46581_) {
        if (this.m_151570_(p_46579_)) {
            return false;
        }
        ChunkAccess chunkaccess = this.m_6522_(SectionPos.m_123171_((int)p_46579_.m_123341_()), SectionPos.m_123171_((int)p_46579_.m_123343_()), ChunkStatus.f_62326_, false);
        return chunkaccess == null ? false : chunkaccess.m_8055_(p_46579_).m_60638_((BlockGetter)((Object)this), p_46579_, p_46580_, p_46581_);
    }

    public boolean m_46575_(BlockPos p_46576_, Entity p_46577_) {
        return this.m_46578_(p_46576_, p_46577_, Direction.UP);
    }

    public void m_46465_() {
        double d0 = 1.0 - (double)(this.m_46722_(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.m_46661_(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.m_14008_((double)Mth.m_14089_((float)(this.m_46942_(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
        this.f_46425_ = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void m_46703_(boolean p_46704_, boolean p_46705_) {
        this.m_7726_().m_6707_(p_46704_, p_46705_);
    }

    protected void m_46466_() {
        if (this.f_46442_.m_6533_()) {
            this.f_46438_ = 1.0f;
            if (this.f_46442_.m_6534_()) {
                this.f_46440_ = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.m_7726_().close();
    }

    @Nullable
    public BlockGetter m_7925_(int p_46711_, int p_46712_) {
        return this.m_6522_(p_46711_, p_46712_, ChunkStatus.f_62326_, false);
    }

    public List<Entity> m_6249_(@Nullable Entity p_46536_, AABB p_46537_, Predicate<? super Entity> p_46538_) {
        this.m_46473_().m_6174_("getEntities");
        ArrayList list = Lists.newArrayList();
        this.m_142646_().m_142232_(p_46537_, p_151522_ -> {
            if (p_151522_ != p_46536_ && p_46538_.test((Entity)((Object)p_151522_))) {
                list.add(p_151522_);
            }
            if (p_151522_.isMultipartEntity()) {
                for (PartEntity enderdragonpart : p_151522_.getParts()) {
                    if (p_151522_ == p_46536_ || !p_46538_.test((Entity)enderdragonpart)) continue;
                    list.add(enderdragonpart);
                }
            }
        });
        return list;
    }

    public <T extends Entity> List<T> m_142425_(EntityTypeTest<Entity, T> p_151528_, AABB p_151529_, Predicate<? super T> p_151530_) {
        this.m_46473_().m_6174_("getEntities");
        ArrayList list = Lists.newArrayList();
        this.m_142646_().m_142137_(p_151528_, p_151529_, p_151539_ -> {
            if (p_151530_.test(p_151539_)) {
                list.add(p_151539_);
            }
            if (p_151539_.isMultipartEntity()) {
                for (PartEntity enderdragonpart : p_151539_.getParts()) {
                    Entity t = (Entity)((Object)((Object)p_151528_.m_141992_((Object)enderdragonpart)));
                    if (t == null || !p_151530_.test(t)) continue;
                    list.add(t);
                }
            }
        });
        return list;
    }

    @Nullable
    public abstract Entity m_6815_(int var1);

    public void m_151543_(BlockPos p_151544_) {
        if (this.m_46805_(p_151544_)) {
            this.m_46745_(p_151544_).m_8092_(true);
        }
        this.m_46717_(p_151544_, this.m_8055_(p_151544_).m_60734_());
    }

    public int m_5736_() {
        return 63;
    }

    public int m_46751_(BlockPos p_46752_) {
        int i = 0;
        if ((i = Math.max(i, this.m_46852_(p_46752_.m_7495_(), Direction.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.m_46852_(p_46752_.m_7494_(), Direction.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.m_46852_(p_46752_.m_142127_(), Direction.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.m_46852_(p_46752_.m_142128_(), Direction.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.m_46852_(p_46752_.m_142125_(), Direction.WEST))) >= 15) {
            return i;
        }
        return (i = Math.max(i, this.m_46852_(p_46752_.m_142126_(), Direction.EAST))) >= 15 ? i : i;
    }

    public boolean m_46616_(BlockPos p_46617_, Direction p_46618_) {
        return this.m_46681_(p_46617_, p_46618_) > 0;
    }

    public int m_46681_(BlockPos p_46682_, Direction p_46683_) {
        BlockState blockstate = this.m_8055_(p_46682_);
        int i = blockstate.m_60746_((BlockGetter)((Object)this), p_46682_, p_46683_);
        return blockstate.shouldCheckWeakPower((LevelReader)((Object)this), p_46682_, p_46683_) ? Math.max(i, this.m_46751_(p_46682_)) : i;
    }

    public boolean m_46753_(BlockPos p_46754_) {
        if (this.m_46681_(p_46754_.m_7495_(), Direction.DOWN) > 0) {
            return true;
        }
        if (this.m_46681_(p_46754_.m_7494_(), Direction.UP) > 0) {
            return true;
        }
        if (this.m_46681_(p_46754_.m_142127_(), Direction.NORTH) > 0) {
            return true;
        }
        if (this.m_46681_(p_46754_.m_142128_(), Direction.SOUTH) > 0) {
            return true;
        }
        if (this.m_46681_(p_46754_.m_142125_(), Direction.WEST) > 0) {
            return true;
        }
        return this.m_46681_(p_46754_.m_142126_(), Direction.EAST) > 0;
    }

    public int m_46755_(BlockPos p_46756_) {
        int i = 0;
        for (Direction direction : f_46422_) {
            int j = this.m_46681_(p_46756_.m_142300_(direction), direction);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public void m_7462_() {
    }

    public long m_46467_() {
        return this.f_46442_.m_6793_();
    }

    public long m_46468_() {
        return this.f_46442_.m_6792_();
    }

    public boolean m_7966_(Player p_46557_, BlockPos p_46558_) {
        return true;
    }

    public void m_7605_(Entity p_46509_, byte p_46510_) {
    }

    public void m_7696_(BlockPos p_46582_, Block p_46583_, int p_46584_, int p_46585_) {
        this.m_8055_(p_46582_).m_60677_(this, p_46582_, p_46584_, p_46585_);
    }

    public LevelData m_6106_() {
        return this.f_46442_;
    }

    public GameRules m_46469_() {
        return this.f_46442_.m_5470_();
    }

    public float m_46661_(float p_46662_) {
        return Mth.m_14179_((float)p_46662_, (float)this.f_46439_, (float)this.f_46440_) * this.m_46722_(p_46662_);
    }

    public void m_46707_(float p_46708_) {
        float f;
        this.f_46439_ = f = Mth.m_14036_((float)p_46708_, (float)0.0f, (float)1.0f);
        this.f_46440_ = f;
    }

    public float m_46722_(float p_46723_) {
        return Mth.m_14179_((float)p_46723_, (float)this.f_46437_, (float)this.f_46438_);
    }

    public void m_46734_(float p_46735_) {
        float f;
        this.f_46437_ = f = Mth.m_14036_((float)p_46735_, (float)0.0f, (float)1.0f);
        this.f_46438_ = f;
    }

    public boolean m_46470_() {
        if (this.m_6042_().m_63935_() && !this.m_6042_().m_63946_()) {
            return (double)this.m_46661_(1.0f) > 0.9;
        }
        return false;
    }

    public boolean m_46471_() {
        return (double)this.m_46722_(1.0f) > 0.2;
    }

    public boolean m_46758_(BlockPos p_46759_) {
        if (!this.m_46471_()) {
            return false;
        }
        if (!this.m_45527_(p_46759_)) {
            return false;
        }
        if (this.m_5452_(Heightmap.Types.MOTION_BLOCKING, p_46759_).m_123342_() > p_46759_.m_123342_()) {
            return false;
        }
        Biome biome = this.m_46857_(p_46759_);
        return biome.m_47530_() == Biome.Precipitation.RAIN && biome.m_198906_(p_46759_);
    }

    public boolean m_46761_(BlockPos p_46762_) {
        Biome biome = this.m_46857_(p_46762_);
        return biome.m_47533_();
    }

    @Nullable
    public abstract MapItemSavedData m_7489_(String var1);

    public abstract void m_142325_(String var1, MapItemSavedData var2);

    public abstract int m_7354_();

    public void m_6798_(int p_46665_, BlockPos p_46666_, int p_46667_) {
    }

    public CrashReportCategory m_6026_(CrashReport p_46656_) {
        CrashReportCategory crashreportcategory = p_46656_.m_127516_("Affected level", 1);
        crashreportcategory.m_128165_("All players", (CrashReportDetail<String>)((CrashReportDetail)() -> this.m_6907_().size() + " total; " + this.m_6907_()));
        crashreportcategory.m_128165_("Chunk stats", (CrashReportDetail<String>)((CrashReportDetail)() -> ((ChunkSource)this.m_7726_()).m_6754_()));
        crashreportcategory.m_128165_("Level dimension", (CrashReportDetail<String>)((CrashReportDetail)() -> this.m_46472_().m_135782_().toString()));
        try {
            this.f_46442_.m_142471_(crashreportcategory, (LevelHeightAccessor)this);
        }
        catch (Throwable throwable) {
            crashreportcategory.m_128162_("Level Data Unobtainable", throwable);
        }
        return crashreportcategory;
    }

    public abstract void m_6801_(int var1, BlockPos var2, int var3);

    public void m_7228_(double p_46475_, double p_46476_, double p_46477_, double p_46478_, double p_46479_, double p_46480_, @Nullable CompoundTag p_46481_) {
    }

    public abstract Scoreboard m_6188_();

    public void m_46717_(BlockPos p_46718_, Block p_46719_) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = p_46718_.m_142300_(direction);
            if (!this.m_46805_(blockpos)) continue;
            BlockState blockstate = this.m_8055_(blockpos);
            blockstate.onNeighborChange((LevelReader)((Object)this), blockpos, p_46718_);
            if (!blockstate.m_60796_((BlockGetter)((Object)this), blockpos) || !(blockstate = this.m_8055_(blockpos = blockpos.m_142300_(direction))).getWeakChanges((LevelReader)((Object)this), blockpos)) continue;
            blockstate.m_60690_(this, blockpos, p_46719_, p_46718_, false);
        }
    }

    public DifficultyInstance m_6436_(BlockPos p_46730_) {
        long i = 0L;
        float f = 0.0f;
        if (this.m_46805_(p_46730_)) {
            f = this.m_46940_();
            i = this.m_46745_(p_46730_).m_6319_();
        }
        return new DifficultyInstance(this.m_46791_(), this.m_46468_(), i, f);
    }

    public int m_7445_() {
        return this.f_46425_;
    }

    public void m_6580_(int p_46709_) {
    }

    public WorldBorder m_6857_() {
        return this.f_46447_;
    }

    public void m_5503_(Packet<?> p_46657_) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    public DimensionType m_6042_() {
        return this.f_46445_;
    }

    public ResourceKey<Level> m_46472_() {
        return this.f_46421_;
    }

    public Random m_5822_() {
        return this.f_46441_;
    }

    public boolean m_7433_(BlockPos p_46620_, Predicate<BlockState> p_46621_) {
        return p_46621_.test(this.m_8055_(p_46620_));
    }

    public boolean m_142433_(BlockPos p_151541_, Predicate<FluidState> p_151542_) {
        return p_151542_.test(this.m_6425_(p_151541_));
    }

    public abstract RecipeManager m_7465_();

    public abstract TagContainer m_5999_();

    public BlockPos m_46496_(int p_46497_, int p_46498_, int p_46499_, int p_46500_) {
        this.f_46435_ = this.f_46435_ * 3 + 1013904223;
        int i = this.f_46435_ >> 2;
        return new BlockPos(p_46497_ + (i & 0xF), p_46498_ + (i >> 16 & p_46500_), p_46499_ + (i >> 8 & 0xF));
    }

    public boolean m_7441_() {
        return false;
    }

    public ProfilerFiller m_46473_() {
        return this.f_46446_.get();
    }

    public Supplier<ProfilerFiller> m_46658_() {
        return this.f_46446_;
    }

    public BiomeManager m_7062_() {
        return this.f_46420_;
    }

    public double getMaxEntityRadius() {
        return this.maxEntityRadius;
    }

    public double increaseMaxEntityRadius(double value) {
        if (value > this.maxEntityRadius) {
            this.maxEntityRadius = value;
        }
        return this.maxEntityRadius;
    }

    public final boolean m_46659_() {
        return this.f_46424_;
    }

    protected abstract LevelEntityGetter<Entity> m_142646_();

    protected void m_151513_(@Nullable Entity p_151514_, GameEvent p_151515_, BlockPos p_151516_, int p_151517_) {
        int i = SectionPos.m_123171_((int)(p_151516_.m_123341_() - p_151517_));
        int j = SectionPos.m_123171_((int)(p_151516_.m_123343_() - p_151517_));
        int k = SectionPos.m_123171_((int)(p_151516_.m_123341_() + p_151517_));
        int l = SectionPos.m_123171_((int)(p_151516_.m_123343_() + p_151517_));
        int i1 = SectionPos.m_123171_((int)(p_151516_.m_123342_() - p_151517_));
        int j1 = SectionPos.m_123171_((int)(p_151516_.m_123342_() + p_151517_));
        for (int k1 = i; k1 <= k; ++k1) {
            for (int l1 = j; l1 <= l; ++l1) {
                LevelChunk chunkaccess = this.m_7726_().m_7131_(k1, l1);
                if (chunkaccess == null) continue;
                for (int i2 = i1; i2 <= j1; ++i2) {
                    ((ChunkAccess)chunkaccess).m_142336_(i2).m_142666_(p_151515_, p_151514_, p_151516_);
                }
            }
        }
    }

    public long m_183596_() {
        return this.f_186455_++;
    }

    public boolean m_183414_(Entity.RemovalReason p_186457_) {
        return false;
    }
}

