/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SetTag;
import net.minecraft.tags.StaticTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.tags.TagContainer;
import net.minecraftforge.common.Tags;

public class StaticTagHelper<T> {
    private final ResourceKey<? extends Registry<T>> f_144326_;
    private final String f_144327_;
    private TagCollection<T> f_13227_ = TagCollection.m_13410_();
    private final List<Wrapper<T>> f_13228_ = Lists.newArrayList();
    @Nullable
    private static Map<ResourceLocation, List<Wrapper<?>>> toAdd = Maps.newHashMap();

    public StaticTagHelper(ResourceKey<? extends Registry<T>> p_144329_, String p_144330_) {
        this.f_144326_ = p_144329_;
        this.f_144327_ = p_144330_;
    }

    public Tag.Named<T> m_13244_(String p_13245_) {
        return this.add(new Wrapper(new ResourceLocation(p_13245_)));
    }

    public Tags.IOptionalNamedTag<T> createOptional(ResourceLocation key, @Nullable Set<Supplier<T>> defaults) {
        return this.add(new OptionalNamedTag<T>(key, defaults));
    }

    public static <T> Tag.Named<T> createDelayedTag(ResourceLocation tagRegistry, ResourceLocation name) {
        return StaticTagHelper.delayedAdd(tagRegistry, new Wrapper(name));
    }

    public static <T> Tags.IOptionalNamedTag<T> createDelayedOptional(ResourceLocation tagRegistry, ResourceLocation key, @Nullable Set<Supplier<T>> defaults) {
        return StaticTagHelper.delayedAdd(tagRegistry, new OptionalNamedTag<T>(key, defaults));
    }

    private static synchronized <T, R extends Wrapper<T>> R delayedAdd(ResourceLocation tagRegistry, R tag) {
        if (toAdd == null) {
            throw new RuntimeException("Creating delayed tags or optional tags, is only supported before custom tag types have been added.");
        }
        toAdd.computeIfAbsent(tagRegistry, registry -> Lists.newArrayList()).add(tag);
        return tag;
    }

    public static void performDelayedAdd() {
        if (toAdd != null) {
            for (Map.Entry<ResourceLocation, List<Wrapper<?>>> entry : toAdd.entrySet()) {
                StaticTagHelper<?> tagRegistry = StaticTags.get(entry.getKey());
                if (tagRegistry == null) {
                    throw new RuntimeException("A mod attempted to add a delayed tag for a registry that doesn't have custom tag support.");
                }
                for (Wrapper<?> tag : entry.getValue()) {
                    tagRegistry.add(tag);
                }
            }
            toAdd = null;
        }
    }

    private <R extends Wrapper<T>> R add(R namedtag) {
        namedtag.m_13260_(arg_0 -> this.f_13227_.m_13404_(arg_0));
        this.f_13228_.add(namedtag);
        return namedtag;
    }

    public TagCollection<T> reinjectOptionalTags(TagCollection<T> tagCollection) {
        Map currentTags = tagCollection.m_5643_();
        Map<ResourceLocation, Tag> missingOptionals = this.f_13228_.stream().filter(e -> e instanceof OptionalNamedTag && !currentTags.containsKey(e.m_6979_())).collect(Collectors.toMap(Wrapper::m_6979_, namedTag -> {
            OptionalNamedTag optionalNamedTag = (OptionalNamedTag)namedTag;
            optionalNamedTag.defaulted = true;
            return optionalNamedTag.resolveDefaulted();
        }, (existingTag, newTag) -> SetTag.m_13222_((Set)ImmutableSet.builder().addAll(existingTag.m_6497_()).addAll(newTag.m_6497_()).build())));
        if (!missingOptionals.isEmpty()) {
            missingOptionals.putAll(currentTags);
            return TagCollection.m_13396_(missingOptionals);
        }
        return tagCollection;
    }

    public void m_13232_() {
        this.f_13227_ = TagCollection.m_13410_();
        SetTag tag = SetTag.m_13216_();
        this.f_13228_.forEach(arg_0 -> StaticTagHelper.lambda$resetToEmpty$5((Tag)tag, arg_0));
    }

    public void m_13242_(TagContainer p_13243_) {
        TagCollection tagcollection = p_13243_.m_144452_(this.f_144326_);
        this.f_13227_ = tagcollection;
        this.f_13228_.forEach(p_13241_ -> p_13241_.m_13260_(arg_0 -> ((TagCollection)tagcollection).m_13404_(arg_0)));
    }

    public TagCollection<T> m_13246_() {
        return this.f_13227_;
    }

    public Set<ResourceLocation> m_13247_(TagContainer p_13248_) {
        TagCollection tagcollection = p_13248_.m_144452_(this.f_144326_);
        Set set = this.f_13228_.stream().filter(e -> !(e instanceof OptionalNamedTag)).map(Wrapper::m_6979_).collect(Collectors.toSet());
        ImmutableSet immutableset = ImmutableSet.copyOf((Collection)tagcollection.m_13406_());
        return Sets.difference(set, (Set)immutableset);
    }

    public ResourceKey<? extends Registry<T>> m_144338_() {
        return this.f_144326_;
    }

    public String m_144339_() {
        return this.f_144327_;
    }

    protected void m_144336_(TagContainer.Builder p_144337_) {
        p_144337_.m_144486_(this.f_144326_, TagCollection.m_13396_(this.f_13228_.stream().distinct().collect(Collectors.toMap(Tag.Named::m_6979_, p_144332_ -> p_144332_))));
    }

    private static /* synthetic */ void lambda$resetToEmpty$5(Tag tag, Wrapper p_13235_) {
        p_13235_.m_13260_(p_144335_ -> tag);
    }

    static class Wrapper<T>
    implements Tag.Named<T> {
        @Nullable
        protected Tag<T> f_13251_;
        protected final ResourceLocation f_13250_;

        Wrapper(ResourceLocation p_13253_) {
            this.f_13250_ = p_13253_;
        }

        @Override
        public ResourceLocation m_6979_() {
            return this.f_13250_;
        }

        private Tag<T> m_13263_() {
            if (this.f_13251_ == null) {
                throw new IllegalStateException("Tag " + this.f_13250_ + " used before it was bound");
            }
            return this.f_13251_;
        }

        void m_13260_(Function<ResourceLocation, Tag<T>> p_13261_) {
            this.f_13251_ = p_13261_.apply(this.f_13250_);
        }

        @Override
        public boolean m_8110_(T p_13259_) {
            return this.m_13263_().m_8110_(p_13259_);
        }

        @Override
        public List<T> m_6497_() {
            return this.m_13263_().m_6497_();
        }

        public String toString() {
            return "NamedTag[" + this.m_6979_() + "]";
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Tag.Named && Objects.equals(this.m_6979_(), ((Tag.Named)o).m_6979_());
        }

        public int hashCode() {
            return this.m_6979_().hashCode();
        }
    }

    private static class OptionalNamedTag<T>
    extends Wrapper<T>
    implements Tags.IOptionalNamedTag<T> {
        @Nullable
        private final Set<Supplier<T>> defaults;
        private boolean defaulted = false;

        private OptionalNamedTag(ResourceLocation name, @Nullable Set<Supplier<T>> defaults) {
            super(name);
            this.defaults = defaults;
        }

        public boolean isDefaulted() {
            return this.defaulted;
        }

        SetTag<T> resolveDefaulted() {
            if (this.defaults == null || this.defaults.isEmpty()) {
                return SetTag.m_13216_();
            }
            return SetTag.m_13222_((Set)ImmutableSet.copyOf((Collection)this.defaults.stream().map(Supplier::get).collect(Collectors.toSet())));
        }

        @Override
        public String toString() {
            return "OptionalNamedTag[" + this.m_6979_() + "]";
        }
    }
}

