/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screens.CreateFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class WorldPreset {
    public static final WorldPreset f_101506_ = new WorldPreset("default"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194096_, long p_194097_) {
            return WorldGenSettings.m_190027_(p_194096_, p_194097_);
        }
    };
    private static final WorldPreset f_101510_ = new WorldPreset("flat"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194099_, long p_194100_) {
            return new FlatLevelSource(FlatLevelGeneratorSettings.m_70376_(p_194099_.m_175515_(Registry.f_122885_)));
        }
    };
    public static final WorldPreset f_101511_ = new WorldPreset("large_biomes"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194102_, long p_194103_) {
            return WorldGenSettings.m_190030_(p_194102_, p_194103_, NoiseGeneratorSettings.f_188869_);
        }
    };
    public static final WorldPreset f_101507_ = new WorldPreset("amplified"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194105_, long p_194106_) {
            return WorldGenSettings.m_190030_(p_194105_, p_194106_, NoiseGeneratorSettings.f_64433_);
        }
    };
    private static final WorldPreset f_101512_ = new WorldPreset("single_biome_surface"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194108_, long p_194109_) {
            return WorldPreset.m_194085_(p_194108_, p_194109_, NoiseGeneratorSettings.f_64432_);
        }
    };
    private static final WorldPreset f_101515_ = new WorldPreset("debug_all_block_states"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194111_, long p_194112_) {
            return new DebugLevelSource(p_194111_.m_175515_(Registry.f_122885_));
        }
    };
    protected static final List<WorldPreset> f_101508_ = Lists.newArrayList((Object[])new WorldPreset[]{f_101506_, f_101510_, f_101511_, f_101507_, f_101512_, f_101515_});
    protected static final Map<Optional<WorldPreset>, PresetEditor> f_101509_ = ImmutableMap.of(Optional.of(f_101510_), (p_194093_, p_194094_) -> {
        ChunkGenerator chunkgenerator = p_194094_.m_64666_();
        return new CreateFlatWorldScreen(p_194093_, p_194080_ -> p_194093_.f_100847_.m_101404_(new WorldGenSettings(p_194094_.m_64619_(), p_194094_.m_64657_(), p_194094_.m_64660_(), WorldGenSettings.m_64633_(p_194093_.f_100847_.m_101456_().m_175515_(Registry.f_122818_), p_194094_.m_64663_(), (ChunkGenerator)new FlatLevelSource(p_194080_)))), chunkgenerator instanceof FlatLevelSource ? ((FlatLevelSource)chunkgenerator).m_64191_() : FlatLevelGeneratorSettings.m_70376_(p_194093_.f_100847_.m_101456_().m_175515_(Registry.f_122885_)));
    }, Optional.of(f_101512_), (p_194071_, p_194072_) -> new CreateBuffetWorldScreen((Screen)p_194071_, (RegistryAccess)p_194071_.f_100847_.m_101456_(), p_194076_ -> p_194071_.f_100847_.m_101404_(WorldPreset.m_101549_(p_194071_.f_100847_.m_101456_(), p_194072_, f_101512_, p_194076_)), WorldPreset.m_101546_(p_194071_.f_100847_.m_101456_(), p_194072_)));
    private final Component f_101516_;

    static NoiseBasedChunkGenerator m_194085_(RegistryAccess p_194086_, long p_194087_, ResourceKey<NoiseGeneratorSettings> p_194088_) {
        return new NoiseBasedChunkGenerator(p_194086_.m_175515_(Registry.f_194568_), (BiomeSource)new FixedBiomeSource(p_194086_.m_175515_(Registry.f_122885_).m_123013_(Biomes.f_48202_)), p_194087_, () -> p_194086_.m_175515_(Registry.f_122878_).m_123013_(p_194088_));
    }

    WorldPreset(String p_101519_) {
        this.f_101516_ = new TranslatableComponent("generator." + p_101519_);
    }

    public WorldPreset(Component displayName) {
        this.f_101516_ = displayName;
    }

    private static WorldGenSettings m_101549_(RegistryAccess p_101550_, WorldGenSettings p_101551_, WorldPreset p_101552_, Biome p_101553_) {
        FixedBiomeSource biomesource = new FixedBiomeSource(p_101553_);
        Registry<DimensionType> registry = p_101550_.m_175515_(Registry.f_122818_);
        Registry<NoiseGeneratorSettings> registry1 = p_101550_.m_175515_(Registry.f_122878_);
        Supplier<NoiseGeneratorSettings> supplier = () -> (NoiseGeneratorSettings)registry1.m_123013_(NoiseGeneratorSettings.f_64432_);
        return new WorldGenSettings(p_101551_.m_64619_(), p_101551_.m_64657_(), p_101551_.m_64660_(), WorldGenSettings.m_64633_(registry, p_101551_.m_64663_(), new NoiseBasedChunkGenerator(p_101550_.m_175515_(Registry.f_194568_), (BiomeSource)biomesource, p_101551_.m_64619_(), supplier)));
    }

    private static Biome m_101546_(RegistryAccess p_101547_, WorldGenSettings p_101548_) {
        return p_101548_.m_64666_().m_62218_().m_196676_().stream().findFirst().orElse(p_101547_.m_175515_(Registry.f_122885_).m_123013_(Biomes.f_48202_));
    }

    public static Optional<WorldPreset> m_101524_(WorldGenSettings p_101525_) {
        ChunkGenerator chunkgenerator = p_101525_.m_64666_();
        if (chunkgenerator instanceof FlatLevelSource) {
            return Optional.of(f_101510_);
        }
        return chunkgenerator instanceof DebugLevelSource ? Optional.of(f_101515_) : Optional.empty();
    }

    public Component m_101523_() {
        return this.f_101516_;
    }

    public WorldGenSettings m_7012_(RegistryAccess.RegistryHolder p_101542_, long p_101543_, boolean p_101544_, boolean p_101545_) {
        return new WorldGenSettings(p_101543_, p_101544_, p_101545_, WorldGenSettings.m_64633_(p_101542_.m_175515_(Registry.f_122818_), DimensionType.m_188317_((RegistryAccess)p_101542_, (long)p_101543_), this.m_183349_(p_101542_, p_101543_)));
    }

    protected abstract ChunkGenerator m_183349_(RegistryAccess var1, long var2);

    public static boolean m_170301_(WorldPreset p_170302_) {
        return p_170302_ != f_101515_;
    }

    public static void registerGenerator(WorldPreset gen) {
        f_101508_.add(gen);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface PresetEditor {
        public Screen m_101642_(CreateWorldScreen var1, WorldGenSettings var2);
    }
}

