/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.EffectRenderer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class EffectRenderingInventoryScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    boolean cancelShift = false;

    public EffectRenderingInventoryScreen(T p_98701_, Inventory p_98702_, Component p_98703_) {
        super(p_98701_, p_98702_, p_98703_);
    }

    @Override
    public void m_6305_(PoseStack p_98705_, int p_98706_, int p_98707_, float p_98708_) {
        super.m_6305_(p_98705_, p_98706_, p_98707_, p_98708_);
        this.m_194014_(p_98705_, p_98706_, p_98707_);
    }

    public boolean m_194018_() {
        int i = this.cancelShift ? (this.f_96543_ - this.f_97726_) / 2 : this.f_97735_ + this.f_97726_ + 2;
        int j = this.f_96543_ - i;
        return j >= 32;
    }

    private void m_194014_(PoseStack p_194015_, int p_194016_, int p_194017_) {
        int i = this.cancelShift ? (this.f_96543_ - this.f_97726_) / 2 : this.f_97735_ + this.f_97726_ + 2;
        int j = this.f_96543_ - i;
        Collection<MobEffectInstance> collection = this.f_96541_.f_91074_.m_21220_();
        if (!collection.isEmpty() && j >= 32) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean flag = j >= 120;
            int k = 33;
            if (collection.size() > 5) {
                k = 132 / (collection.size() - 1);
            }
            Iterable iterable = collection.stream().filter(ForgeHooksClient::shouldRenderEffect).sorted().collect(Collectors.toList());
            this.m_194002_(p_194015_, i, k, iterable, flag);
            this.m_194008_(p_194015_, i, k, iterable, flag);
            if (flag) {
                this.m_98722_(p_194015_, i, k, iterable);
            } else if (p_194016_ >= i && p_194016_ <= i + 33) {
                int l = this.f_97736_;
                MobEffectInstance mobeffectinstance = null;
                for (MobEffectInstance mobeffectinstance1 : iterable) {
                    if (p_194017_ >= l && p_194017_ <= l + k) {
                        mobeffectinstance = mobeffectinstance1;
                    }
                    l += k;
                }
                if (mobeffectinstance != null) {
                    List<TextComponent> list = List.of(this.m_194000_(mobeffectinstance), new TextComponent(MobEffectUtil.m_19581_(mobeffectinstance, (float)1.0f)));
                    this.m_169388_(p_194015_, list, Optional.empty(), p_194016_, p_194017_);
                }
            }
        }
    }

    private void m_194002_(PoseStack p_194003_, int p_194004_, int p_194005_, Iterable<MobEffectInstance> p_194006_, boolean p_194007_) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_97725_);
        int i = this.f_97736_;
        for (MobEffectInstance mobeffectinstance : p_194006_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (p_194007_) {
                this.m_93228_(p_194003_, p_194004_, i, 0, 166, 120, 32);
            } else {
                this.m_93228_(p_194003_, p_194004_, i, 0, 198, 32, 32);
            }
            i += p_194005_;
        }
    }

    private void m_194008_(PoseStack p_194009_, int p_194010_, int p_194011_, Iterable<MobEffectInstance> p_194012_, boolean p_194013_) {
        MobEffectTextureManager mobeffecttexturemanager = this.f_96541_.m_91306_();
        int i = this.f_97736_;
        for (MobEffectInstance mobeffectinstance : p_194012_) {
            MobEffect mobeffect = mobeffectinstance.m_19544_();
            TextureAtlasSprite textureatlassprite = mobeffecttexturemanager.m_118732_(mobeffect);
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
            EffectRenderingInventoryScreen.m_93200_((PoseStack)p_194009_, (int)(p_194010_ + (p_194013_ ? 6 : 7)), (int)(i + 7), (int)this.m_93252_(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            i += p_194011_;
        }
    }

    private void m_98722_(PoseStack p_98723_, int p_98724_, int p_98725_, Iterable<MobEffectInstance> p_98726_) {
        int i = this.f_97736_;
        for (MobEffectInstance mobeffectinstance : p_98726_) {
            EffectRenderer renderer = RenderProperties.getEffectRenderer((MobEffectInstance)mobeffectinstance);
            renderer.renderInventoryEffect(mobeffectinstance, this, p_98723_, p_98724_, i, (float)this.m_93252_());
            if (!renderer.shouldRenderInvText(mobeffectinstance)) {
                i += p_98725_;
                continue;
            }
            Component component = this.m_194000_(mobeffectinstance);
            this.f_96547_.m_92763_(p_98723_, component, (float)(p_98724_ + 10 + 18), (float)(i + 6), 0xFFFFFF);
            String s = MobEffectUtil.m_19581_((MobEffectInstance)mobeffectinstance, (float)1.0f);
            this.f_96547_.m_92750_(p_98723_, s, (float)(p_98724_ + 10 + 18), (float)(i + 6 + 10), 0x7F7F7F);
            i += p_98725_;
        }
    }

    private Component m_194000_(MobEffectInstance p_194001_) {
        MutableComponent mutablecomponent = p_194001_.m_19544_().m_19482_().m_6881_();
        if (p_194001_.m_19564_() >= 1 && p_194001_.m_19564_() <= 9) {
            mutablecomponent.m_130946_(" ").m_7220_((Component)new TranslatableComponent("enchantment.level." + (p_194001_.m_19564_() + 1)));
        }
        return mutablecomponent;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.cancelShift = MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.PotionShiftEvent((Screen)this));
    }
}

