/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.AdvancementLoadFix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementList {
    private static final Logger f_139325_ = LogManager.getLogger();
    private final Map<ResourceLocation, Advancement> f_139326_ = Maps.newHashMap();
    private final Set<Advancement> f_139327_ = Sets.newLinkedHashSet();
    private final Set<Advancement> f_139328_ = Sets.newLinkedHashSet();
    @Nullable
    private Listener f_139329_;

    private void m_139339_(Advancement p_139340_) {
        for (Advancement advancement : p_139340_.m_138322_()) {
            this.m_139339_(advancement);
        }
        f_139325_.info("Forgot about advancement {}", (Object)p_139340_.m_138327_());
        this.f_139326_.remove(p_139340_.m_138327_());
        if (p_139340_.m_138319_() == null) {
            this.f_139327_.remove(p_139340_);
            if (this.f_139329_ != null) {
                this.f_139329_.m_5504_(p_139340_);
            }
        } else {
            this.f_139328_.remove(p_139340_);
            if (this.f_139329_ != null) {
                this.f_139329_.m_5516_(p_139340_);
            }
        }
    }

    public void m_139335_(Set<ResourceLocation> p_139336_) {
        for (ResourceLocation resourcelocation : p_139336_) {
            Advancement advancement = this.f_139326_.get(resourcelocation);
            if (advancement == null) {
                f_139325_.warn("Told to remove advancement {} but I don't know what that is", (Object)resourcelocation);
                continue;
            }
            this.m_139339_(advancement);
        }
    }

    public void m_139333_(Map<ResourceLocation, Advancement.Builder> p_139334_) {
        HashMap map = Maps.newHashMap(p_139334_);
        while (!map.isEmpty()) {
            boolean flag = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
                Advancement.Builder advancement$builder = (Advancement.Builder)entry.getValue();
                if (!advancement$builder.m_138392_(this.f_139326_::get)) continue;
                Advancement advancement = advancement$builder.m_138403_(resourcelocation);
                this.f_139326_.put(resourcelocation, advancement);
                flag = true;
                iterator.remove();
                if (advancement.m_138319_() == null) {
                    this.f_139327_.add(advancement);
                    if (this.f_139329_ == null) continue;
                    this.f_139329_.m_5513_(advancement);
                    continue;
                }
                this.f_139328_.add(advancement);
                if (this.f_139329_ == null) continue;
                this.f_139329_.m_5505_(advancement);
            }
            if (flag) continue;
            for (Map.Entry entry1 : map.entrySet()) {
                f_139325_.error("Couldn't load advancement {}: {}", entry1.getKey(), entry1.getValue());
            }
        }
        AdvancementLoadFix.buildSortedTrees(this.f_139327_);
        f_139325_.info("Loaded {} advancements", (Object)this.f_139326_.size());
    }

    public void m_139332_() {
        this.f_139326_.clear();
        this.f_139327_.clear();
        this.f_139328_.clear();
        if (this.f_139329_ != null) {
            this.f_139329_.m_7204_();
        }
    }

    public Iterable<Advancement> m_139343_() {
        return this.f_139327_;
    }

    public Collection<Advancement> m_139344_() {
        return this.f_139326_.values();
    }

    @Nullable
    public Advancement m_139337_(ResourceLocation p_139338_) {
        return this.f_139326_.get(p_139338_);
    }

    public void m_139341_(@Nullable Listener p_139342_) {
        this.f_139329_ = p_139342_;
        if (p_139342_ != null) {
            for (Advancement advancement : this.f_139327_) {
                p_139342_.m_5513_(advancement);
            }
            for (Advancement advancement1 : this.f_139328_) {
                p_139342_.m_5505_(advancement1);
            }
        }
    }

    public static interface Listener {
        public void m_5513_(Advancement var1);

        public void m_5504_(Advancement var1);

        public void m_5505_(Advancement var1);

        public void m_5516_(Advancement var1);

        public void m_7204_();
    }
}

